/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.JsonPathLanguage;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateIntentionAction;", "Lcom/intellij/codeInsight/intention/AbstractIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "intellij.jsonpath"})
public final class JsonPathEvaluateIntentionAction
extends AbstractIntentionAction
implements HighPriorityAction,
Iconable {
    @NotNull
    public String getText() {
        String string = JsonPathBundle.message("jsonpath.evaluate.intention", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null) {
            return;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        String jsonPath = manager.isInjectedFragment(psiFile) ? manager.getUnescapedText((PsiElement)psiFile) : psiFile.getText();
        JsonPathEvaluateManager.Companion.getInstance(project).evaluateExpression(jsonPath);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || psiFile == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)psiFile.getLanguage(), (Object)((Object)JsonPathLanguage.INSTANCE)) && !Intrinsics.areEqual((Object)psiFile.getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY), (Object)true);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.FileTypes.Json;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Json");
        return icon;
    }
}

