/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.ArrayUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordBuilder;
import git4idea.history.GitLogRecordCollector;
import git4idea.history.GitLogUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u00011B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ?\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ4\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u0015JA\u0010!\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010$J7\u0010%\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010'J(\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0018\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 \u0012\u0004\u0012\u00020\u00130+H$J+\u0010,\u001a\u00028\u00012\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u0017H$\u00a2\u0006\u0002\u00100R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/history/GitDetailsCollector;", "R", "Lgit4idea/history/GitLogRecord;", "C", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "recordBuilder", "Lgit4idea/history/GitLogRecordBuilder;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lgit4idea/history/GitLogRecordBuilder;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "readFullDetails", "", "commitConsumer", "Ljava/util/function/Consumer;", "requirements", "Lgit4idea/history/GitCommitRequirements;", "lowPriorityProcess", "", "parameters", "", "", "(Ljava/util/function/Consumer;Lgit4idea/history/GitCommitRequirements;Z[Ljava/lang/String;)V", "readFullDetailsForHashes", "hashes", "", "readFullDetailsFromHandler", "handler", "Lgit4idea/commands/GitLineHandler;", "(Ljava/util/function/Consumer;Lgit4idea/commands/GitLineHandler;Lgit4idea/history/GitCommitRequirements;[Ljava/lang/String;)V", "readRecordsFromHandler", "converter", "(Lgit4idea/commands/GitLineHandler;Ljava/util/function/Consumer;[Ljava/lang/String;)V", "createRecordsCollector", "Lgit4idea/history/GitLogRecordCollector;", "consumer", "Lkotlin/Function1;", "createCommit", "records", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "(Ljava/util/List;Lcom/intellij/vcs/log/VcsLogObjectsFactory;Lgit4idea/history/GitCommitRequirements;)Lcom/intellij/vcs/log/VcsCommitMetadata;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDetailsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDetailsCollector.kt\ngit4idea/history/GitDetailsCollector\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,134:1\n27#2:135\n87#2,2:136\n28#2,3:138\n98#2:141\n90#2,6:142\n*S KotlinDebug\n*F\n+ 1 GitDetailsCollector.kt\ngit4idea/history/GitDetailsCollector\n*L\n92#1:135\n92#1:136,2\n92#1:138,3\n92#1:141\n92#1:142,6\n*E\n"})
public abstract class GitDetailsCollector<R extends GitLogRecord, C extends VcsCommitMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final GitLogRecordBuilder<R> recordBuilder;
    @NotNull
    private static final Logger LOG;

    public GitDetailsCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecordBuilder<R> recordBuilder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(recordBuilder, (String)"recordBuilder");
        this.project = project;
        this.root = root;
        this.recordBuilder = recordBuilder;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VirtualFile getRoot() {
        return this.root;
    }

    public final void readFullDetails(@NotNull Consumer<? super C> commitConsumer, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        List<String> configParameters = requirements.configParameters();
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, configParameters, lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"createGitHandler(...)");
        GitLineHandler handler = gitLineHandler;
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, Arrays.copyOf(parameters, parameters.length));
    }

    public final void readFullDetailsForHashes(@NotNull List<String> hashes, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, @NotNull Consumer<? super C> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        if (hashes.isEmpty()) {
            return;
        }
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, requirements.configParameters(), lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"createGitHandler(...)");
        GitLineHandler handler = gitLineHandler;
        GitLogUtil.sendHashesToStdin((Collection<String>)hashes, handler);
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)GitLogUtil.getNoWalkParameter(this.project), (String)"getNoWalkParameter(...)");
        stringArray[1] = "--stdin";
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, stringArray);
    }

    private final void readFullDetailsFromHandler(Consumer<? super C> commitConsumer, GitLineHandler handler, GitCommitRequirements requirements, String ... parameters) throws VcsException {
        VcsLogObjectsFactory vcsLogObjectsFactory = GitLogUtil.getObjectsFactoryWithDisposeCheck(this.project);
        if (vcsLogObjectsFactory == null) {
            return;
        }
        VcsLogObjectsFactory factory = vcsLogObjectsFactory;
        GitExecutable gitExecutable = handler.getExecutable();
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        String[] stringArray = ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray((Collection)requirements.commandParameters(this.project, gitExecutable)), (String[])Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeArrays(...)");
        String[] commandParameters = stringArray;
        if (requirements.getDiffInMergeCommits() == GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS) {
            Function1 consumer = arg_0 -> GitDetailsCollector.readFullDetailsFromHandler$lambda$0(commitConsumer, this, factory, requirements, arg_0);
            GitLogRecordCollector<R> recordCollector = this.createRecordsCollector(consumer);
            this.readRecordsFromHandler(handler, recordCollector, Arrays.copyOf(commandParameters, commandParameters.length));
            recordCollector.finish();
        } else {
            Consumer<GitLogRecord> consumer = arg_0 -> GitDetailsCollector.readFullDetailsFromHandler$lambda$1(commitConsumer, this, factory, requirements, arg_0);
            this.readRecordsFromHandler(handler, consumer, Arrays.copyOf(commandParameters, commandParameters.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void readRecordsFromHandler(GitLineHandler handler, Consumer<R> converter, String ... parameters) throws VcsException {
        void $this$use$iv;
        String[] stringArray = GitLogUtil.COMMIT_METADATA_OPTIONS;
        GitLogParser<R> parser = new GitLogParser<R>(this.project, this.recordBuilder, GitLogParser.NameStatus.STATUS, Arrays.copyOf(stringArray, stringArray.length));
        handler.setStdoutSuppressed(true);
        handler.addParameters(Arrays.copyOf(parameters, parameters.length));
        stringArray = new String[]{parser.getPretty(), "--encoding=UTF-8"};
        handler.addParameters(stringArray);
        stringArray = new String[]{"--name-status"};
        handler.addParameters(stringArray);
        handler.endOptions();
        String[] stringArray2 = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder("LoadingFullCommitDetails");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"spanBuilder(...)");
        stringArray = stringArray2;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Unit unit;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv;
                boolean bl3 = false;
                span2.setAttribute("rootName", this.root.getName());
                GitLogOutputSplitter<R> handlerListener = new GitLogOutputSplitter<R>(handler, parser, converter);
                Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
                handlerListener.reportErrors();
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit2 = unit;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    @NotNull
    protected abstract GitLogRecordCollector<R> createRecordsCollector(@NotNull Function1<? super List<? extends R>, Unit> var1);

    @NotNull
    protected abstract C createCommit(@NotNull List<? extends R> var1, @NotNull VcsLogObjectsFactory var2, @NotNull GitCommitRequirements var3);

    private static final Unit readFullDetailsFromHandler$lambda$0(Consumer $commitConsumer, GitDetailsCollector this$0, VcsLogObjectsFactory $factory, GitCommitRequirements $requirements, List records) {
        Intrinsics.checkNotNullParameter((Object)records, (String)"records");
        GitLogRecord firstRecord = (GitLogRecord)CollectionsKt.first((List)records);
        String[] stringArray = firstRecord.getParentsHashes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getParentsHashes(...)");
        String[] parents = stringArray;
        if (parents.length == 0 || parents.length == records.size()) {
            $commitConsumer.accept(this$0.createCommit(records, $factory, $requirements));
        } else {
            LOG.warn("Not enough records for commit " + firstRecord.getHash() + " expected " + parents.length + " records, but got " + records.size());
        }
        return Unit.INSTANCE;
    }

    private static final void readFullDetailsFromHandler$lambda$1(Consumer $commitConsumer, GitDetailsCollector this$0, VcsLogObjectsFactory $factory, GitCommitRequirements $requirements, GitLogRecord record) {
        Object[] objectArray = new GitLogRecord[]{record};
        $commitConsumer.accept(this$0.createCommit(CollectionsKt.mutableListOf((Object[])objectArray), $factory, $requirements));
    }

    static {
        Logger logger = Logger.getInstance(GitDetailsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/history/GitDetailsCollector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

