/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.Internal;
import java.math.BigDecimal;
import java.util.Collection;

@Internal
class NumberComparator {
    NumberComparator() {
    }

    static int compareAsBigDecimals(Object actualNumber, Object comparisonNumber) {
        return new BigDecimal(actualNumber.toString()).compareTo(new BigDecimal(comparisonNumber.toString()));
    }

    static boolean containsAsBigDecimals(Object actualNumber, Collection<?> comparisonNumbers) {
        BigDecimal actualNumberAsBigDecimal = NumberComparator.toBigDecimal(actualNumber);
        return comparisonNumbers.stream().map(NumberComparator::toBigDecimal).anyMatch(comparisonNumberAsBigDecimal -> comparisonNumberAsBigDecimal.compareTo(actualNumberAsBigDecimal) == 0);
    }

    private static BigDecimal toBigDecimal(Object actualNumber) {
        if (actualNumber instanceof Integer) {
            Integer integer = (Integer)actualNumber;
            return BigDecimal.valueOf(integer.intValue());
        }
        if (actualNumber instanceof Long) {
            Long long1 = (Long)actualNumber;
            return BigDecimal.valueOf(long1);
        }
        if (actualNumber instanceof Float) {
            Float float1 = (Float)actualNumber;
            return BigDecimal.valueOf(float1.floatValue());
        }
        if (actualNumber instanceof Double) {
            Double double1 = (Double)actualNumber;
            return BigDecimal.valueOf(double1);
        }
        throw new IllegalArgumentException("Unsupported type: " + actualNumber.getClass().getName());
    }
}

