/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R(\u0010\u0003\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\u0004j\u0002`\u0005\u0018\u00010\u0002j\u0004\u0018\u0001`\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/ColumnWithParent;", "C", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "parent", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "Lorg/jetbrains/kotlinx/dataframe/ColumnGroupReference;", "getParent", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "source", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "core"})
public interface ColumnWithParent<C>
extends ColumnReference<C> {
    @Nullable
    public ColumnReference<DataRow<?>> getParent();

    @NotNull
    public BaseColumn<C> getSource();

    @Override
    @NotNull
    public ColumnPath path();

    @Override
    @Nullable
    public ColumnWithPath<C> resolveSingle(@NotNull ColumnResolutionContext var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <C> ColumnPath path(@NotNull ColumnWithParent<? extends C> $this) {
            ColumnPath columnPath = $this.getParent();
            if (columnPath == null || (columnPath = columnPath.path()) == null || (columnPath = columnPath.plus($this.name())) == null) {
                String[] stringArray = new String[]{$this.name()};
                columnPath = ConstructorsKt.pathOf(stringArray);
            }
            return columnPath;
        }

        @Nullable
        public static <C> ColumnWithPath<C> resolveSingle(@NotNull ColumnWithParent<? extends C> $this, @NotNull ColumnResolutionContext context) {
            DataColumn data2;
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ColumnReference<DataRow<?>> parentDef = $this.getParent();
            if (parentDef == null) {
                pair = TuplesKt.to(context.getDf$core(), (Object)UtilsKt.emptyPath());
            } else {
                ColumnWithPath<DataRow<?>> columnWithPath = parentDef.resolveSingle(context);
                if (columnWithPath == null) {
                    return null;
                }
                ColumnWithPath<DataRow<?>> parentCol = columnWithPath;
                ColumnGroup<?> group2 = TypeConversionsKt.asGroupedT(parentCol.getData());
                pair = TuplesKt.to(group2, (Object)parentCol.getPath());
            }
            Pair pair2 = pair;
            DataFrame targetDf = (DataFrame)pair2.component1();
            ColumnPath pathPrefix = (ColumnPath)pair2.component2();
            DataColumn dataColumn = data2 = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.getColumn((ColumnsContainer)targetDf, $this.name(), context.getUnresolvedColumnsPolicy$core());
            return dataColumn != null ? org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.addPath(dataColumn, pathPrefix.plus($this.name())) : null;
        }

        @NotNull
        public static <C> ColumnReference<C> getValue(@NotNull ColumnWithParent<? extends C> $this, @Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return ColumnReference.DefaultImpls.getValue((ColumnReference)$this, thisRef, property);
        }

        public static <C> C getValue(@NotNull ColumnWithParent<? extends C> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return ColumnReference.DefaultImpls.getValue((ColumnReference)$this, row);
        }

        @Nullable
        public static <C> C getValueOrNull(@NotNull ColumnWithParent<? extends C> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return ColumnReference.DefaultImpls.getValueOrNull((ColumnReference)$this, row);
        }

        @NotNull
        public static <C> List<ColumnWithPath<C>> resolve(@NotNull ColumnWithParent<? extends C> $this, @NotNull ColumnResolutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ColumnReference.DefaultImpls.resolve((ColumnReference)$this, context);
        }
    }
}

