/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.DirectorySettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.IdProvider;
import com.jetbrains.nodejs.nodeunit.execution.ui.JsTestFileSettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.OneOfSettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsControllerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class RootSettingsController
implements SettingsController {
    private final JPanel myPanel;
    private final ComboBox myTestTypeOptionComboBox;
    private final ImmutableMap<NodeunitTestType, TestTypeOption> myOptionByTestTypeMap;
    private final OneOfSettingsController<TestTypeOption> myTestTypeContentSettingsController;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVariablesField;
    private final TextFieldWithBrowseButton myWorkingDirectoryTextFieldWithBrowseButton;
    private final NodePackageField myNodeunitPackageField;

    RootSettingsController(@NotNull Context context) {
        if (context == null) {
            RootSettingsController.$$$reportNull$$$0(0);
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(context.getProject(), false);
        this.myWorkingDirectoryTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.myWorkingDirectoryTextFieldWithBrowseButton.addBrowseFolderListener(context.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(NodeJSBundle.message("nodeunit.rc.working_directory.select.title", new Object[0])));
        this.myEnvVariablesField = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myNodeunitPackageField = new NodePackageField(this.myNodeInterpreterField, NodeunitExecutionUtils.PKG, null);
        List<TestTypeOption> testTypeOptions = RootSettingsController.createTestTypeOptions();
        this.myOptionByTestTypeMap = RootSettingsController.createOptionByTestTypeMap(testTypeOptions);
        this.myTestTypeOptionComboBox = this.createTestTypeOptionComboBox(testTypeOptions);
        JLabel envVarLabel = new JLabel(NodeJSBundle.message("nodeunit.rc.environment_variables.label", new Object[0]));
        this.myTestTypeContentSettingsController = new OneOfSettingsController<TestTypeOption>(new Context(context.getProject(), envVarLabel, this.myWorkingDirectoryTextFieldWithBrowseButton.getTextField()), testTypeOptions);
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)this.myNodeInterpreterField);
        builder.addLabeledComponent(NodeJSBundle.message("nodeunit.rc.working_directory.label", new Object[0]), (JComponent)this.myWorkingDirectoryTextFieldWithBrowseButton);
        builder.addLabeledComponent((JComponent)envVarLabel, (JComponent)this.myEnvVariablesField);
        builder.addLabeledComponent(NodeJSBundle.message("nodeunit.rc.nodeunit_module.label", new Object[0]), (JComponent)this.myNodeunitPackageField);
        builder.addLabeledComponent(NodeJSBundle.message("nodeunit.rc.run.label", new Object[0]), (JComponent)this.myTestTypeOptionComboBox);
        builder.addComponent((JComponent)this.myTestTypeContentSettingsController.getComponent());
        this.myPanel = builder.getPanel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            RootSettingsController.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            RootSettingsController.$$$reportNull$$$0(2);
        }
        this.myNodeInterpreterField.setInterpreterRef(settings.getInterpreterRef());
        this.myEnvVariablesField.setData(settings.getEnvData());
        this.myNodeunitPackageField.setSelected(settings.getNodeunitPackage());
        this.myWorkingDirectoryTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)settings.getWorkingDirectory()));
        this.selectTestType(settings.getTestType());
        this.myTestTypeContentSettingsController.resetFrom(settings);
    }

    @Override
    public void applyTo(@NotNull NodeunitSettings.Builder builder) {
        if (builder == null) {
            RootSettingsController.$$$reportNull$$$0(3);
        }
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEnvData(this.myEnvVariablesField.getData());
        builder.setNodeunitPackage(this.myNodeunitPackageField.getSelected());
        builder.setWorkingDirectory(this.myWorkingDirectoryTextFieldWithBrowseButton.getText());
        builder.setTestType(this.getSelectedTestType());
        this.myTestTypeContentSettingsController.applyTo(builder);
    }

    @NotNull
    private static List<TestTypeOption> createTestTypeOptions() {
        List<TestTypeOption> list = Arrays.asList(new TestTypeOption(NodeunitTestType.DIRECTORY, NodeJSBundle.message("nodeunit.rc.run_all_in_directory.label", new Object[0]), DirectorySettingsController.FACTORY), new TestTypeOption(NodeunitTestType.JS_FILE, NodeJSBundle.message("nodeunit.rc.run_test_file.label", new Object[0]), JsTestFileSettingsController.FACTORY));
        if (list == null) {
            RootSettingsController.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static ImmutableMap<NodeunitTestType, TestTypeOption> createOptionByTestTypeMap(@NotNull List<TestTypeOption> testTypeOptions) {
        if (testTypeOptions == null) {
            RootSettingsController.$$$reportNull$$$0(5);
        }
        ImmutableMap immutableMap = Maps.uniqueIndex(testTypeOptions, input -> input.getTestType());
        if (immutableMap == null) {
            RootSettingsController.$$$reportNull$$$0(6);
        }
        return immutableMap;
    }

    @NotNull
    private ComboBox createTestTypeOptionComboBox(@NotNull List<TestTypeOption> testTypeOptions) {
        if (testTypeOptions == null) {
            RootSettingsController.$$$reportNull$$$0(7);
        }
        ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(testTypeOptions));
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", TestTypeOption::getDisplayName));
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootSettingsController.this.selectTestType(RootSettingsController.this.getSelectedTestType());
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            RootSettingsController.$$$reportNull$$$0(8);
        }
        return comboBox2;
    }

    private void selectTestType(@NotNull NodeunitTestType testType) {
        TestTypeOption testTypeOption;
        if (testType == null) {
            RootSettingsController.$$$reportNull$$$0(9);
        }
        if ((testTypeOption = (TestTypeOption)this.myOptionByTestTypeMap.get((Object)testType)) == null) {
            throw new RuntimeException("Can't find TestTypeOption by " + String.valueOf((Object)testType) + ", index is " + String.valueOf(this.myOptionByTestTypeMap));
        }
        ComboBoxModel comboBoxModel = this.myTestTypeOptionComboBox.getModel();
        if (comboBoxModel.getSelectedItem() != testTypeOption) {
            comboBoxModel.setSelectedItem(testTypeOption);
        }
        this.myTestTypeContentSettingsController.select(testTypeOption);
    }

    @NotNull
    private NodeunitTestType getSelectedTestType() {
        NodeunitTestType nodeunitTestType = ((TestTypeOption)this.myTestTypeOptionComboBox.getSelectedItem()).getTestType();
        if (nodeunitTestType == null) {
            RootSettingsController.$$$reportNull$$$0(10);
        }
        return nodeunitTestType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testTypeOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestTypeOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionByTestTypeMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestTypeOptionComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTestType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOptionByTestTypeMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTestTypeOptionComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectTestType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 8, 10 -> new IllegalStateException(string);
        };
    }

    static class TestTypeOption
    implements IdProvider,
    SettingsControllerFactory {
        private final NodeunitTestType myTestType;
        private final String myDisplayName;
        private final SettingsControllerFactory mySettingsControllerFactory;

        TestTypeOption(@NotNull NodeunitTestType testType, @NotNull String displayName, @NotNull SettingsControllerFactory settingsControllerFactory) {
            if (testType == null) {
                TestTypeOption.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                TestTypeOption.$$$reportNull$$$0(1);
            }
            if (settingsControllerFactory == null) {
                TestTypeOption.$$$reportNull$$$0(2);
            }
            this.myTestType = testType;
            this.myDisplayName = displayName;
            this.mySettingsControllerFactory = settingsControllerFactory;
        }

        @NotNull
        public NodeunitTestType getTestType() {
            NodeunitTestType nodeunitTestType = this.myTestType;
            if (nodeunitTestType == null) {
                TestTypeOption.$$$reportNull$$$0(3);
            }
            return nodeunitTestType;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myTestType.name();
            if (string == null) {
                TestTypeOption.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public SettingsController createSettingsController(@NotNull Context context) {
            if (context == null) {
                TestTypeOption.$$$reportNull$$$0(5);
            }
            SettingsController settingsController = this.mySettingsControllerFactory.createSettingsController(context);
            if (settingsController == null) {
                TestTypeOption.$$$reportNull$$$0(6);
            }
            return settingsController;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                TestTypeOption.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsControllerFactory";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSettingsController";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSettingsController";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

