/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.CharsetEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformers;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplyTextFilePatch
extends ApplyFilePatchBase<TextFilePatch> {
    public ApplyTextFilePatch(TextFilePatch patch) {
        super(patch);
    }

    @Override
    @NotNull
    protected ApplyFilePatch.Result applyChange(final @NotNull Project project, final @NotNull VirtualFile fileToPatch, final @NotNull FilePath pathBeforeRename, final @Nullable Supplier<? extends CharSequence> baseContents) throws IOException {
        ApplyPatchStatus status;
        Document document;
        if (project == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(0);
        }
        if (fileToPatch == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(1);
        }
        if (pathBeforeRename == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(2);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(fileToPatch)) == null) {
            throw new IOException("Failed to set contents for updated file " + fileToPatch.getPath());
        }
        String documentText = document.getText();
        String fileTextPersistent = TextPresentationTransformers.toPersistent((CharSequence)documentText, (VirtualFile)fileToPatch).toString();
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(fileTextPersistent, ((TextFilePatch)this.myPatch).getHunks());
        if (appliedPatch != null) {
            if (appliedPatch.status == ApplyPatchStatus.ALREADY_APPLIED) {
                return new ApplyFilePatch.Result(appliedPatch.status);
            }
            if (appliedPatch.status == ApplyPatchStatus.SUCCESS) {
                this.updateDocumentContent(project, document, fileToPatch, appliedPatch.patchedText);
                return new ApplyFilePatch.Result(appliedPatch.status);
            }
        }
        ApplyPatchStatus applyPatchStatus = status = appliedPatch != null ? appliedPatch.status : ApplyPatchStatus.FAILURE;
        assert (status == ApplyPatchStatus.PARTIAL || status == ApplyPatchStatus.FAILURE);
        return new ApplyFilePatch.Result(status){

            @Override
            public ApplyPatchForBaseRevisionTexts getMergeData() {
                return ApplyPatchForBaseRevisionTexts.create(project, fileToPatch, pathBeforeRename, (TextFilePatch)ApplyTextFilePatch.this.myPatch, baseContents != null ? (CharSequence)baseContents.get() : null);
            }
        };
    }

    @Override
    protected void applyCreate(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable CommitContext commitContext) throws IOException {
        String charsetName;
        Document document;
        if (project == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(3);
        }
        if (newFile == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(4);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(newFile)) == null) {
            throw new IOException("Failed to set contents for new file " + newFile.getPath());
        }
        String string = charsetName = commitContext == null ? null : CharsetEP.getCharset(newFile.getPath(), commitContext);
        if (charsetName != null) {
            try {
                newFile.setCharset(Charset.forName(charsetName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String patchText = ((TextFilePatch)this.myPatch).getSingleHunkPatchText();
        this.updateDocumentContent(project, document, newFile, patchText);
    }

    private void updateDocumentContent(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile file, @NotNull String patchedText) {
        if (project == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(7);
        }
        if (patchedText == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(8);
        }
        VcsFacade.getInstance().runHeavyModificationTask(project, document, () -> {
            try {
                LoadTextUtil.write((Project)project, (VirtualFile)file, (Object)this, (String)patchedText, (long)-1L, (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FileDocumentManager.getInstance().reloadFromDisk(document);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToPatch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchedText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/apply/ApplyTextFilePatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCreate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDocumentContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

