//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// The abstract superclass for objects representing notable features detected in an image.
    ///
    /// > Note: In macOS 10.13, iOS 11, and tvOS 11 or later, the Vision framework replaces these classes
    /// for identifying and analyzing image features.
    /// See
    /// <doc
    /// ://com.apple.documentation/documentation/vision/vnobservation>)
    ///
    /// A `CIFeature` object represents a portion of an image that a detector believes matches its criteria.
    /// Subclasses of CIFeature holds additional information specific to the detector that discovered the feature.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifeature?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIFeature;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIFeature {}
);

impl CIFeature {
    extern_methods!(
        /// The type of feature that was discovered.
        ///
        /// The type can be one of:
        /// * ``CIFeatureTypeFace``
        /// * ``CIFeatureTypeRectangle``
        /// * ``CIFeatureTypeQRCode``
        /// * ``CIFeatureTypeText``
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> Retained<NSString>;

        #[cfg(feature = "objc2-core-foundation")]
        /// The rectangle that bounds the location of discovered feature.
        ///
        /// The rectangle is in the cartesian coordinate system of the image.
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounds(&self) -> CGRect;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIFeature {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern "C" {
    /// A Core Image feature type for person’s face.
    ///
    /// To detect faces in an image or video, pass this to ``/CIDetector/detectorOfType:context:options:``
    ///
    /// Use the ``CIFaceFeature`` class to find more information about the detected face.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifeaturetypeface?language=objc)
    pub static CIFeatureTypeFace: &'static NSString;
}

extern "C" {
    /// A Core Image feature type for rectangular object.
    ///
    /// To detect rectangles in an image or video, pass this to ``/CIDetector/detectorOfType:context:options:``
    ///
    /// Use the ``CIRectangleFeature`` class to find more information about the detected rectangle.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifeaturetyperectangle?language=objc)
    pub static CIFeatureTypeRectangle: &'static NSString;
}

extern "C" {
    /// A Core Image feature type for QR code object.
    ///
    /// To detect QR codes in an image or video, pass this to ``/CIDetector/detectorOfType:context:options:``
    ///
    /// Use the ``CIQRCodeFeature`` class to find more information about the detected QR code.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifeaturetypeqrcode?language=objc)
    pub static CIFeatureTypeQRCode: &'static NSString;
}

extern "C" {
    /// A Core Image feature type for text.
    ///
    /// To detect text in an image or video, pass this to ``/CIDetector/detectorOfType:context:options:``
    ///
    /// Use the ``CITextFeature`` class to find more information about the detected text.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifeaturetypetext?language=objc)
    pub static CIFeatureTypeText: &'static NSString;
}

extern_class!(
    /// Information about a face detected in a still or video image.
    ///
    /// > Note: In macOS 10.13, iOS 11, and tvOS 11 or later, the Vision framework replaces this
    /// class for identifying and analyzing image features. See `VNDetectFaceRectanglesRequest`.
    /// See
    /// <doc
    /// ://com.apple.documentation/documentation/vision/vndetectfacerectanglesrequest>)
    ///
    /// The properties of a `CIFaceFeature` object provide information about the face’s eyes and mouth.
    /// A face object in a video can also have properties that track its location over time, tracking ID and frame count.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifacefeature?language=objc)
    #[unsafe(super(CIFeature, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIFaceFeature;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIFaceFeature {}
);

impl CIFaceFeature {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangle indicating the position and extent of the face feature in image coordinates.
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounds(&self) -> CGRect;

        /// A Boolean value that indicates whether the detector found the face’s left eye.
        #[unsafe(method(hasLeftEyePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasLeftEyePosition(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the center of the left eye.
        ///
        /// > Note: The left eye is on the left side of the face from the observer's perspective.
        /// It is not the left eye from the subject's perspective.
        #[unsafe(method(leftEyePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn leftEyePosition(&self) -> CGPoint;

        /// A Boolean value that indicates whether the detector found the face’s right eye.
        #[unsafe(method(hasRightEyePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasRightEyePosition(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the center of the right eye.
        ///
        /// > Note: The right eye is on the right side of the face from the observer's perspective.
        /// It is not the right eye from the subject's perspective.
        #[unsafe(method(rightEyePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn rightEyePosition(&self) -> CGPoint;

        /// A Boolean value that indicates whether the detector found the face’s mouth.
        #[unsafe(method(hasMouthPosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasMouthPosition(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the center of the mouth.
        #[unsafe(method(mouthPosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouthPosition(&self) -> CGPoint;

        /// A Boolean value that indicates whether the face object has a tracking ID.
        #[unsafe(method(hasTrackingID))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasTrackingID(&self) -> bool;

        /// The tracking identifier of the face object.
        ///
        /// Core Image provides a tracking identifier for faces it detects in a video stream, which you can
        /// use to identify when a CIFaceFeature objects detected in one video frame is the same face detected
        /// in a previous video frame.
        ///
        /// This identifier persists only as long as a face is in the frame and is not associated with a specific
        /// face. In other words, if a face moves out of the video frame and comes back into the frame later,
        /// another ID is assigned. (Core Image detects faces, but does not recognize specific faces.)
        #[unsafe(method(trackingID))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackingID(&self) -> c_int;

        /// A Boolean value that indicates the face object has a tracking frame count.
        #[unsafe(method(hasTrackingFrameCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasTrackingFrameCount(&self) -> bool;

        /// The tracking frame count of the face.
        #[unsafe(method(trackingFrameCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackingFrameCount(&self) -> c_int;

        /// A Boolean value that indicates whether information about face rotation is available.
        #[unsafe(method(hasFaceAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasFaceAngle(&self) -> bool;

        /// The rotation of the face.
        ///
        /// Rotation is measured counterclockwise in degrees, with zero indicating that a line drawn between
        /// the eyes is horizontal relative to the image orientation.
        #[unsafe(method(faceAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn faceAngle(&self) -> c_float;

        /// A Boolean value that indicates whether a smile is detected in the face.
        ///
        /// To detect smiles, ``/CIDetector/featuresInImage:options:`` needs to be called with the ``CIDetectorSmile`` option set to true.
        #[unsafe(method(hasSmile))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasSmile(&self) -> bool;

        /// A Boolean value that indicates whether a closed left eye is detected in the face.
        ///
        /// To detect closed eyes, ``/CIDetector/featuresInImage:options:`` needs to be called with the ``CIDetectorEyeBlink`` option set to true.
        #[unsafe(method(leftEyeClosed))]
        #[unsafe(method_family = none)]
        pub unsafe fn leftEyeClosed(&self) -> bool;

        /// A Boolean value that indicates whether a closed right eye is detected in the face.
        ///
        /// To detect closed eyes, ``/CIDetector/featuresInImage:options:`` needs to be called with the ``CIDetectorEyeBlink`` option set to true.
        #[unsafe(method(rightEyeClosed))]
        #[unsafe(method_family = none)]
        pub unsafe fn rightEyeClosed(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIFaceFeature {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// Information about a rectangular region detected in a still or video image.
    ///
    /// > Note: In macOS 10.13, iOS 11, and tvOS 11 or later, the Vision framework replaces these classes
    /// for identifying and analyzing image features.
    /// See
    /// <doc
    /// ://com.apple.documentation/documentation/vision/vndetectfacerectanglesrequest>)
    ///
    /// A detected rectangle feature is not necessarily rectangular in the plane of the image; rather, the
    /// feature identifies a shape that may be rectangular in space (for example a book on a desk) but which
    /// appears as a four-sided polygon in the image. The properties of a `CIRectangleFeature` object
    /// identify its four corners in image coordinates.
    ///
    /// You can use rectangle feature detection together with the `CIPerspectiveCorrection` filter
    /// to transform the feature to a normal orientation.
    ///
    /// To detect rectangles in an image or video, choose ``CIDetectorTypeRectangle`` when initializing a
    /// ``CIDetector`` object, and use the `CIDetectorAspectRatio` and `CIDetectorFocalLength` options to
    /// specify the approximate shape of rectangular features to search for. The detector returns at
    /// most one rectangle feature, the most prominent found in the image.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cirectanglefeature?language=objc)
    #[unsafe(super(CIFeature, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIRectangleFeature;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIRectangleFeature {}
);

impl CIRectangleFeature {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangle that indicates the position and extent of the rectangle feature in image coordinates.
        ///
        /// This property identifies the rectangular region of the image containing the detected rectangle,
        /// not necessarily the shape of the rectangle. A detected feature is rectangular in space, but may
        /// appear as a four-sided polygon in the image. Use the properties listed in `CIRectangleFeature` to find the
        /// corners of the rectangle as it appears in perspective.
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounds(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-left corner of the detected rectangle.
        #[unsafe(method(topLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn topLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-right corner of the detected rectangle.
        #[unsafe(method(topRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn topRight(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-left corner of the detected rectangle.
        #[unsafe(method(bottomLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-right corner of the detected rectangle.
        #[unsafe(method(bottomRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomRight(&self) -> CGPoint;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIRectangleFeature {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// Information about a Quick Response code detected in a still or video image.
    ///
    /// > Note: In macOS 10.13, iOS 11, and tvOS 11 or later, the Vision framework replaces these classes
    /// for identifying and analyzing image features.
    /// See
    /// <doc
    /// ://com.apple.documentation/documentation/vision/vndetectbarcodesrequest>)
    ///
    /// A QR code is a two-dimensional barcode using the ISO/IEC 18004:2006 standard. The properties of
    /// a CIQRCodeFeature object identify the corners of the barcode in the image perspective and provide
    /// the decoded message.
    ///
    /// To detect QR codes in an image or video, choose ``CIDetectorTypeQRCode`` type when initializing a
    /// ``CIDetector`` object.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciqrcodefeature?language=objc)
    #[unsafe(super(CIFeature, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIQRCodeFeature;
);

extern_conformance!(
    unsafe impl NSCoding for CIQRCodeFeature {}
);

extern_conformance!(
    unsafe impl NSCopying for CIQRCodeFeature {}
);

unsafe impl CopyingHelper for CIQRCodeFeature {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIQRCodeFeature {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIQRCodeFeature {}
);

impl CIQRCodeFeature {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangle that indicates the position and extent of the QR code feature in image coordinates.
        ///
        /// This property identifies the rectangular region of the image containing the detected QR code,
        /// not necessarily the shape of the QR code. A detected feature is square in space, but may
        /// appear as a four-sided polygon in the image. Use the properties listed in `CIQRCodeFeature` to find the
        /// corners of the QR code as it appears in perspective.
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounds(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-left corner of the detected QR code.
        #[unsafe(method(topLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn topLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-right corner of the detected QR code.
        #[unsafe(method(topRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn topRight(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-left corner of the detected QR code.
        #[unsafe(method(bottomLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-right corner of the detected QR code.
        #[unsafe(method(bottomRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomRight(&self) -> CGPoint;

        /// The string decoded from the detected barcode.
        #[unsafe(method(messageString))]
        #[unsafe(method_family = none)]
        pub unsafe fn messageString(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "CIBarcodeDescriptor")]
        /// An abstract representation of a QR Code symbol.
        ///
        /// The property is a ``CIQRCodeDescriptor`` instance that contains the payload, symbol version,
        /// mask pattern, and error correction level, so the QR Code can be reproduced.
        #[unsafe(method(symbolDescriptor))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolDescriptor(&self) -> Option<Retained<CIQRCodeDescriptor>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIQRCodeFeature {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// Information about a text that was detected in a still or video image.
    ///
    /// > Note: In macOS 10.13, iOS 11, and tvOS 11 or later, the Vision framework replaces these classes
    /// for identifying and analyzing image features.
    /// See
    /// <doc
    /// ://com.apple.documentation/documentation/vision/vnrecognizetextrequest>)
    ///
    /// A detected text feature is not necessarily rectangular in the plane of the image; rather, the
    /// feature identifies a shape that may be rectangular in space (for example a text on a sign) but which
    /// appears as a four-sided polygon in the image. The properties of a `CITextFeature` object
    /// identify its four corners in image coordinates.
    ///
    /// To detect text in an image or video, choose the ``CIDetectorTypeText`` type when initializing a
    /// ``CIDetector`` object, and use the `CIDetectorImageOrientation` option to specify the desired
    /// orientation for finding upright text.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/citextfeature?language=objc)
    #[unsafe(super(CIFeature, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CITextFeature;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CITextFeature {}
);

impl CITextFeature {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangle that indicates the position and extent of the text feature in image coordinates.
        ///
        /// This property identifies the rectangular region of the image containing the detected text,
        /// not necessarily the shape of the text box. A detected feature is rectangular in space, but may
        /// appear as a four-sided polygon in the image. Use the properties listed in `CITextFeature` to find the
        /// corners of the rectangle as it appears in perspective.
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounds(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-left corner of the detected text.
        #[unsafe(method(topLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn topLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the upper-right corner of the detected text.
        #[unsafe(method(topRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn topRight(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-left corner of the detected text.
        #[unsafe(method(bottomLeft))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomLeft(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The image coordinate of the lower-right corner of the detected text.
        #[unsafe(method(bottomRight))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomRight(&self) -> CGPoint;

        /// An array containing additional features detected within the feature.
        ///
        /// A text detector can identify both a major region that is likely to contain text as well
        /// as the areas within that region that likely to contain individual text features. Such
        /// features might be single characters, groups of closely-packed characters, or entire words.
        ///
        /// To detect sub-features, ``/CIDetector/featuresInImage:options:`` needs to be called with
        /// the ``CIDetectorReturnSubFeatures`` option set to true.
        #[unsafe(method(subFeatures))]
        #[unsafe(method_family = none)]
        pub unsafe fn subFeatures(&self) -> Option<Retained<NSArray>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CITextFeature {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
