-- ----------------------------------------------*- coding: iso-8859-1; -*-----
--  Copyright (C) 2011-2023  Nick Gasson
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- STANDARD package as defined by IEEE 1076-2019.
-------------------------------------------------------------------------------

package STANDARD is

    type BOOLEAN is (FALSE, TRUE);

    type BIT is ('0', '1');

    type CHARACTER is (
        NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL,
        BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI,
        DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB,
        CAN, EM,  SUB, ESC, FSP, GSP, RSP, USP,

        ' ', '!', '"', '#', '$', '%', '&', ''',
        '(', ')', '*', '+', ',', '-', '.', '/',
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', ':', ';', '<', '=', '>', '?',

        '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
        'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
        'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
        'X', 'Y', 'Z', '[', '\', ']', '^', '_',

        '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
        'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
        'p', 'q', 'r', 's', 't', 'u', 'v', 'w',
        'x', 'y', 'z', '{', '|', '}', '~', DEL,

        C128, C129, C130, C131, C132, C133, C134, C135,
        C136, C137, C138, C139, C140, C141, C142, C143,
        C144, C145, C146, C147, C148, C149, C150, C151,
        C152, C153, C154, C155, C156, C157, C158, C159,

        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',

        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',

        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '' );

    type SEVERITY_LEVEL is (NOTE, WARNING, ERROR, FAILURE);

    -- type universal_integer is range implementation_defined;

    type INTEGER is range -9223372036854775807 - 1 to 9223372036854775807;

    -- type universal_real is range implementation_defined;

    type REAL is range -1.7976931348623157e308 to 1.7976931348623157e308;

    type TIME is range -9223372036854775807 - 1 to 9223372036854775807
        units
            fs;
            ps  = 1000 fs;
            ns  = 1000 ps;
            us  = 1000 ns;
            ms  = 1000 us;
            sec = 1000 ms;
            min = 60 sec;
            hr  = 60 min;
        end units;

    subtype DELAY_LENGTH is TIME range 0 fs to TIME'HIGH;

    impure function NOW return DELAY_LENGTH;

    subtype NATURAL is INTEGER range 0 to INTEGER'HIGH;

    subtype POSITIVE is INTEGER range 1 to INTEGER'HIGH;

    type STRING is array (POSITIVE range <>) of CHARACTER;

    type BIT_VECTOR is array (NATURAL range <>) of BIT;

    type INTEGER_VECTOR is array (NATURAL range <>) of INTEGER;

    type REAL_VECTOR is array (NATURAL range <>) of REAL;

    type TIME_VECTOR is array (NATURAL range <>) of TIME;

    type BOOLEAN_VECTOR is array (NATURAL range <>) of BOOLEAN;

    type FILE_OPEN_KIND is (READ_MODE, WRITE_MODE, APPEND_MODE,
                            READ_WRITE_MODE);

    type FILE_OPEN_STATUS is (OPEN_OK, STATUS_ERROR, NAME_ERROR,
                              MODE_ERROR);

    type FILE_OPEN_STATE is (STATE_OPEN, STATE_CLOSED);

    type FILE_ORIGIN_KIND is (FILE_ORIGIN_BEGIN, FILE_ORIGIN_CURRENT,
                              FILE_ORIGIN_END);

    attribute FOREIGN : STRING;

    attribute FOREIGN of NOW : function is "INTERNAL _std_standard_now";

end package;
