/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={ScriptedCustomModuleTypeProvider.class, ModuleTypeProvider.class})
public class ScriptedCustomModuleTypeProvider
implements ModuleTypeProvider {
    private final Map<String, ModuleType> modulesTypes = new HashMap<String, ModuleType>();
    private final Set<ProviderChangeListener<ModuleType>> listeners = new HashSet<ProviderChangeListener<ModuleType>>();

    public Collection<ModuleType> getAll() {
        return this.modulesTypes.values();
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.listeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.listeners.remove(listener);
    }

    public <T extends ModuleType> T getModuleType(String uid, @Nullable Locale locale) {
        return (T)this.modulesTypes.get(uid);
    }

    public <T extends ModuleType> Collection<T> getModuleTypes(@Nullable Locale locale) {
        return this.modulesTypes.values();
    }

    public void addModuleType(ModuleType moduleType) {
        this.modulesTypes.put(moduleType.getUID(), moduleType);
        for (ProviderChangeListener<ModuleType> listener : this.listeners) {
            listener.added((Provider)this, (Object)moduleType);
        }
    }

    public void removeModuleType(ModuleType moduleType) {
        this.removeModuleType(moduleType.getUID());
    }

    public void removeModuleType(String moduleTypeUID) {
        ModuleType element = this.modulesTypes.remove(moduleTypeUID);
        if (element != null) {
            for (ProviderChangeListener<ModuleType> listener : this.listeners) {
                listener.removed((Provider)this, (Object)element);
            }
        }
    }

    public void updateModuleHandler(String uid) {
        ModuleType modType = this.modulesTypes.get(uid);
        if (modType != null) {
            for (ProviderChangeListener<ModuleType> listener : this.listeners) {
                listener.updated((Provider)this, (Object)modType, (Object)modType);
            }
        }
    }
}

