/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.color.MultipleGradient;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 A2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u00020\u0005:\u0003?@AB!\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020%2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020%2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010'H\u0016J\u0018\u0010)\u001a\u00020%2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010'H\u0016J\u0018\u0010+\u001a\u00020%2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010'H\u0016J2\u0010,\u001a\u00020%2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010'2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010'2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020%H\u0016J\b\u00100\u001a\u00020%H\u0002J\"\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u0013H\u0002J8\u00106\u001a\u0004\u0018\u0001022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u000102H\u0016J*\u0010;\u001a\u0004\u0018\u0001022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u000102H\u0016J*\u0010<\u001a\u0004\u0018\u0001022\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u000102H\u0016J\b\u0010=\u001a\u00020>H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 \u00a8\u0006B"}, d2={"Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer;", "Lcom/intellij/database/datagrid/color/ColorLayer;", "Lcom/intellij/database/datagrid/GridModel$Listener;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "Lcom/intellij/openapi/Disposable;", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "tableResultView", "Lcom/intellij/database/run/ui/table/TableResultView;", "useOldColors", "", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/run/ui/table/TableResultView;Z)V", "columns", "", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColumnRange;", "globalMax", "", "globalMin", "value", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "coloringMode", "getColoringMode", "()Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "setColoringMode", "(Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;)V", "perColumn", "getPerColumn", "()Z", "setPerColumn", "(Z)V", "colorBooleanColumns", "getColorBooleanColumns", "setColorBooleanColumns", "dispose", "", "columnsAdded", "Lcom/intellij/database/datagrid/ModelIndexSet;", "columnsRemoved", "rowsAdded", "rows", "rowsRemoved", "cellsUpdated", "place", "Lcom/intellij/database/datagrid/GridRequestSource$RequestPlace;", "afterLastRowAdded", "updateRanges", "getColor", "Ljava/awt/Color;", "x", "minX", "maxX", "getCellBackground", "row", "column", "grid", "color", "getRowHeaderBackground", "getColumnHeaderBackground", "getPriority", "", "ColoringMode", "ColumnRange", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nTableHeatmapColorLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableHeatmapColorLayer.kt\ncom/intellij/database/datagrid/color/TableHeatmapColorLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1869#2:285\n1869#2,2:286\n1870#2:288\n*S KotlinDebug\n*F\n+ 1 TableHeatmapColorLayer.kt\ncom/intellij/database/datagrid/color/TableHeatmapColorLayer\n*L\n101#1:285\n114#1:286,2\n101#1:288\n*E\n"})
public final class TableHeatmapColorLayer
implements ColorLayer,
GridModel.Listener<GridRow, GridColumn>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid dataGrid;
    @NotNull
    private final TableResultView tableResultView;
    private final boolean useOldColors;
    @NotNull
    private final Map<ModelIndex<GridColumn>, ColumnRange> columns;
    private double globalMax;
    private double globalMin;
    @NotNull
    private ColoringMode coloringMode;
    private boolean perColumn;
    private boolean colorBooleanColumns;
    @NotNull
    private static final Lazy<MultipleGradient> simpleGradientLightOld$delegate = LazyKt.lazy(TableHeatmapColorLayer::simpleGradientLightOld_delegate$lambda$2);
    @NotNull
    private static final Lazy<MultipleGradient> simpleGradientLight$delegate = LazyKt.lazy(TableHeatmapColorLayer::simpleGradientLight_delegate$lambda$3);
    @NotNull
    private static final Lazy<MultipleGradient> simpleGradientDarkOld$delegate = LazyKt.lazy(TableHeatmapColorLayer::simpleGradientDarkOld_delegate$lambda$4);
    @NotNull
    private static final Lazy<MultipleGradient> simpleGradientDark$delegate = LazyKt.lazy(TableHeatmapColorLayer::simpleGradientDark_delegate$lambda$5);
    @NotNull
    private static final Lazy<MultipleGradient> multipleGradientLightOld$delegate = LazyKt.lazy(TableHeatmapColorLayer::multipleGradientLightOld_delegate$lambda$6);
    @NotNull
    private static final Lazy<MultipleGradient> multipleGradientLight$delegate = LazyKt.lazy(TableHeatmapColorLayer::multipleGradientLight_delegate$lambda$7);
    @NotNull
    private static final Lazy<MultipleGradient> multipleGradientDarkOld$delegate = LazyKt.lazy(TableHeatmapColorLayer::multipleGradientDarkOld_delegate$lambda$8);
    @NotNull
    private static final Lazy<MultipleGradient> multipleGradientDark$delegate = LazyKt.lazy(TableHeatmapColorLayer::multipleGradientDark_delegate$lambda$9);
    @NotNull
    private static final Key<Boolean> HEATMAP_OLD_COLORS;
    @NotNull
    private static final String COLOR_BOOLEAN_COLUMNS = "table.view.heatmap.color.boolean.columns";
    @NotNull
    private static final String PER_COLUMN_COLORING = "table.view.heatmap.color.per.columns";
    @NotNull
    private static final String COLORING_MODE = "table.view.heatmap.coloring.mode";

    private TableHeatmapColorLayer(DataGrid dataGrid, TableResultView tableResultView, boolean useOldColors) {
        this.dataGrid = dataGrid;
        this.tableResultView = tableResultView;
        this.useOldColors = useOldColors;
        this.columns = new LinkedHashMap();
        this.globalMax = -1.7976931348623157E308;
        this.globalMin = Double.MAX_VALUE;
        this.coloringMode = Companion.getColoringMode();
        this.perColumn = Companion.isPerColumnColoringEnabled();
        this.colorBooleanColumns = Companion.isColorBooleanColumnsEnabled();
        this.dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).addListener((GridModel.Listener)this, (Disposable)this);
        this.updateRanges();
    }

    @NotNull
    public final ColoringMode getColoringMode() {
        return this.coloringMode;
    }

    public final void setColoringMode(@NotNull ColoringMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.coloringMode != value) {
            this.coloringMode = value;
            Companion.setColoringMode(value);
            if (this.useOldColors) {
                this.tableResultView.setShowHorizontalLines(value != ColoringMode.OFF);
            }
            this.tableResultView.repaint();
        }
    }

    public final boolean getPerColumn() {
        return this.perColumn;
    }

    public final void setPerColumn(boolean value) {
        if (this.perColumn != value) {
            this.perColumn = value;
            this.tableResultView.repaint();
        }
    }

    public final boolean getColorBooleanColumns() {
        return this.colorBooleanColumns;
    }

    public final void setColorBooleanColumns(boolean value) {
        if (this.colorBooleanColumns != value) {
            this.colorBooleanColumns = value;
            this.tableResultView.repaint();
        }
    }

    public void dispose() {
    }

    public void columnsAdded(@Nullable ModelIndexSet<GridColumn> columns) {
    }

    public void columnsRemoved(@Nullable ModelIndexSet<GridColumn> columns) {
    }

    public void rowsAdded(@Nullable ModelIndexSet<GridRow> rows) {
    }

    public void rowsRemoved(@Nullable ModelIndexSet<GridRow> rows) {
    }

    public void cellsUpdated(@Nullable ModelIndexSet<GridRow> rows, @Nullable ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
    }

    public void afterLastRowAdded() {
        this.updateRanges();
    }

    private final void updateRanges() {
        GridModel gridModel = this.dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel dataModel = gridModel;
        if (dataModel.getRowCount() == 0 || dataModel.getColumnCount() == 0) {
            return;
        }
        JBIterable jBIterable = dataModel.getColumnIndices().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelIndex columnIndex = (ModelIndex)element$iv;
            boolean bl = false;
            GridColumn column = (GridColumn)dataModel.getColumn(columnIndex);
            Index index = dataModel.getRowIndices().first();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"first(...)");
            ModelIndex firstRow = (ModelIndex)index;
            if (column == null || column.getAttributes().contains(ColumnDescriptor.Attribute.HIGHLIGHTED) || !ObjectFormatterUtil.isNumericCell((CoreGrid)this.dataGrid, (ModelIndex)firstRow, (ModelIndex)columnIndex)) continue;
            double min = 0.0;
            min = Double.MAX_VALUE;
            double max = 0.0;
            max = -1.7976931348623157E308;
            JBIterable jBIterable2 = dataModel.getRowIndices().asIterable();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"asIterable(...)");
            Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ModelIndex rowIndex = (ModelIndex)element$iv2;
                boolean bl2 = false;
                Double value = StringsKt.toDoubleOrNull((String)String.valueOf(dataModel.getValueAt(rowIndex, columnIndex)));
                if (value == null) continue;
                if (min > value) {
                    min = value;
                }
                if (!(max < value)) continue;
                max = value;
            }
            if (max > this.globalMax) {
                this.globalMax = max;
            }
            if (min < this.globalMin) {
                this.globalMin = min;
            }
            if (min == Double.MAX_VALUE || max == -1.7976931348623157E308) continue;
            this.columns.put((ModelIndex<GridColumn>)columnIndex, new ColumnRange(min, max));
        }
    }

    private final Color getColor(double x, double minX, double maxX) {
        if (minX == maxX) {
            return null;
        }
        double p = (x - minX) / (maxX - minX);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.coloringMode.ordinal()]) {
            case 1 -> {
                if (JBColor.isBright()) {
                    yield Companion.getSimpleGradientLight(this.useOldColors).getColor((float)p);
                }
                yield Companion.getSimpleGradientDark(this.useOldColors).getColor((float)p);
            }
            case 2 -> {
                if (JBColor.isBright()) {
                    yield Companion.getMultipleGradientLight(this.useOldColors).getColor((float)p);
                }
                yield Companion.getMultipleGradientDark(this.useOldColors).getColor((float)p);
            }
            default -> JBColor.isBright() ? new Color(MathKt.roundToInt((double)((double)255 * p)), 0, MathKt.roundToInt((double)((double)255 * (1.0 - p))), 255).brighter() : new Color(MathKt.roundToInt((double)((double)255 * p)), 0, MathKt.roundToInt((double)((double)255 * (1.0 - p))), 255);
        };
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        if (this.coloringMode == ColoringMode.OFF) {
            return null;
        }
        GridModel gridModel = this.dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel dataModel = gridModel;
        if (this.colorBooleanColumns && ObjectFormatterUtil.isBooleanCell((CoreGrid)grid, row, column)) {
            String string = String.valueOf(dataModel.getValueAt(row, column)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return Intrinsics.areEqual((Object)string, (Object)"true") ? this.getColor(0.6, 0.0, 1.0) : this.getColor(0.0, 0.0, 1.0);
        }
        ColumnRange columnRange = this.columns.get(column);
        if (columnRange == null) {
            return null;
        }
        ColumnRange columnRange2 = columnRange;
        Double d = StringsKt.toDoubleOrNull((String)String.valueOf(dataModel.getValueAt(row, column)));
        if (d == null) {
            return null;
        }
        double doubleValue = d;
        return this.perColumn ? this.getColor(doubleValue, columnRange2.getMin(), columnRange2.getMax()) : this.getColor(doubleValue, this.globalMin, this.globalMax);
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return null;
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private static final MultipleGradient simpleGradientLightOld_delegate$lambda$2() {
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)new Color(93, 143, 244);
        objectArray[1] = (float)new Color(212, 226, 255);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient simpleGradientLight_delegate$lambda$3() {
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)new Color(54, 150, 80);
        objectArray[1] = (float)new Color(242, 252, 243);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient simpleGradientDarkOld_delegate$lambda$4() {
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)new Color(54, 106, 207);
        objectArray[1] = (float)new Color(37, 50, 77);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient simpleGradientDark_delegate$lambda$5() {
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)new Color(87, 150, 92);
        objectArray[1] = (float)new Color(37, 54, 39);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient multipleGradientLightOld_delegate$lambda$6() {
        Object[] objectArray = new float[]{0.0f, 0.5f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)new Color(88, 140, 243);
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        objectArray[1] = (float)color;
        objectArray[2] = (float)new Color(228, 108, 120);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient multipleGradientLight_delegate$lambda$7() {
        Object[] objectArray = new float[]{0.0f, 0.5f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)new Color(54, 150, 80);
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        objectArray[1] = (float)color;
        objectArray[2] = (float)new Color(228, 108, 120);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient multipleGradientDarkOld_delegate$lambda$8() {
        Object[] objectArray = new float[]{0.0f, 0.5f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)new Color(54, 106, 207);
        objectArray[1] = (float)new Color(30, 31, 34);
        objectArray[2] = (float)new Color(189, 87, 87);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    private static final MultipleGradient multipleGradientDark_delegate$lambda$9() {
        Object[] objectArray = new float[]{0.0f, 0.5f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)new Color(87, 150, 92);
        objectArray[1] = (float)new Color(30, 31, 34);
        objectArray[2] = (float)new Color(189, 87, 87);
        return new MultipleGradient(fArray, (Color[])objectArray);
    }

    public /* synthetic */ TableHeatmapColorLayer(DataGrid dataGrid, TableResultView tableResultView, boolean useOldColors, DefaultConstructorMarker $constructor_marker) {
        this(dataGrid, tableResultView, useOldColors);
    }

    static {
        Key key = Key.create((String)"HEATMAP_OLD_COLORS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HEATMAP_OLD_COLORS = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "", "title", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "OFF", "SEQUENTIAL", "DIVERGING", "Companion", "intellij.grid.impl"})
    public static final class ColoringMode
    extends Enum<ColoringMode> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String title;
        public static final /* enum */ ColoringMode OFF;
        public static final /* enum */ ColoringMode SEQUENTIAL;
        public static final /* enum */ ColoringMode DIVERGING;
        private static final /* synthetic */ ColoringMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ColoringMode(String title) {
            this.title = title;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public static ColoringMode[] values() {
            return (ColoringMode[])$VALUES.clone();
        }

        public static ColoringMode valueOf(String value) {
            return Enum.valueOf(ColoringMode.class, value);
        }

        @NotNull
        public static EnumEntries<ColoringMode> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = DataGridBundle.message((String)"datagrid.coloring.mode.off", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            OFF = new ColoringMode(string);
            String string2 = DataGridBundle.message((String)"datagrid.coloring.mode.sequential", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            SEQUENTIAL = new ColoringMode(string2);
            String string3 = DataGridBundle.message((String)"datagrid.coloring.mode.diverging", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            DIVERGING = new ColoringMode(string3);
            $VALUES = coloringModeArray = new ColoringMode[]{ColoringMode.OFF, ColoringMode.SEQUENTIAL, ColoringMode.DIVERGING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode$Companion;", "", "<init>", "()V", "getByName", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "name", "", "intellij.grid.impl"})
        @SourceDebugExtension(value={"SMAP\nTableHeatmapColorLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableHeatmapColorLayer.kt\ncom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n295#2,2:285\n*S KotlinDebug\n*F\n+ 1 TableHeatmapColorLayer.kt\ncom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode$Companion\n*L\n36#1:285,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ColoringMode getByName(@Nullable String name) {
                ColoringMode coloringMode;
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = (Iterable)ColoringMode.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ColoringMode it = (ColoringMode)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)name)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((coloringMode = (ColoringMode)v0) == null) {
                    coloringMode = DIVERGING;
                }
                return coloringMode;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColumnRange;", "", "min", "", "max", "<init>", "(DD)V", "getMin", "()D", "getMax", "intellij.grid.impl"})
    private static final class ColumnRange {
        private final double min;
        private final double max;

        public ColumnRange(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public final double getMin() {
            return this.min;
        }

        public final double getMax() {
            return this.max;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000202J\u0006\u00106\u001a\u00020\u0010J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u00020\u0010J\u0006\u00109\u001a\u00020\u0010J\u000e\u0010:\u001a\u0002042\u0006\u00108\u001a\u00020\u0010J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>R!\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\n\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\bR!\u0010\u0011\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\n\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\bR!\u0010\u0015\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\n\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\bR!\u0010\u0019\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\n\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\bR!\u0010\u001d\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\n\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010\bR!\u0010!\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\n\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010\bR!\u0010%\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\n\u0012\u0004\b&\u0010\u0003\u001a\u0004\b'\u0010\bR\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020.X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$Companion;", "", "<init>", "()V", "simpleGradientLightOld", "Lcom/intellij/database/datagrid/color/MultipleGradient;", "getSimpleGradientLightOld$annotations", "getSimpleGradientLightOld", "()Lcom/intellij/database/datagrid/color/MultipleGradient;", "simpleGradientLightOld$delegate", "Lkotlin/Lazy;", "simpleGradientLight", "getSimpleGradientLight$annotations", "getSimpleGradientLight", "simpleGradientLight$delegate", "useOldColors", "", "simpleGradientDarkOld", "getSimpleGradientDarkOld$annotations", "getSimpleGradientDarkOld", "simpleGradientDarkOld$delegate", "simpleGradientDark", "getSimpleGradientDark$annotations", "getSimpleGradientDark", "simpleGradientDark$delegate", "multipleGradientLightOld", "getMultipleGradientLightOld$annotations", "getMultipleGradientLightOld", "multipleGradientLightOld$delegate", "multipleGradientLight", "getMultipleGradientLight$annotations", "getMultipleGradientLight", "multipleGradientLight$delegate", "multipleGradientDarkOld", "getMultipleGradientDarkOld$annotations", "getMultipleGradientDarkOld", "multipleGradientDarkOld$delegate", "multipleGradientDark", "getMultipleGradientDark$annotations", "getMultipleGradientDark", "multipleGradientDark$delegate", "HEATMAP_OLD_COLORS", "Lcom/intellij/openapi/util/Key;", "getHEATMAP_OLD_COLORS", "()Lcom/intellij/openapi/util/Key;", "COLOR_BOOLEAN_COLUMNS", "", "PER_COLUMN_COLORING", "COLORING_MODE", "getColoringMode", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer$ColoringMode;", "setColoringMode", "", "mode", "isPerColumnColoringEnabled", "setPerColumnColoringEnabled", "value", "isColorBooleanColumnsEnabled", "setColorBooleanColumnsEnabled", "installOn", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer;", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultipleGradient getSimpleGradientLightOld() {
            Lazy lazy = simpleGradientLightOld$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getSimpleGradientLightOld$annotations() {
        }

        @NotNull
        public final MultipleGradient getSimpleGradientLight() {
            Lazy lazy = simpleGradientLight$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getSimpleGradientLight$annotations() {
        }

        @NotNull
        public final MultipleGradient getSimpleGradientLight(boolean useOldColors) {
            return useOldColors ? this.getSimpleGradientLightOld() : this.getSimpleGradientLight();
        }

        @NotNull
        public final MultipleGradient getSimpleGradientDarkOld() {
            Lazy lazy = simpleGradientDarkOld$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getSimpleGradientDarkOld$annotations() {
        }

        @NotNull
        public final MultipleGradient getSimpleGradientDark() {
            Lazy lazy = simpleGradientDark$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getSimpleGradientDark$annotations() {
        }

        @NotNull
        public final MultipleGradient getSimpleGradientDark(boolean useOldColors) {
            return useOldColors ? this.getSimpleGradientDarkOld() : this.getSimpleGradientDark();
        }

        @NotNull
        public final MultipleGradient getMultipleGradientLightOld() {
            Lazy lazy = multipleGradientLightOld$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getMultipleGradientLightOld$annotations() {
        }

        @NotNull
        public final MultipleGradient getMultipleGradientLight() {
            Lazy lazy = multipleGradientLight$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getMultipleGradientLight$annotations() {
        }

        @NotNull
        public final MultipleGradient getMultipleGradientLight(boolean useOldColors) {
            return useOldColors ? this.getMultipleGradientLightOld() : this.getMultipleGradientLight();
        }

        @NotNull
        public final MultipleGradient getMultipleGradientDarkOld() {
            Lazy lazy = multipleGradientDarkOld$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getMultipleGradientDarkOld$annotations() {
        }

        @NotNull
        public final MultipleGradient getMultipleGradientDark() {
            Lazy lazy = multipleGradientDark$delegate;
            return (MultipleGradient)lazy.getValue();
        }

        public static /* synthetic */ void getMultipleGradientDark$annotations() {
        }

        @NotNull
        public final MultipleGradient getMultipleGradientDark(boolean useOldColors) {
            return useOldColors ? this.getMultipleGradientDarkOld() : this.getMultipleGradientDark();
        }

        @NotNull
        public final Key<Boolean> getHEATMAP_OLD_COLORS() {
            return HEATMAP_OLD_COLORS;
        }

        @NotNull
        public final ColoringMode getColoringMode() {
            return ColoringMode.Companion.getByName(PropertiesComponent.getInstance().getValue(TableHeatmapColorLayer.COLORING_MODE));
        }

        public final void setColoringMode(@NotNull ColoringMode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            PropertiesComponent.getInstance().setValue(TableHeatmapColorLayer.COLORING_MODE, mode.name());
        }

        public final boolean isPerColumnColoringEnabled() {
            return PropertiesComponent.getInstance().getBoolean(TableHeatmapColorLayer.PER_COLUMN_COLORING, false);
        }

        public final void setPerColumnColoringEnabled(boolean value) {
            PropertiesComponent.getInstance().setValue(TableHeatmapColorLayer.PER_COLUMN_COLORING, value);
        }

        public final boolean isColorBooleanColumnsEnabled() {
            return PropertiesComponent.getInstance().getBoolean(TableHeatmapColorLayer.COLOR_BOOLEAN_COLUMNS, true);
        }

        public final void setColorBooleanColumnsEnabled(boolean value) {
            PropertiesComponent.getInstance().setValue(TableHeatmapColorLayer.COLOR_BOOLEAN_COLUMNS, value, true);
        }

        @Nullable
        public final TableHeatmapColorLayer installOn(@NotNull DataGrid dataGrid) {
            Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
            GridColorModel gridColorModel = dataGrid.getColorModel();
            GridColorModelImpl gridColorModelImpl = gridColorModel instanceof GridColorModelImpl ? (GridColorModelImpl)gridColorModel : null;
            if (gridColorModelImpl == null) {
                return null;
            }
            GridColorModelImpl gridColorModel2 = gridColorModelImpl;
            ResultView resultView = dataGrid.getResultView();
            TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
            if (tableResultView == null) {
                return null;
            }
            TableResultView tableResultView2 = tableResultView;
            boolean useOldColors = Intrinsics.areEqual((Object)dataGrid.getUserData(this.getHEATMAP_OLD_COLORS()), (Object)true);
            TableHeatmapColorLayer tableHeatmapColorLayer = new TableHeatmapColorLayer(dataGrid, tableResultView2, useOldColors, null);
            Disposer.register((Disposable)((Disposable)dataGrid), (Disposable)tableHeatmapColorLayer);
            gridColorModel2.addLayer(tableHeatmapColorLayer);
            tableResultView2.repaint();
            if (useOldColors) {
                tableResultView2.setShowHorizontalLines(true);
            }
            return tableHeatmapColorLayer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColoringMode.values().length];
            try {
                nArray[ColoringMode.SEQUENTIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColoringMode.DIVERGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

