/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.merge.MergeConflictManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u0006\u0010\u0010\u001a\u00020\tJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeConflictManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isResolvedConflict", "", "item", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "getResolvedConflictPaths", "", "isMergeConflict", "showMergeConflicts", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigateToChanges", "dispose", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMergeConflictManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictManager.kt\ncom/intellij/openapi/vcs/merge/MergeConflictManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1761#2,3:99\n*S KotlinDebug\n*F\n+ 1 MergeConflictManager.kt\ncom/intellij/openapi/vcs/merge/MergeConflictManager\n*L\n57#1:99,3\n*E\n"})
public final class MergeConflictManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public MergeConflictManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        MergeConflictManager.Companion.isNonModalMergeRegistryValue().addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
            }
        }, this.cs);
    }

    public final boolean isResolvedConflict(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item instanceof FilePath) {
            return this.isResolvedConflict((FilePath)item);
        }
        if (item instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)item));
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            return this.isResolvedConflict(filePath);
        }
        return false;
    }

    public final boolean isResolvedConflict(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ChangeListManager.getInstance((Project)this.project).isResolvedConflict(path);
    }

    @NotNull
    public final List<FilePath> getResolvedConflictPaths() {
        List list = ChangeListManager.getInstance((Project)this.project).getResolvedConflictPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResolvedConflictPaths(...)");
        return list;
    }

    public final boolean isMergeConflict() {
        boolean bl;
        block3: {
            Collection collection = ChangeListManager.getInstance((Project)this.project).getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Change it = (Change)element$iv;
                    boolean bl2 = false;
                    FileStatus fileStatus = it.getFileStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
                    if (!Companion.isMergeConflict(fileStatus)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void showMergeConflicts(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty(files, (Collection)CollectionsKt.emptyList());
        this.navigateToChanges();
    }

    private final void navigateToChanges() {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Local Changes");
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(toolWindow, this, null){
            int label;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ MergeConflictManager this$0;
            {
                this.$toolWindow = $toolWindow;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ToolWindow toolWindow = this.$toolWindow;
                        if (toolWindow != null) {
                            toolWindow.activate(() -> navigateToChanges.1.invokeSuspend$lambda$0(this.this$0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(MergeConflictManager this$0) {
                ChangesViewContentManager.Companion.getInstance(MergeConflictManager.access$getProject$p(this$0)).selectContent("Local Changes");
            }
        }), (int)2, null);
    }

    public void dispose() {
    }

    @JvmStatic
    public static final boolean isNonModalMergeEnabled(@NotNull Project project) {
        return Companion.isNonModalMergeEnabled(project);
    }

    @JvmStatic
    public static final boolean isForceIncludeResolvedConflicts() {
        return Companion.isForceIncludeResolvedConflicts();
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final boolean isMergeConflict(@NotNull FileStatus status) {
        return Companion.isMergeConflict(status);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeConflictManager$Companion;", "", "<init>", "()V", "isNonModalMergeEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "isNonModalMergeRegistryValue", "Lcom/intellij/openapi/util/registry/RegistryValue;", "isForceIncludeResolvedConflicts", "getInstance", "Lcom/intellij/openapi/vcs/merge/MergeConflictManager;", "isMergeConflict", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nMergeConflictManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictManager.kt\ncom/intellij/openapi/vcs/merge/MergeConflictManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n30#2,2:99\n*S KotlinDebug\n*F\n+ 1 MergeConflictManager.kt\ncom/intellij/openapi/vcs/merge/MergeConflictManager$Companion\n*L\n88#1:99,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isNonModalMergeEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.isNonModalMergeRegistryValue().asBoolean() && CommitModeManager.Companion.getInstance(project).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode;
        }

        private final RegistryValue isNonModalMergeRegistryValue() {
            return Registry.Companion.get("vcs.non.modal.merge.enabled");
        }

        @JvmStatic
        public final boolean isForceIncludeResolvedConflicts() {
            return Registry.Companion.is("vcs.non.modal.merge.force.include.resolved");
        }

        @JvmStatic
        @NotNull
        public final MergeConflictManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<MergeConflictManager> serviceClass$iv = MergeConflictManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (MergeConflictManager)object;
        }

        @JvmStatic
        public final boolean isMergeConflict(@NotNull FileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

