/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference;

import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EnumeratedReferenceRepository
extends NodeRepository<EnumeratedReferenceBlock> {
    private ArrayList<EnumeratedReferenceBlock> referencedEnumeratedReferenceBlocks = new ArrayList();

    public static String getType(String text) {
        int pos = text.lastIndexOf(58);
        if (pos > 0) {
            return text.subSequence(0, pos).toString();
        }
        return "";
    }

    public List<EnumeratedReferenceBlock> getReferencedEnumeratedReferenceBlocks() {
        return this.referencedEnumeratedReferenceBlocks;
    }

    public EnumeratedReferenceRepository(DataHolder options) {
        super(EnumeratedReferenceExtension.ENUMERATED_REFERENCES_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<EnumeratedReferenceRepository> getDataKey() {
        return EnumeratedReferenceExtension.ENUMERATED_REFERENCES;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return EnumeratedReferenceExtension.ENUMERATED_REFERENCES_KEEP;
    }

    @Override
    @NotNull
    public Set<EnumeratedReferenceBlock> getReferencedElements(Node parent) {
        HashSet<EnumeratedReferenceBlock> references = new HashSet<EnumeratedReferenceBlock>();
        this.visitNodes(parent, value -> {
            EnumeratedReferenceBlock reference;
            if (value instanceof EnumeratedReferenceBase && (reference = ((EnumeratedReferenceBase)value).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, EnumeratedReferenceText.class, EnumeratedReferenceLink.class);
        return references;
    }
}

