/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 '2\u00020\u0001:\u0004&'()B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0017H \u00a2\u0006\u0002\b%R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxLayout;", "title", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "guideBarSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "reverse", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;ZLorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "<set-?>", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "barBounds", "getBarBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "barLengthExpand", "", "getBarLengthExpand", "()D", "breakInfos", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "getBreakInfos$plot_builder", "()Ljava/util/List;", "guideBarLength", "getGuideBarLength", "getGuideBarSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "createBreakInfo", "tickLocation", "createBreakInfo$plot_builder", "BreakInfo", "Companion", "HorizontalLayout", "VerticalLayout", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nColorBarComponentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorBarComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1549#2:178\n1620#2,3:179\n*S KotlinDebug\n*F\n+ 1 ColorBarComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout\n*L\n45#1:178\n45#1:179,3\n*E\n"})
public abstract class ColorBarComponentLayout
extends LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector guideBarSize;
    @NotNull
    private DoubleRectangle barBounds;
    private final double barLengthExpand;
    @NotNull
    private final List<BreakInfo> breakInfos;

    /*
     * WARNING - void declaration
     */
    public ColorBarComponentLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector guideBarSize, @NotNull LegendDirection legendDirection, boolean reverse, @NotNull LegendTheme theme) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)guideBarSize, (String)"guideBarSize");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(title, legendDirection, theme);
        this.guideBarSize = guideBarSize;
        this.barLengthExpand = 2.0;
        double guideBarLength = this.getGuideBarLength();
        DoubleSpan targetRange = new DoubleSpan(0.0 + this.barLengthExpand, guideBarLength - this.barLengthExpand);
        ScaleMapper<Double> mapper = Mappers.INSTANCE.linear(domain, targetRange, reverse);
        Iterable iterable = breaks.getTransformedValues();
        ColorBarComponentLayout colorBarComponentLayout = this;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d2 = mapper.invoke((double)it);
            Intrinsics.checkNotNull((Object)d2);
            double tickLocation = ((Number)d2).doubleValue();
            collection.add(this.createBreakInfo$plot_builder(tickLocation));
        }
        colorBarComponentLayout.breakInfos = (List)destination$iv$iv;
        this.barBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.guideBarSize);
    }

    @NotNull
    protected final DoubleVector getGuideBarSize() {
        return this.guideBarSize;
    }

    @NotNull
    public final DoubleRectangle getBarBounds() {
        return this.barBounds;
    }

    public final double getBarLengthExpand() {
        return this.barLengthExpand;
    }

    protected abstract double getGuideBarLength();

    @NotNull
    public final List<BreakInfo> getBreakInfos$plot_builder() {
        return this.breakInfos;
    }

    @NotNull
    public abstract BreakInfo createBreakInfo$plot_builder(double var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "", "tickLocation", "", "labelLocation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "labelHorizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "labelVerticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "(DLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;)V", "getLabelHorizontalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "getLabelLocation", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getLabelVerticalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "getTickLocation", "()D", "plot-builder"})
    public static final class BreakInfo {
        private final double tickLocation;
        @NotNull
        private final DoubleVector labelLocation;
        @NotNull
        private final Text.HorizontalAnchor labelHorizontalAnchor;
        @NotNull
        private final Text.VerticalAnchor labelVerticalAnchor;

        public BreakInfo(double tickLocation, @NotNull DoubleVector labelLocation, @NotNull Text.HorizontalAnchor labelHorizontalAnchor, @NotNull Text.VerticalAnchor labelVerticalAnchor) {
            Intrinsics.checkNotNullParameter((Object)labelLocation, (String)"labelLocation");
            Intrinsics.checkNotNullParameter((Object)((Object)labelHorizontalAnchor), (String)"labelHorizontalAnchor");
            Intrinsics.checkNotNullParameter((Object)((Object)labelVerticalAnchor), (String)"labelVerticalAnchor");
            this.tickLocation = tickLocation;
            this.labelLocation = labelLocation;
            this.labelHorizontalAnchor = labelHorizontalAnchor;
            this.labelVerticalAnchor = labelVerticalAnchor;
        }

        public final double getTickLocation() {
            return this.tickLocation;
        }

        @NotNull
        public final DoubleVector getLabelLocation() {
            return this.labelLocation;
        }

        @NotNull
        public final Text.HorizontalAnchor getLabelHorizontalAnchor() {
            return this.labelHorizontalAnchor;
        }

        @NotNull
        public final Text.VerticalAnchor getLabelVerticalAnchor() {
            return this.labelVerticalAnchor;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J6\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$Companion;", "", "()V", "horizontal", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "barSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "reverse", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "vertical", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentLayout horizontal(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new HorizontalLayout(title, domain, breaks, barSize, reverse, theme);
        }

        @NotNull
        public final ColorBarComponentLayout vertical(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new VerticalLayout(title, domain, breaks, barSize, reverse, theme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$HorizontalLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "barSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "reverse", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "graphSize", "getGraphSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "guideBarLength", "", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder", "plot-builder"})
    private static final class HorizontalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        public HorizontalLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, domain, breaks, barSize, LegendDirection.HORIZONTAL, reverse, theme);
            Iterator iterator2 = ((Iterable)breaks.getLabels()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            String label = (String)iterator2.next();
            boolean bl = false;
            double d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
            while (iterator2.hasNext()) {
                String label2 = (String)iterator2.next();
                $i$a$-maxOf-ColorBarComponentLayout$HorizontalLayout$maxLabelHeight$1 = false;
                double d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
                d = Math.max(d, d2);
            }
            double maxLabelHeight = d;
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX(), this.getGuideBarSize().getY() + this.getLabelDistance() + maxLabelHeight);
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height() / (double)3;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getX();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(tickLocation, this.getGuideBarSize().getY() + this.getLabelDistance());
            return new BreakInfo(tickLocation, labelLocation, Text.HorizontalAnchor.MIDDLE, Text.VerticalAnchor.TOP);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$VerticalLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "barSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "reverse", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "graphSize", "getGraphSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "guideBarLength", "", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nColorBarComponentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorBarComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentLayout$VerticalLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
    private static final class VerticalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        public VerticalLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, domain, breaks, barSize, LegendDirection.VERTICAL, reverse, theme);
            if (!(!breaks.isEmpty())) {
                boolean bl = false;
                String string = "Colorbar VerticalLayout received empty breaks list.";
                throw new IllegalStateException(string.toString());
            }
            Iterator iterator2 = ((Iterable)breaks.getLabels()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            String it = (String)iterator2.next();
            boolean bl = false;
            double d = PlotLabelSpecFactory.INSTANCE.legendItem(theme).width(it);
            while (iterator2.hasNext()) {
                String it2 = (String)iterator2.next();
                $i$a$-maxOf-ColorBarComponentLayout$VerticalLayout$maxLabelWidth$1 = false;
                double d2 = PlotLabelSpecFactory.INSTANCE.legendItem(theme).width(it2);
                d = Math.max(d, d2);
            }
            double maxLabelWidth = d;
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance() + maxLabelWidth, this.getGuideBarSize().getY());
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).width("_") / (double)2;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getY();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance(), tickLocation);
            return new BreakInfo(tickLocation, labelLocation, Text.HorizontalAnchor.LEFT, Text.VerticalAnchor.CENTER);
        }
    }
}

