/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.coord.TransformedCoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.ComponentTransientState;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.frame.FrameOfReferenceBase;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.GridComponent;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 :2\u00020\u0001:\u0002:;BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0018\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0018\u0010(\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J@\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\f\u00104\u001a\b\u0012\u0004\u0012\u000205022\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\u001bH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006<"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference;", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/FrameOfReferenceBase;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "transientState", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$TransientState;", "getTransientState", "()Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$TransientState;", "buildGeomComponent", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "doDrawHAxis", "", "parent", "doDrawHGrid", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "doDrawPanelBorder", "doDrawVAxis", "doDrawVGrid", "doFillBkgr", "doStrokeBkgr", "prepareAxisData", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "axisInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "breakTransformedValues", "", "", "breakLabels", "", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "setClip", "element", "Companion", "TransientState", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1855#2,2:389\n1855#2,2:391\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n*L\n73#1:389,2\n103#1:391,2\n*E\n"})
public final class SquareFrameOfReference
extends FrameOfReferenceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final TransientState transientState;

    public SquareFrameOfReference(@NotNull PlotContext plotContext, @NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, @NotNull DoubleRectangle adjustedDomain, @NotNull CoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme, boolean flipAxis) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(plotContext, adjustedDomain, layoutInfo, marginsLayout, theme, flipAxis);
        this.coord = coord;
        this.transientState = new TransientState(hScaleBreaks, vScaleBreaks, adjustedDomain);
    }

    @Override
    @NotNull
    protected CoordinateSystem getCoord() {
        return this.coord;
    }

    @Override
    @NotNull
    public TransientState getTransientState() {
        return this.transientState;
    }

    @Override
    public void doDrawPanelBorder(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doDrawPanelBorder_u24lambda_u240 = svgRectElement = new SvgRectElement(this.getLayoutInfo().getGeomContentBounds());
        boolean bl = false;
        $this$doDrawPanelBorder_u24lambda_u240.strokeColor().set(this.getTheme().panel().borderColor());
        $this$doDrawPanelBorder_u24lambda_u240.strokeWidth().set(this.getTheme().panel().borderWidth());
        StrokeDashArraySupport.INSTANCE.apply($this$doDrawPanelBorder_u24lambda_u240, this.getTheme().panel().borderWidth(), this.getTheme().panel().borderLineType());
        $this$doDrawPanelBorder_u24lambda_u240.fillOpacity().set(0.0);
        SvgRectElement panelBorder = svgRectElement;
        parent.add(panelBorder);
    }

    @Override
    public void doDrawVAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.getLayoutInfo().getAxisInfos().getLeft(), this.getLayoutInfo().getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> pair2 = this.prepareAxisData(axisInfo, this.getTransientState().getVBreaksTransformedValues(), this.getTransientState().getVBreaksLabels(), this.getVAxisTheme());
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)pair2.component2();
            SvgComponent axisComponent = SquareFrameOfReference.Companion.buildAxis(breaksData, axisInfo, false, !this.getLayoutInfo().getVAxisShown(), this.getVAxisTheme(), labelAdjustments, this.isDebugDrawing());
            DoubleVector axisOrigin = this.getMarginsLayout().toAxisOrigin(this.getLayoutInfo().getGeomInnerBounds(), axisInfo.getOrientation(), this.getCoord().isPolar(), this.getTheme().panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    public void doDrawHAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.getLayoutInfo().getAxisInfos().getTop(), this.getLayoutInfo().getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> pair2 = this.prepareAxisData(axisInfo, this.getTransientState().getHBreaksTransformedValues(), this.getTransientState().getHBreaksLabels(), this.getHAxisTheme());
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)pair2.component2();
            SvgComponent axisComponent = SquareFrameOfReference.Companion.buildAxis(breaksData, axisInfo, false, !this.getLayoutInfo().getHAxisShown(), this.getHAxisTheme(), labelAdjustments, this.isDebugDrawing());
            DoubleVector axisOrigin = this.getMarginsLayout().toAxisOrigin(this.getLayoutInfo().getGeomInnerBounds(), axisInfo.getOrientation(), this.getCoord().isPolar(), this.getTheme().panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    public void doDrawHGrid(@NotNull PanelGridTheme gridTheme, @NotNull SvgComponent parent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            AxisLayoutInfo axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getLeft();
            if (axisLayoutInfo == null) {
                axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getRight();
            }
            if (axisLayoutInfo == null) break block1;
            AxisLayoutInfo axisInfo = axisLayoutInfo;
            boolean bl = false;
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)this.prepareAxisData(axisInfo, this.getTransientState().getVBreaksTransformedValues(), this.getTransientState().getVBreaksLabels(), this.getVAxisTheme()).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), true, true, this.getLayoutInfo().getGeomContentBounds(), gridTheme, this.getTheme().panel());
            DoubleVector gridOrigin = this.getLayoutInfo().getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    public void doDrawVGrid(@NotNull PanelGridTheme gridTheme, @NotNull SvgComponent parent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            AxisLayoutInfo axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getTop();
            if (axisLayoutInfo == null) {
                axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getBottom();
            }
            if (axisLayoutInfo == null) break block1;
            AxisLayoutInfo axisInfo = axisLayoutInfo;
            boolean bl = false;
            AxisComponent.BreaksData breaksData = (AxisComponent.BreaksData)this.prepareAxisData(axisInfo, this.getTransientState().getHBreaksTransformedValues(), this.getTransientState().getHBreaksLabels(), this.getHAxisTheme()).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), false, true, this.getLayoutInfo().getGeomContentBounds(), gridTheme, this.getTheme().panel());
            DoubleVector gridOrigin = this.getLayoutInfo().getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    public void doFillBkgr(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doFillBkgr_u24lambda_u245 = svgRectElement = new SvgRectElement(this.getLayoutInfo().getGeomContentBounds());
        boolean bl = false;
        $this$doFillBkgr_u24lambda_u245.fillColor().set(this.getTheme().panel().rectFill());
        SvgRectElement panel = svgRectElement;
        parent.add(panel);
    }

    @Override
    public void doStrokeBkgr(@NotNull SvgComponent parent) {
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgRectElement $this$doStrokeBkgr_u24lambda_u246 = svgRectElement = new SvgRectElement(this.getLayoutInfo().getGeomContentBounds());
        boolean bl = false;
        $this$doStrokeBkgr_u24lambda_u246.strokeColor().set(this.getTheme().panel().rectColor());
        $this$doStrokeBkgr_u24lambda_u246.strokeWidth().set(this.getTheme().panel().rectStrokeWidth());
        StrokeDashArraySupport.INSTANCE.apply($this$doStrokeBkgr_u24lambda_u246, this.getTheme().panel().rectStrokeWidth(), this.getTheme().panel().rectLineType());
        $this$doStrokeBkgr_u24lambda_u246.fillOpacity().set(0.0);
        SvgRectElement panelRectStroke = svgRectElement;
        parent.add(panelRectStroke);
    }

    private final Pair<AxisComponent.TickLabelAdjustments, AxisComponent.BreaksData> prepareAxisData(AxisLayoutInfo axisInfo, List<Double> breakTransformedValues, List<String> breakLabels, AxisTheme axisTheme) {
        AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(axisInfo.getOrientation(), axisInfo.getTickLabelHorizontalAnchor(), axisInfo.getTickLabelVerticalAnchor(), axisInfo.getTickLabelRotationAngle(), axisInfo.getTickLabelBoundsList(), axisInfo.getTickLabelAdditionalOffsets());
        AxisComponent.BreaksData breaksData = AxisUtil.INSTANCE.breaksData(breakTransformedValues, breakLabels, new TransformedCoordinateSystem(this.getCoord(), this.getTransientState().getOffset(), this.getTransientState().getScale()), this.getTransientState().getDataBounds(), this.getFlipAxis(), axisInfo.getOrientation(), axisTheme, labelAdjustments);
        return new Pair((Object)labelAdjustments, (Object)breaksData);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        return this.buildGeom(layer, targetCollector);
    }

    @Override
    public void setClip(@NotNull SvgComponent element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.clipBounds(this.getLayoutInfo().getGeomContentBounds());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion;", "", "()V", "buildAxis", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "info", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "hideAxis", "", "hideAxisBreaks", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "isDebugDrawing", "calculateTransientBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "bounds", "scale", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "offset", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1#2:389\n1855#3,2:390\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n*L\n268#1:390,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgComponent buildAxis(AxisComponent.BreaksData breaksData, AxisLayoutInfo info, boolean hideAxis, boolean hideAxisBreaks, AxisTheme axisTheme, AxisComponent.TickLabelAdjustments labelAdjustments, boolean isDebugDrawing) {
            AxisComponent axis;
            block3: {
                axis = new AxisComponent(info.getAxisLength(), info.getOrientation(), breaksData, labelAdjustments, axisTheme, hideAxis, hideAxisBreaks);
                if (!isDebugDrawing) break block3;
                org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, info.getTickLabelsBounds(), Color.Companion.getGREEN());
                DoubleRectangle doubleRectangle = info.getTickLabelsTextBounds$plot_builder();
                if (doubleRectangle != null) {
                    DoubleRectangle it = doubleRectangle;
                    boolean bl = false;
                    org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_BLUE());
                }
                List<DoubleRectangle> list2 = info.getTickLabelBoundsList();
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl = false;
                        org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_MAGENTA());
                    }
                }
            }
            return axis;
        }

        private final DoubleRectangle calculateTransientBounds(DoubleRectangle bounds, DoubleVector scale, DoubleVector offset2) {
            DoubleRectangle viewport = InteractionUtil.INSTANCE.viewportFromTransform(bounds, scale, offset2);
            return viewport;
        }

        private static final void buildAxis$drawDebugRect(AxisComponent axis, DoubleRectangle r, Color color) {
            SvgRectElement rect2 = new SvgRectElement(r);
            rect2.strokeColor().set(color);
            rect2.strokeWidth().set(1.0);
            rect2.fillOpacity().set(0.0);
            axis.add(rect2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014JH\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\r0(H\u0002J\b\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020\u001bH\u0002R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$TransientState;", "Lorg/jetbrains/letsPlot/core/plot/builder/ComponentTransientState;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "dataBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "<set-?>", "getDataBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "hBreaksLabels", "", "", "getHBreaksLabels", "()Ljava/util/List;", "hBreaksTransformedValues", "", "getHBreaksTransformedValues", "isCoordFlip", "", "()Z", "vBreaksLabels", "getVBreaksLabels", "vBreaksTransformedValues", "getVBreaksTransformedValues", "repaint", "", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "repaint$plot_builder", "syncDataBounds", "validateBreaksIntern", "dataRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "transformedBreaks", "labels", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "formatter", "Lkotlin/Function1;", "", "validateHorizontalBreaks", "validateVerticalBreaks", "plot-builder"})
    public final class TransientState
    extends ComponentTransientState {
        @NotNull
        private final ScaleBreaks hScaleBreaks;
        @NotNull
        private final ScaleBreaks vScaleBreaks;
        @NotNull
        private final List<Double> hBreaksTransformedValues;
        @NotNull
        private final List<Double> vBreaksTransformedValues;
        @NotNull
        private final List<String> hBreaksLabels;
        @NotNull
        private final List<String> vBreaksLabels;
        @NotNull
        private DoubleRectangle dataBounds;

        public TransientState(@NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, DoubleRectangle dataBounds) {
            Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
            Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
            Intrinsics.checkNotNullParameter((Object)dataBounds, (String)"dataBounds");
            super(SquareFrameOfReference.this.getLayoutInfo().getGeomContentBounds());
            this.hScaleBreaks = hScaleBreaks;
            this.vScaleBreaks = vScaleBreaks;
            this.hBreaksTransformedValues = CollectionsKt.toMutableList((Collection)this.hScaleBreaks.getTransformedValues());
            this.vBreaksTransformedValues = CollectionsKt.toMutableList((Collection)this.vScaleBreaks.getTransformedValues());
            this.hBreaksLabels = CollectionsKt.toMutableList((Collection)this.hScaleBreaks.getLabels());
            this.vBreaksLabels = CollectionsKt.toMutableList((Collection)this.vScaleBreaks.getLabels());
            this.dataBounds = dataBounds;
        }

        @NotNull
        public final List<Double> getHBreaksTransformedValues() {
            return this.hBreaksTransformedValues;
        }

        @NotNull
        public final List<Double> getVBreaksTransformedValues() {
            return this.vBreaksTransformedValues;
        }

        @NotNull
        public final List<String> getHBreaksLabels() {
            return this.hBreaksLabels;
        }

        @NotNull
        public final List<String> getVBreaksLabels() {
            return this.vBreaksLabels;
        }

        @Override
        @NotNull
        public DoubleRectangle getDataBounds() {
            return this.dataBounds;
        }

        @Override
        public boolean isCoordFlip() {
            return SquareFrameOfReference.this.getFlipAxis();
        }

        @Override
        protected void syncDataBounds(@NotNull InteractionContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            DoubleRectangle transientBounds = Companion.calculateTransientBounds(this.getViewBounds(), this.getScale(), this.getOffset());
            this.dataBounds = ctx2.clientRectToDataBounds(transientBounds.subtract(this.getViewBounds().getOrigin()), SquareFrameOfReference.this.getCoord());
        }

        @Override
        public void repaint$plot_builder(@NotNull InteractionContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            this.validateHorizontalBreaks();
            this.validateVerticalBreaks();
            SquareFrameOfReference.this.repaintFrame();
        }

        private final void validateHorizontalBreaks() {
            if (this.hScaleBreaks.getFixed() || this.hBreaksTransformedValues.size() < 2) {
                return;
            }
            DoubleSpan hDataRange = this.getDataBounds().flipIf(SquareFrameOfReference.this.getFlipAxis()).xRange();
            this.validateBreaksIntern(hDataRange, this.hBreaksTransformedValues, this.hBreaksLabels, this.hScaleBreaks.getTransform(), this.hScaleBreaks.getFormatter());
        }

        private final void validateVerticalBreaks() {
            if (this.vScaleBreaks.getFixed() || this.vBreaksTransformedValues.size() < 2) {
                return;
            }
            DoubleSpan vDataRange = this.getDataBounds().flipIf(SquareFrameOfReference.this.getFlipAxis()).yRange();
            this.validateBreaksIntern(vDataRange, this.vBreaksTransformedValues, this.vBreaksLabels, this.vScaleBreaks.getTransform(), this.vScaleBreaks.getFormatter());
        }

        private final void validateBreaksIntern(DoubleSpan dataRange, List<Double> transformedBreaks, List<String> labels, Transform transform2, Function1<Object, String> formatter2) {
            Object domainV;
            if (dataRange.contains(((Number)CollectionsKt.first(transformedBreaks)).doubleValue())) {
                double newFirstBreak = ((Number)transformedBreaks.get(0)).doubleValue() - (((Number)transformedBreaks.get(1)).doubleValue() - ((Number)transformedBreaks.get(0)).doubleValue());
                transformedBreaks.add(0, newFirstBreak);
                domainV = transform2.applyInverse(newFirstBreak);
                labels.add(0, TransientState.validateBreaksIntern$format(domainV, formatter2));
            }
            if (dataRange.contains(((Number)CollectionsKt.last(transformedBreaks)).doubleValue())) {
                double newLastBreak = ((Number)CollectionsKt.last(transformedBreaks)).doubleValue() + (((Number)CollectionsKt.last(transformedBreaks)).doubleValue() - ((Number)transformedBreaks.get(transformedBreaks.size() - 2)).doubleValue());
                transformedBreaks.add(newLastBreak);
                domainV = transform2.applyInverse(newLastBreak);
                labels.add(TransientState.validateBreaksIntern$format(domainV, formatter2));
            }
        }

        private static final String validateBreaksIntern$format(Object v, Function1<Object, String> formatter2) {
            String string;
            if (v == null) {
                string = "---";
            } else {
                String string2;
                try {
                    string2 = (String)formatter2.invoke(v);
                }
                catch (RuntimeException _) {
                    string2 = "---";
                }
                string = string2;
            }
            return string;
        }
    }
}

