/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import korlibs.crypto.Cipher;
import korlibs.crypto.CipherModeIVDE;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lkorlibs/crypto/CipherModeOFB;", "Lkorlibs/crypto/CipherModeIVDE;", "()V", "coreCrypt", "", "pData", "", "cipher", "Lkorlibs/crypto/Cipher;", "ivb", "krypto"})
final class CipherModeOFB
extends CipherModeIVDE {
    @NotNull
    public static final CipherModeOFB INSTANCE = new CipherModeOFB();

    private CipherModeOFB() {
        super("OFB");
    }

    @Override
    protected void coreCrypt(@NotNull byte[] pData, @NotNull Cipher cipher, @NotNull byte[] ivb) {
        int blockSize = cipher.getBlockSize();
        byte[] cipherText = new byte[blockSize];
        Cipher.DefaultImpls.encrypt$default(cipher, ivb, 0, 0, 6, null);
        int n = pData.length + -1;
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + blockSize + '.');
        }
        int n2 = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)blockSize);
        if (n2 <= n3) {
            while (true) {
                KryptoToolsKt.arraycopy(pData, n2, cipherText, 0, blockSize);
                KryptoToolsKt.arrayxor(cipherText, 0, ivb);
                KryptoToolsKt.arraycopy(cipherText, 0, pData, n2, blockSize);
                if (n2 + blockSize < pData.length) {
                    Cipher.DefaultImpls.encrypt$default(cipher, ivb, 0, 0, 6, null);
                }
                if (n2 == n3) break;
                n2 += blockSize;
            }
        }
    }
}

