/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.MavenWslTargetConfiguratorKt;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenEelUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenWslTargetConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "prepareMavenData", "project", "Lcom/intellij/openapi/project/Project;", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getJdkPath", "", "asMavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "Lorg/jetbrains/idea/maven/project/MavenInSpecificPath;", "getMavenUsedForSync", "configureForProject", "createMavenConfiguration", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "configuration", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "createJavaConfiguration", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "createWslTarget", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenWslTargetConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWslTargetConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenWslTargetConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class MavenWslTargetConfigurator
implements MavenWorkspaceConfigurator {
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.prepareMavenData(context2.getProject(), (UserDataHolder)context2);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!SystemInfo.isWindows) {
            return;
        }
        this.configureForProject(context2.getProject(), (UserDataHolder)context2);
    }

    private final void prepareMavenData(Project project, UserDataHolder dataHolder) {
        String string;
        block5: {
            block4: {
                string = project.getBasePath();
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                WSLDistribution wSLDistribution = MavenWslTargetConfiguratorKt.access$tryGetWslDistribution(project);
                string = wSLDistribution;
                if (wSLDistribution != null) break block5;
            }
            return;
        }
        String wslDistribution = string;
        dataHolder.putUserData(MavenWslTargetConfiguratorKt.access$getWSL_DISTRIBUTION$p(), (Object)wslDistribution);
        EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)project));
        Object object = MavenEelUtil.INSTANCE.findMavenDistribution(eel);
        if (object == null || (object = this.asMavenDistribution((MavenInSpecificPath)object)) == null) {
            object = this.getMavenUsedForSync(project);
        }
        Object distribution = object;
        Path mavenHome = distribution.getMavenHome();
        dataHolder.putUserData(MavenWslTargetConfiguratorKt.access$getMAVEN_HOME_DIR$p(), (Object)mavenHome);
        dataHolder.putUserData(MavenWslTargetConfiguratorKt.access$getMAVEN_TARGET_PATH$p(), (Object)EelNioBridgeServiceKt.asEelPath((Path)mavenHome).toString());
        dataHolder.putUserData(MavenWslTargetConfiguratorKt.access$getMAVEN_HOME_VERSION$p(), (Object)distribution.getVersion());
        String jdkPath = this.getJdkPath(project);
        dataHolder.putUserData(MavenWslTargetConfiguratorKt.access$getJDK_PATH$p(), (Object)jdkPath);
    }

    private final String getJdkPath(Project project) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk == null) {
            sdk = MavenUtil.INSTANCE.getJdkForImporter$intellij_maven(project);
        }
        Sdk jdk = sdk;
        return jdk.getHomePath();
    }

    private final MavenDistribution asMavenDistribution(MavenInSpecificPath $this$asMavenDistribution) {
        Path path = Path.of($this$asMavenDistribution.getMavenHome(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return new LocalMavenDistribution(path, $this$asMavenDistribution.getTitle());
    }

    private final MavenDistribution getMavenUsedForSync(Project $this$getMavenUsedForSync) {
        MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance($this$getMavenUsedForSync).getMavenDistribution($this$getMavenUsedForSync.getBasePath());
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
        return mavenDistribution;
    }

    /*
     * Unable to fully structure code
     */
    private final void configureForProject(Project project, UserDataHolder dataHolder) {
        block7: {
            wslDistribution = (WSLDistribution)dataHolder.getUserData(MavenWslTargetConfiguratorKt.access$getWSL_DISTRIBUTION$p());
            if (wslDistribution == null) {
                return;
            }
            var7_4 = TargetEnvironmentsManager.Companion.getInstance(project).getTargets().resolvedConfigs();
            for (T var9_6 : var7_4) {
                it = (TargetEnvironmentConfiguration)var9_6;
                $i$a$-find-MavenWslTargetConfigurator$configureForProject$configuration$1 = false;
                if (!Intrinsics.areEqual((Object)it.getTypeId(), (Object)"wsl")) ** GOTO lbl-1000
                v0 = it instanceof WslTargetEnvironmentConfiguration != false ? (WslTargetEnvironmentConfiguration)it : null;
                if (Intrinsics.areEqual((Object)(v0 != null ? v0.getDistribution() : null), (Object)wslDistribution)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = var9_6;
                break block7;
            }
            v2 = null;
        }
        var5_9 = v2;
        configuration = var5_9 instanceof WslTargetEnvironmentConfiguration != false ? (WslTargetEnvironmentConfiguration)var5_9 : null;
        v3 = configuration;
        javaConfiguration = v3 != null && (v3 = v3.getRuntimes()) != null ? (JavaLanguageRuntimeConfiguration)v3.findByType(JavaLanguageRuntimeConfiguration.class) : null;
        v4 = configuration;
        v5 = mavenConfiguration = v4 != null && (v4 = v4.getRuntimes()) != null ? (MavenRuntimeTargetConfiguration)v4.findByType(MavenRuntimeTargetConfiguration.class) : null;
        v6 = configuration;
        if (v6 == null) {
            v6 = targetConfiguration = this.createWslTarget(project, wslDistribution);
        }
        if ((v7 = javaConfiguration) == null) {
            v7 = this.createJavaConfiguration(targetConfiguration, project, dataHolder, wslDistribution);
        }
        if ((v8 = mavenConfiguration) == null) {
            v8 = this.createMavenConfiguration(targetConfiguration, project, dataHolder, wslDistribution);
        }
    }

    private final MavenRuntimeTargetConfiguration createMavenConfiguration(WslTargetEnvironmentConfiguration configuration, Project project, UserDataHolder dataHolder, WSLDistribution wslDistribution) {
        MavenRuntimeTargetConfiguration mavenConfig = new MavenRuntimeTargetConfiguration();
        String targetMavenPath = (String)dataHolder.getUserData(MavenWslTargetConfiguratorKt.access$getMAVEN_TARGET_PATH$p());
        if (targetMavenPath == null) {
            MavenSyncConsole mavenSyncConsole = MavenProjectsManager.getInstance(project).getSyncConsole();
            String string = MavenProjectBundle.message("wsl.misconfigured.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{wslDistribution.getPresentableName()};
            String string2 = MavenProjectBundle.message("wsl.does.not.have.configured.maven", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            mavenSyncConsole.addWarning(string, string2);
            return null;
        }
        String mavenVersion = (String)dataHolder.getUserData(MavenWslTargetConfiguratorKt.access$getMAVEN_HOME_VERSION$p());
        mavenConfig.setHomePath(targetMavenPath);
        String string = mavenVersion;
        if (string == null) {
            string = "";
        }
        mavenConfig.setVersionString(string);
        configuration.addLanguageRuntime((LanguageRuntimeConfiguration)mavenConfig);
        return mavenConfig;
    }

    private final JavaLanguageRuntimeConfiguration createJavaConfiguration(WslTargetEnvironmentConfiguration configuration, Project project, UserDataHolder dataHolder, WSLDistribution wslDistribution) {
        JavaLanguageRuntimeConfiguration javaConfig = new JavaLanguageRuntimeConfiguration();
        String jdkPath = (String)dataHolder.getUserData(MavenWslTargetConfiguratorKt.access$getJDK_PATH$p());
        if (jdkPath == null) {
            MavenSyncConsole mavenSyncConsole = MavenProjectsManager.getInstance(project).getSyncConsole();
            String string = MavenProjectBundle.message("wsl.misconfigured.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{wslDistribution.getPresentableName()};
            String string2 = MavenProjectBundle.message("wsl.does.not.have.configured.jdk", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            mavenSyncConsole.addWarning(string, string2);
            return null;
        }
        javaConfig.setHomePath(jdkPath);
        configuration.addLanguageRuntime((LanguageRuntimeConfiguration)javaConfig);
        return javaConfig;
    }

    private final WslTargetEnvironmentConfiguration createWslTarget(Project project, WSLDistribution wslDistribution) {
        WslTargetEnvironmentConfiguration configuration = new WslTargetEnvironmentConfiguration(wslDistribution);
        configuration.setDisplayName("WSL");
        TargetEnvironmentsManager.Companion.getInstance(project).addTarget((TargetEnvironmentConfiguration)configuration);
        return configuration;
    }
}

