// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6

// RUN: %clang_cc1 -triple x86_64-pc-linux-gnu -emit-llvm -O1 -o - %s \
// RUN:     | FileCheck %s --check-prefixes=CLEAN-O1

// RUN: %clang_cc1 -triple x86_64-pc-linux-gnu -emit-llvm -O1 -o - %s \
// RUN:     -fsanitize=signed-integer-overflow \
// RUN:     -fsanitize-skip-hot-cutoff=signed-integer-overflow=1.0 \
// RUN:     -fallow-runtime-check-skip-hot-cutoff=1.0 \
// RUN:     | FileCheck %s --check-prefixes=UBSAN-O1

// This test shows that -fsanitize-skip-hot-cutoff=...=1.0 plus
// -fallow-runtime-check-skip-hot-cutoff=1.0 does not perfectly undo the
// effects of -fsanitize.

// CLEAN-O1-LABEL: define dso_local i32 @overflow(
// CLEAN-O1-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CLEAN-O1-NEXT:  [[ENTRY:.*:]]
// CLEAN-O1-NEXT:    [[ADD:%.*]] = add nsw i32 [[Y]], [[X]]
// CLEAN-O1-NEXT:    ret i32 [[ADD]]
//
// UBSAN-O1-LABEL: define dso_local noundef i32 @overflow(
// UBSAN-O1-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// UBSAN-O1-NEXT:  [[ENTRY:.*:]]
// UBSAN-O1-NEXT:    [[TMP0:%.*]] = add i32 [[X]], [[Y]]
// UBSAN-O1-NEXT:    ret i32 [[TMP0]]
//
int overflow(int x, int y) {
  return x + y;
}
