/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.internal.ByteArrayUtil;

final class NativeByteArrayByteAccess
implements ByteAccess<byte[]> {
    private static final NativeByteArrayByteAccess INSTANCE = new NativeByteArrayByteAccess();

    private NativeByteArrayByteAccess() {
    }

    public static NativeByteArrayByteAccess get() {
        return INSTANCE;
    }

    @Override
    public byte getByte(byte[] data, long idx) {
        return data[(int)idx];
    }

    @Override
    public int getByteAsUnsignedInt(byte[] data, long idx) {
        return data[(int)idx] & 0xFF;
    }

    @Override
    public long getByteAsUnsignedLong(byte[] data, long idx) {
        return (long)data[(int)idx] & 0xFFL;
    }

    @Override
    public int getInt(byte[] data, long idx) {
        return ByteArrayUtil.getInt(data, (int)idx);
    }

    @Override
    public long getIntAsUnsignedLong(byte[] data, long idx) {
        return (long)ByteArrayUtil.getInt(data, (int)idx) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(byte[] data, long idx) {
        return ByteArrayUtil.getLong(data, (int)idx);
    }

    @Override
    public void copyToByteArray(byte[] data, long idx, byte[] array, int off, int len) {
        System.arraycopy(data, (int)idx, array, off, len);
    }
}

