/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.data.MicronautDataConstants;
import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.micronaut.jam.data.MnDataIdProperty;
import com.intellij.micronaut.jam.data.MnDataMappedEntity;
import com.intellij.micronaut.jam.data.MnDataMappedProperty;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.semantic.SemService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

public final class MicronautDataUtil {
    public static boolean hasMicronautDataSupport(Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"io.micronaut.data:micronaut-data-model");
    }

    public static boolean hasMicronautDataSupport(Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"io.micronaut.data:micronaut-data-model");
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(0);
        }
        if (MicronautDataUtil.isDefaultMethod(psiMethod)) {
            return false;
        }
        if (MicronautDataUtil.isImplementedInAbstractClass(psiMethod)) {
            return false;
        }
        for (Pattern pattern : Holder.PART_TREE_CONTEXT.prefixTemplates()) {
            if (!pattern.matcher(psiMethod.getName()).find()) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplementedInAbstractClass(@NotNull PsiMethod psiMethod) {
        PsiClass containingClass;
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(1);
        }
        return (containingClass = psiMethod.getContainingClass()) != null && containingClass.hasModifier(JvmModifier.ABSTRACT) && !psiMethod.hasModifier(JvmModifier.ABSTRACT);
    }

    public static boolean isDefaultMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(2);
        }
        return psiMethod.getModifierList().hasModifierProperty("default");
    }

    public static boolean isRepository(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(3);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"io.micronaut.data.repository.GenericRepository") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"io.micronaut.data.annotation.Repository", (int)1);
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        Project project;
        PsiClassType psiClassType;
        PsiType psiType;
        if (repositoryClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(4);
        }
        if ((psiType = PsiUtil.substituteTypeParameter((PsiType)(psiClassType = JavaPsiFacade.getInstance((Project)(project = repositoryClass.getProject())).getElementFactory().createType(repositoryClass)), (String)"io.micronaut.data.repository.GenericRepository", (int)0, (boolean)false)) instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"io.micronaut.data.repository.GenericRepository", (int)1, (boolean)false);
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass == null || idPsiType == null ? null : Pair.create((Object)psiClass, (Object)idPsiType);
        }
        return null;
    }

    public static Set<String> getProperties(@NotNull PsiClass domainClass) {
        String qualifiedName;
        if (domainClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(5);
        }
        if ((qualifiedName = domainClass.getQualifiedName()) == null || qualifiedName.startsWith("java.lang")) {
            return Collections.emptySet();
        }
        HashSet<String> all = new HashSet<String>();
        all.addAll(PropertyUtilBase.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true).keySet());
        all.addAll(ContainerUtil.map((Object[])domainClass.getFields(), field -> PropertyUtilBase.suggestPropertyName((PsiField)field)));
        return all;
    }

    public static boolean hasQueryAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(6);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"io.micronaut.data.annotation.Query", (int)1);
    }

    public static boolean hasMongoQueryAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(7);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, MicronautDataConstants.MONGO_QUERY_ANNOTATIONS, (int)0);
    }

    @Nullable
    public static MnDataMappedEntity getMappedEntity(UClass uClass) {
        return (MnDataMappedEntity)MnDataMappedEntity.META.getJamElement((PsiModifierListOwner)uClass.getJavaPsi());
    }

    @Nullable
    public static MnDataMappedProperty<?> getMappedProperty(UDeclaration uDeclaration) {
        PsiElement psiElement = uDeclaration.getJavaPsi();
        return psiElement != null ? (MnDataMappedProperty)SemService.getSemService((Project)psiElement.getProject()).getSemElement(MnDataMappedProperty.SEM_KEY, psiElement) : null;
    }

    @Nullable
    public static MnDataIdProperty<?> getIdProperty(UDeclaration uDeclaration) {
        PsiElement psiElement = uDeclaration.getJavaPsi();
        return psiElement != null ? (MnDataIdProperty)SemService.getSemService((Project)psiElement.getProject()).getSemElement(MnDataIdProperty.SEM_KEY, psiElement) : null;
    }

    @Nullable
    public static String getFieldName(@NotNull UDeclaration uDeclaration) {
        MnDataMappedProperty<?> dbDocumentField;
        if (uDeclaration == null) {
            MicronautDataUtil.$$$reportNull$$$0(8);
        }
        if ((dbDocumentField = MicronautDataUtil.getMappedProperty(uDeclaration)) != null && !StringUtil.isEmptyOrSpaces((String)dbDocumentField.getName())) {
            return dbDocumentField.getName();
        }
        if (uDeclaration instanceof UField) {
            return ((UField)uDeclaration).getName();
        }
        if (uDeclaration instanceof UMethod) {
            ((UMethod)uDeclaration).getName();
        }
        return null;
    }

    @Nullable
    public static String getEntityName(@NotNull UClass uClass) {
        MnDataMappedEntity mappedEntity;
        if (uClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(9);
        }
        if ((mappedEntity = MicronautDataUtil.getMappedEntity(uClass)) != null && !StringUtil.isEmptyOrSpaces((String)mappedEntity.getEntityName())) {
            return mappedEntity.getEntityName();
        }
        String uClassName = uClass.getJavaPsi().getName();
        if (!StringUtil.isEmptyOrSpaces((String)uClassName)) {
            return uClassName.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            MicronautDataUtil.$$$reportNull$$$0(10);
        }
        if (psiMember instanceof PsiField) {
            PsiField psiField = (PsiField)psiMember;
            MnDataMappedProperty mappedProperty = (MnDataMappedProperty)MnDataMappedProperty.FIELD_META.getJamElement((PsiModifierListOwner)psiField);
            return MicronautDataUtil.getPropertyName(mappedProperty, (PsiMember)psiField);
        }
        if (psiMember instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)psiMember;
            MnDataMappedProperty mappedProperty = (MnDataMappedProperty)MnDataMappedProperty.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod);
            return MicronautDataUtil.getPropertyName(mappedProperty, (PsiMember)psiMethod);
        }
        return null;
    }

    @Nullable
    private static String getPropertyName(@Nullable MnDataMappedProperty<?> mappedProperty, @Nullable PsiMember psiMember) {
        if (mappedProperty != null && !StringUtil.isEmptyOrSpaces((String)mappedProperty.getName())) {
            return mappedProperty.getName();
        }
        return psiMember != null ? psiMember.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
        }
        objectArray2[1] = "com/intellij/micronaut/data/MicronautDataUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isQueryMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplementedInAbstractClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRepository";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteRepositoryTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasQueryAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMongoQueryAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntityName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final MicronautPartTreeParserContext PART_TREE_CONTEXT = MicronautPartTreeParserContext.create();

        private Holder() {
        }
    }
}

