/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiDirectory;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.modulith.model.ModuleSource;
import com.intellij.spring.modulith.model.SpringModulithModelUtilsKt;
import com.intellij.spring.modulith.model.Strategy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithDetectionStrategy;", "", "strategy", "Lcom/intellij/spring/modulith/model/Strategy;", "<init>", "(Lcom/intellij/spring/modulith/model/Strategy;)V", "getModuleSources", "", "Lcom/intellij/spring/modulith/model/ModuleSource;", "rootPackageDir", "Lcom/intellij/psi/PsiDirectory;", "collectNestedModules", "", "currentDir", "moduleDirs", "", "isDeclaredAsModule", "", "psiDirectory", "toModuleSource", "Companion", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithDetectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithDetectionStrategy.kt\ncom/intellij/spring/modulith/model/SpringModulithDetectionStrategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n11561#2:90\n11896#2,3:91\n3919#2:94\n4434#2,2:95\n13805#2,2:101\n13805#2,2:103\n1563#3:97\n1634#3,3:98\n*S KotlinDebug\n*F\n+ 1 SpringModulithDetectionStrategy.kt\ncom/intellij/spring/modulith/model/SpringModulithDetectionStrategy\n*L\n22#1:90\n22#1:91,3\n25#1:94\n25#1:95,2\n28#1:101,2\n34#1:103,2\n25#1:97\n25#1:98,3\n*E\n"})
public final class SpringModulithDetectionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Strategy strategy;

    private SpringModulithDetectionStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModuleSource> getModuleSources(@NotNull PsiDirectory rootPackageDir) {
        Intrinsics.checkNotNullParameter((Object)rootPackageDir, (String)"rootPackageDir");
        Set moduleDirs = new LinkedHashSet();
        PsiDirectory[] psiDirectoryArray = rootPackageDir.getSubdirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
        PsiDirectory[] subdirectories = psiDirectoryArray;
        if (this.strategy == Strategy.DIRECT_SUB_PACKAGES) {
            var4_4 = moduleDirs;
            $this$map$iv = subdirectories;
            $i$f$map = false;
            PsiDirectory[] psiDirectoryArray2 = $this$map$iv;
            destination$iv$iv = new ArrayList(((PsiDirectory[])$this$map$iv).length);
            $i$f$mapTo = false;
            int n = psiDirectoryArray2.length;
            for (int i = 0; i < n; ++i) {
                void p0;
                PsiDirectory item$iv$iv;
                PsiDirectory psiDirectory = item$iv$iv = psiDirectoryArray2[i];
                var15_27 = destination$iv$iv;
                bl = false;
                var15_27.add(this.toModuleSource((PsiDirectory)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)var4_4, (Iterable)$this$map$iv);
        } else {
            PsiDirectory element$iv$iv;
            var4_4 = moduleDirs;
            Object $this$filter$iv = subdirectories;
            boolean $i$f$filter = false;
            PsiDirectory[] n = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n2 = n.length;
            for (int i = 0; i < n2; ++i) {
                PsiDirectory p0 = element$iv$iv = n[i];
                bl = false;
                if (!this.isDeclaredAsModule(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            Object object = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void p0;
                Object t = iterator.next();
                element$iv$iv = (PsiDirectory)t;
                var15_27 = destination$iv$iv;
                boolean bl = false;
                var15_27.add(this.toModuleSource((PsiDirectory)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)var4_4, (Iterable)$this$map$iv);
        }
        PsiDirectory[] $this$forEach$iv = subdirectories;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PsiDirectory element$iv;
            PsiDirectory it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.collectNestedModules(it, moduleDirs);
        }
        return CollectionsKt.toList((Iterable)moduleDirs);
    }

    private final void collectNestedModules(PsiDirectory currentDir, Set<ModuleSource> moduleDirs) {
        PsiDirectory[] psiDirectoryArray = currentDir.getSubdirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
        Object[] $this$forEach$iv = psiDirectoryArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiDirectory subdirectory = (PsiDirectory)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)subdirectory);
            if (this.isDeclaredAsModule(subdirectory)) {
                ((Collection)moduleDirs).add(this.toModuleSource(subdirectory));
            }
            this.collectNestedModules(subdirectory, moduleDirs);
        }
    }

    private final boolean isDeclaredAsModule(PsiDirectory psiDirectory) {
        return SpringModulithModelUtilsKt.getApplicationModuleAnnotation(psiDirectory) != null;
    }

    private final ModuleSource toModuleSource(PsiDirectory psiDirectory) {
        PsiAnnotation applicationModuleAnnotation = SpringModulithModelUtilsKt.getApplicationModuleAnnotation(psiDirectory);
        Object object = applicationModuleAnnotation;
        if (object == null || (object = object.findDeclaredAttributeValue("id")) == null || (object = SpringModulithModelUtilsKt.stringValue((PsiAnnotationMemberValue)object)) == null) {
            String string = psiDirectory.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        Object id = object;
        Object object2 = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        if (object2 == null || (object2 = object2.getQualifiedName()) == null) {
            String string = psiDirectory.getName();
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return new ModuleSource((String)id, psiDirectory, (String)object2);
    }

    public /* synthetic */ SpringModulithDetectionStrategy(Strategy strategy, DefaultConstructorMarker $constructor_marker) {
        this(strategy);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithDetectionStrategy$Companion;", "", "<init>", "()V", "forModule", "Lcom/intellij/spring/modulith/model/SpringModulithDetectionStrategy;", "module", "Lcom/intellij/openapi/module/Module;", "useExplicitStrategy", "", "intellij.spring.modulith"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @RequiresBackgroundThread
        @NotNull
        public final SpringModulithDetectionStrategy forModule(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ThreadingAssertions.assertReadAccess();
            ThreadingAssertions.assertBackgroundThread();
            Strategy strategy = this.useExplicitStrategy(module) ? Strategy.EXPLICITLY_ANNOTATED : Strategy.DIRECT_SUB_PACKAGES;
            return new SpringModulithDetectionStrategy(strategy, null);
        }

        private final boolean useExplicitStrategy(Module module) {
            String propertyValue = SpringBootConfigValueSearcher.Companion.productionForProfiles$default((SpringBootConfigValueSearcher.Companion)SpringBootConfigValueSearcher.Companion, (Module)module, (String)"spring.modulith.detection-strategy", null, (boolean)false, (int)8, null).findValueText();
            return Intrinsics.areEqual((Object)propertyValue, (Object)"explicitly-annotated");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

