/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.sql.backend;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.SqlObjectBuilderImplKt;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.dataspell.jupyter.customCells.sql.backend.run.JupyterSqlPythonUtilKt;
import com.intellij.dataspell.jupyter.customCells.sql.common.JupyterSqlCellsSettings;
import com.intellij.dataspell.jupyter.customCells.sql.common.metadata.SqlCellMetadata;
import com.intellij.dataspell.jupyter.customCells.sql.common.metadata.SqlCellMetadataKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.dialects.generic.GenericDialect;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001a\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r\u0018\u00010\u00060\u0005H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/sql/backend/JupyterSqlLanguageInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "<init>", "()V", "elementsToInject", "", "Ljava/lang/Class;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "cell", "Lcom/intellij/psi/PsiElement;", "getDialectFromDataSource", "Lcom/intellij/lang/Language;", "node", "isSqlCell", "", "elementsToInjectIn", "intellij.dataspell.jupyter.customCells.sql.backend"})
@SourceDebugExtension(value={"SMAP\nJupyterSqlLanguageInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSqlLanguageInjector.kt\ncom/intellij/dataspell/jupyter/customCells/sql/backend/JupyterSqlLanguageInjector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
final class JupyterSqlLanguageInjector
implements MultiHostInjector {
    @NotNull
    private final List<Class<JupyterPsiCell>> elementsToInject = CollectionsKt.listOf(JupyterPsiCell.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement cell) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (!JupyterSqlCellsSettings.INSTANCE.isEnabled()) {
            return;
        }
        if (!(cell instanceof JupyterPsiCell)) {
            return;
        }
        if (!this.isSqlCell((JupyterPsiCell)cell)) {
            return;
        }
        Language language = this.getDialectFromDataSource(cell);
        if (language == null) {
            language = (Language)GenericDialect.INSTANCE;
        }
        registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)cell, ((JupyterPsiCell)cell).getSource().getTextRangeInParent()).doneInjecting();
    }

    private final Language getDialectFromDataSource(PsiElement node) {
        PsiFile psiFile;
        block10: {
            block9: {
                psiFile = node.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) break block9;
                PsiFile psiFile2 = psiFile;
                BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                PsiFile p0 = psiFile2;
                boolean bl = false;
                BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked((VirtualFile)p0);
                psiFile = backedNotebookVirtualFile;
                if (backedNotebookVirtualFile != null) break block10;
            }
            return null;
        }
        PsiFile notebook = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)node.getProject()).getDocument(node.getContainingFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (!NotebookCellLines.Companion.hasSupport(document2)) {
            return null;
        }
        int lineNumber = document2.getLineNumber(SqlObjectBuilderImplKt.getStartOffset((PsiElement)node));
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)NotebookCellLines.Companion.get(document2).intervalsIterator(lineNumber).next();
        JupyterNotebook jupyterNotebook = notebook.getNotebookOrNull();
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook jupyterNotebook2 = jupyterNotebook;
        JupyterCell cell = jupyterNotebook2.getCell(interval.getOrdinal());
        if (!Intrinsics.areEqual((Object)cell.getCellTypeProvider().getJupyterCellType(), (Object)JupyterCellType.Companion.getSQL())) {
            return null;
        }
        SqlCellMetadata sqlCellMetadata = SqlCellMetadataKt.getSqlMetadata((JupyterCell)cell);
        if (sqlCellMetadata == null) {
            return null;
        }
        SqlCellMetadata sqlMetadata = sqlCellMetadata;
        String string = sqlMetadata.getDataSourceName();
        if (string == null) {
            return DbSqlUtil.getLanguage((Dbms)Dbms.POSTGRES);
        }
        String dataSource = string;
        Project project = node.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DbDataSource dbDataSource = JupyterSqlPythonUtilKt.findDataBaseByName(project, dataSource);
        return dbDataSource != null ? dbDataSource.getLanguage() : null;
    }

    private final boolean isSqlCell(JupyterPsiCell cell) {
        String string = cell.getCellMarker().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)string, (CharSequence)"\n"), (Object)"#%% sql");
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return this.elementsToInject;
    }
}

