/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers;

import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers.RawInputEventTransformer;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEvent;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/CaretMovementEventTransformer;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/RawInputEventTransformer;", "Lcom/intellij/openapi/editor/event/CaretEvent;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "transformRawInput", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEvent;", "rawEvent", "getCell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.kotlin.jupyter.core"})
public final class CaretMovementEventTransformer
extends HighlightingComponent
implements RawInputEventTransformer<CaretEvent> {
    @NotNull
    private final Editor editor;
    @NotNull
    private final ReentrantReadWriteLock stateLock;

    public CaretMovementEventTransformer(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.stateLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public HighlightingEvent transformRawInput(@NotNull CaretEvent rawEvent) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)rawEvent, (String)"rawEvent");
        LogicalPosition logicalPosition = rawEvent.getNewPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
        NotebookCellLines.Interval newCell = this.getCell(logicalPosition);
        LogicalPosition logicalPosition2 = rawEvent.getOldPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"getOldPosition(...)");
        NotebookCellLines.Interval oldCell = this.getCell(logicalPosition2);
        int ord = newCell.getOrdinal();
        if (ord == oldCell.getOrdinal()) {
            return null;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Integer n2 = ord;
            LogicalPosition logicalPosition3 = rawEvent.getOldPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"getOldPosition(...)");
            pair2 = TuplesKt.to((Object)n2, (Object)this.getCell(logicalPosition3).getOrdinal());
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        Pair pair3 = pair2;
        int newFocusCellIndex = ((Number)pair3.component1()).intValue();
        int previousFocusCellIndex = ((Number)pair3.component2()).intValue();
        return new HighlightingEvent(newFocusCellIndex, previousFocusCellIndex == ord || previousFocusCellIndex == -1 ? null : Integer.valueOf(previousFocusCellIndex), null, true);
    }

    private final NotebookCellLines.Interval getCell(LogicalPosition $this$getCell) {
        return NotebookVisualizationUiUtilKt.getCell((Editor)this.editor, (int)Math.min($this$getCell.line, this.editor.getDocument().getLineCount() - 1));
    }
}

