/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deployment.ui.DockerBindingsFieldBase;
import com.intellij.docker.deployment.ui.DockerHostPathField;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerVolumeBindingsField
extends DockerBindingsFieldBase<DockerVolumeBindingImpl> {
    private String mySampleHostPath;
    private final Project myProject;

    DockerVolumeBindingsField(Project project) {
        this.myProject = project;
        this.addActionListener(e -> this.showDialog());
        this.setEditable(false);
    }

    public DockerVolumeBindingsField withSampleHostPath(@Nullable String sampleHostPath) {
        this.mySampleHostPath = sampleHostPath;
        return this;
    }

    private void showDialog() {
        DockerBindingsFieldBase.BindingsDialogBase<DockerVolumeBindingImpl> dialog = new DockerBindingsFieldBase.BindingsDialogBase<DockerVolumeBindingImpl>(this, new VolumeBindingsTable());
        dialog.setTitle(DockerBundle.message((String)"DockerVolumeBindingsField.dialogTitle", (Object[])new Object[0]));
        dialog.setEmptyText(DockerBundle.message((String)"DockerVolumeBindingsField.dialogEmptyText", (Object[])new Object[0]));
        dialog.show();
    }

    @Override
    protected String stringify(@NotNull DockerVolumeBindingImpl binding) {
        if (binding == null) {
            DockerVolumeBindingsField.$$$reportNull$$$0(0);
        }
        return binding.toCommandLineString();
    }

    @Override
    protected String stringifyAll(@NotNull List<DockerVolumeBindingImpl> list) {
        if (list == null) {
            DockerVolumeBindingsField.$$$reportNull$$$0(1);
        }
        return this.stringifyAll(list, "  ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerVolumeBindingsField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stringify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stringifyAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class VolumeBindingsTable
    extends DockerBindingsFieldBase.BindingsTableBase<DockerVolumeBindingImpl> {
        private final DockerVolumeBindingImpl EMPTY = new DockerVolumeBindingImpl();

        private VolumeBindingsTable() {
        }

        protected ListTableModel<DockerVolumeBindingImpl> createListModel() {
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl> source = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl>(DockerBundle.message((String)"DockerVolumeBindingsField.VolumeBindingsTable.source", (Object[])new Object[0]), DockerVolumeBindingImpl::getHostPath, DockerVolumeBindingImpl::setHostPath){

                @Nullable
                public TableCellEditor getEditor(DockerVolumeBindingImpl item) {
                    return new LocalPathCellEditorEx().fileChooserDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
                }

                @Nullable
                public String getPreferredStringValue() {
                    return DockerVolumeBindingsField.this.mySampleHostPath;
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl> destination = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl>(this, DockerBundle.message((String)"DockerVolumeBindingsField.VolumeBindingsTable.destination", (Object[])new Object[0]), DockerVolumeBindingImpl::getContainerPath, DockerVolumeBindingImpl::setContainerPath){

                public String getMaxStringValue() {
                    return "/some/reasonably/long/container/path";
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.BooleanColumnBase<DockerVolumeBindingImpl> readOnly = new DockerBindingsFieldBase.BindingsTableBase.BooleanColumnBase<DockerVolumeBindingImpl>(DockerBundle.message((String)"DockerVolumeBindingsField.VolumeBindingsTable.readOnly", (Object[])new Object[0]), DockerVolumeBindingImpl::isReadOnly, DockerVolumeBindingImpl::setReadOnly);
            return new ListTableModel(new ColumnInfo[]{source, destination, readOnly});
        }

        protected DockerVolumeBindingImpl createElement() {
            return new DockerVolumeBindingImpl();
        }

        protected boolean isEmpty(DockerVolumeBindingImpl element) {
            return this.EMPTY.equals((Object)element);
        }

        protected DockerVolumeBindingImpl cloneElement(DockerVolumeBindingImpl variable) {
            return new DockerVolumeBindingImpl((DockerVolumeBinding)variable);
        }

        protected boolean canDeleteElement(DockerVolumeBindingImpl selection) {
            return true;
        }
    }

    private class LocalPathCellEditorEx
    extends LocalPathCellEditor {
        private LocalPathCellEditorEx() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
            this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new DockerHostPathField(this.createActionListener(table), DockerVolumeBindingsField.this.myProject), (TableCellEditor)((Object)this));
            ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
            this.myComponent.requestFocus();
            return this.myComponent;
        }
    }
}

