/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins.utils;

import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.initializr.KtorGeneratorWebAPI;
import com.intellij.ktor.initializr.info.KtorModuleInfo;
import com.intellij.ktor.initializr.json.SelectedProjectConfiguration;
import com.intellij.ktor.initializr.plugins.utils.KtorProjectGeneratorUtilsKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"generateKtorProject", "", "component", "Ljava/awt/Component;", "moduleInfo", "Lcom/intellij/ktor/initializr/info/KtorModuleInfo;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "generateKtorProjectOrFail", "intellij.ktor"})
public final class KtorProjectGeneratorUtilsKt {
    public static final boolean generateKtorProject(@NotNull Component component, @NotNull KtorModuleInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.component((Component)component);
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"component(...)");
        return (Boolean)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)KtorStarterBundle.INSTANCE.message("message.state.downloading.project", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(moduleInfo, null){
            int label;
            final /* synthetic */ KtorModuleInfo $moduleInfo;
            {
                this.$moduleInfo = $moduleInfo;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$moduleInfo, null){
                            int label;
                            final /* synthetic */ KtorModuleInfo $moduleInfo;
                            {
                                this.$moduleInfo = $moduleInfo;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> generateKtorProject.1.invokeSuspend$lambda$0(this.$moduleInfo, arg_0), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final boolean invokeSuspend$lambda$0(KtorModuleInfo $moduleInfo, ProgressIndicator it) {
                                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                                Intrinsics.checkNotNull((Object)indicator);
                                return KtorProjectGeneratorUtilsKt.access$generateKtorProject($moduleInfo, indicator);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final boolean generateKtorProject(KtorModuleInfo moduleInfo, ProgressIndicator indicator) {
        boolean bl;
        try {
            bl = KtorProjectGeneratorUtilsKt.generateKtorProjectOrFail(moduleInfo, indicator);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)e.getMessage());
            String message = KtorStarterBundle.INSTANCE.message("error.with.description", objectArray);
            String string = StringUtil.shortenTextWithEllipsis((String)message, (int)1024, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            message = string;
            Messages.showErrorDialog((String)message, (String)KtorStarterBundle.INSTANCE.message("presentable.name.ktor.starter", new Object[0]));
            bl = false;
        }
        return bl;
    }

    private static final boolean generateKtorProjectOrFail(KtorModuleInfo moduleInfo, ProgressIndicator indicator) {
        SelectedProjectConfiguration selectedProjectConfiguration = moduleInfo.toProjectConfiguration();
        if (selectedProjectConfiguration == null) {
            return false;
        }
        SelectedProjectConfiguration projectConfiguration = selectedProjectConfiguration;
        Comparable<Path> comparable = moduleInfo.getOutputLocation();
        if (comparable == null || (comparable = comparable.toFile()) == null) {
            return false;
        }
        Comparable<Path> outputLocation = comparable;
        KtorGeneratorWebAPI.Companion.getInstance().postGenerateProject(projectConfiguration, (File)outputLocation, indicator);
        return true;
    }

    public static final /* synthetic */ boolean access$generateKtorProject(KtorModuleInfo moduleInfo, ProgressIndicator indicator) {
        return KtorProjectGeneratorUtilsKt.generateKtorProject(moduleInfo, indicator);
    }
}

