/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.action;

import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.liquibase.common.LiquibaseManager;
import com.intellij.liquibase.common.action.UnknownTypeResult;
import com.intellij.liquibase.common.gui.UnknownMappingTypesDialog;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ4\u0010\u0018\u001a\u00020\u00192\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$J\u0016\u0010\u001c\u001a\u00020\u00192\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/liquibase/common/action/DiffGeneratorHandler;", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;)V", "getE", "()Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbProperties", "()Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "persistenceUnitName", "", "getPersistenceUnitName", "()Ljava/lang/String;", "setPersistenceUnitName", "(Ljava/lang/String;)V", "diffDialogTitle", "getDiffDialogTitle", "showChangeLogPreviewDialog", "", "changeLogTag", "Lcom/intellij/psi/xml/XmlTag;", "diffAndShow", "changeLogGenerator", "Lkotlin/Function0;", "checkUnknownTypes", "Lcom/intellij/liquibase/common/action/UnknownTypeResult;", "intellij.liquibase.common"})
public abstract class DiffGeneratorHandler {
    @Nullable
    private final AnActionEvent e;
    @NotNull
    private final Project project;
    @NotNull
    private final DbProperties dbProperties;
    @Nullable
    private String persistenceUnitName;

    public DiffGeneratorHandler(@Nullable AnActionEvent e, @NotNull Project project, @NotNull DbProperties dbProperties) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
        this.e = e;
        this.project = project;
        this.dbProperties = dbProperties;
    }

    public /* synthetic */ DiffGeneratorHandler(AnActionEvent anActionEvent, Project project, DbProperties dbProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            anActionEvent = null;
        }
        this(anActionEvent, project, dbProperties);
    }

    @Nullable
    public final AnActionEvent getE() {
        return this.e;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbProperties getDbProperties() {
        return this.dbProperties;
    }

    @Nullable
    public final String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public final void setPersistenceUnitName(@Nullable String string) {
        this.persistenceUnitName = string;
    }

    @NotNull
    protected abstract String getDiffDialogTitle();

    protected abstract void showChangeLogPreviewDialog(@Nullable AnActionEvent var1, @NotNull Project var2, @NotNull XmlTag var3, @NotNull DbProperties var4, @Nullable String var5);

    public final void diffAndShow(@NotNull Function0<? extends XmlTag> changeLogGenerator) {
        XmlTag[] allChangeTags;
        XmlTag changeLogTag;
        Intrinsics.checkNotNullParameter(changeLogGenerator, (String)"changeLogGenerator");
        XmlTag xmlTag = changeLogTag = (XmlTag)changeLogGenerator.invoke();
        Object object = allChangeTags = xmlTag != null ? xmlTag.getSubTags() : null;
        if (allChangeTags == null || allChangeTags.length == 0) {
            Messages.showInfoMessage((Project)this.project, (String)LiquibaseResourceBundle.message("no.changes.found", new Object[0]), (String)this.getDiffDialogTitle());
            return;
        }
        UnknownTypeResult unknownTypeResult = this.checkUnknownTypes(changeLogTag);
        if (unknownTypeResult != UnknownTypeResult.NO) {
            if (unknownTypeResult == UnknownTypeResult.YES_AND_RE_GENERATE) {
                this.diffAndShow(changeLogGenerator);
            }
            return;
        }
        this.showChangeLogPreviewDialog(this.e, this.project, changeLogTag, this.dbProperties, this.persistenceUnitName);
    }

    private final UnknownTypeResult checkUnknownTypes(XmlTag changeLogTag) {
        String changeLogSource = changeLogTag.getText();
        Set<String> unknownTypes = LiquibaseManager.Companion.getInstance(this.project).findUnknownTypes(changeLogSource);
        if (unknownTypes.isEmpty()) {
            return UnknownTypeResult.NO;
        }
        Project project = changeLogTag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection collection = unknownTypes;
        DbType dbType = this.dbProperties.getType();
        Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
        UnknownMappingTypesDialog unknownMappingTypesDialog = new UnknownMappingTypesDialog(project, collection, dbType);
        if (unknownMappingTypesDialog.showAndGet()) {
            return UnknownTypeResult.YES_AND_RE_GENERATE;
        }
        return UnknownTypeResult.YES;
    }
}

