/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextElement;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextIndexedAccess;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextProperty;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextRestProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDestructuringContext {
    @NotNull
    private final List<PsiElement> myDestructuringElements;
    @Nullable
    private final JSInitializerOwner myOuterElement;

    private JSDestructuringContext(@NotNull List<PsiElement> destructuringElements, @Nullable JSInitializerOwner condition) {
        if (destructuringElements == null) {
            JSDestructuringContext.$$$reportNull$$$0(0);
        }
        this.myDestructuringElements = destructuringElements;
        this.myOuterElement = condition;
    }

    public boolean isEmpty() {
        return this.myDestructuringElements.isEmpty();
    }

    @Nullable
    public String buildFieldName() {
        StringBuilder fieldNameBuilder = new StringBuilder();
        for (int i = this.myDestructuringElements.size() - 1; i >= 0; --i) {
            PsiElement parent = this.myDestructuringElements.get(i);
            if (!(parent instanceof JSDestructuringProperty)) continue;
            if (!fieldNameBuilder.isEmpty()) {
                fieldNameBuilder.append('.');
            }
            fieldNameBuilder.append(((JSDestructuringProperty)parent).getName());
        }
        return !fieldNameBuilder.isEmpty() ? fieldNameBuilder.toString() : null;
    }

    @NotNull
    public static JSDestructuringContext findDestructuringParents(@NotNull PsiElement destructuringElement, @NotNull Predicate<? super JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            JSDestructuringContext.$$$reportNull$$$0(1);
        }
        if (parentCondition == null) {
            JSDestructuringContext.$$$reportNull$$$0(2);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement element = destructuringElement;
        PsiElement prevElement = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.test((JSInitializerOwner)element)) {
                return new JSDestructuringContext(result, (JSInitializerOwner)element);
            }
            if (element instanceof JSDestructuringArray) {
                if (!(prevElement instanceof JSDestructuringArrayRestElement)) {
                    result.add(prevElement);
                }
            } else if (element instanceof JSDestructuringProperty) {
                result.add(element);
            }
            prevElement = element;
            element = element.getParent();
        }
        return new JSDestructuringContext(result, null);
    }

    @Nullable
    public JSInitializerOwner getOuterElement() {
        return this.myOuterElement;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public JSType applyToOuterType(@Nullable JSType type) {
        if (type == null || this.myDestructuringElements.isEmpty()) {
            return type;
        }
        JSType result = (JSType)this.doApplyToType((JSType)type).first;
        return result != null ? result : JSAnyType.get(this.myDestructuringElements.get(0));
    }

    @NotNull
    public JSParameterTypeDecorator applyToOuterParameterTypeDecorator(@NotNull JSParameterTypeDecorator decorator) {
        if (decorator == null) {
            JSDestructuringContext.$$$reportNull$$$0(3);
        }
        if (this.myDestructuringElements.isEmpty()) {
            JSParameterTypeDecorator jSParameterTypeDecorator = decorator;
            if (jSParameterTypeDecorator == null) {
                JSDestructuringContext.$$$reportNull$$$0(4);
            }
            return jSParameterTypeDecorator;
        }
        JSType type = decorator.getSimpleType();
        Pair<JSType, JSRecordType.PropertySignature> result = this.doApplyToType(type);
        boolean optional = result.second != null && ((JSRecordType.PropertySignature)result.second).isOptional();
        return new JSParameterTypeDecoratorImpl((JSType)result.first, optional, false, decorator.isExplicitlyDeclared());
    }

    @Nullable
    public List<JSDestructuringContextElement> getDestructuringContextElements() {
        ArrayList<JSDestructuringContextElement> result = new ArrayList<JSDestructuringContextElement>(this.myDestructuringElements.size());
        for (int i = this.myDestructuringElements.size() - 1; i >= 0; --i) {
            PsiElement destructuringElement = this.myDestructuringElements.get(i);
            if (destructuringElement instanceof JSDestructuringProperty) {
                JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)destructuringElement;
                if (destructuringProperty.isRest()) {
                    PsiElement psiElement = destructuringProperty.getParent();
                    if (psiElement instanceof JSDestructuringObject) {
                        JSDestructuringObject objectPattern = (JSDestructuringObject)psiElement;
                        Set existingNames = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), p -> !p.isRest() ? p.getName() : null);
                        result.add(new JSDestructuringContextRestProperty(existingNames));
                        continue;
                    }
                    Logger.getInstance(JSDestructuringContext.class).error("Unexpected rest destructuring property parent " + String.valueOf(destructuringProperty.getParent()));
                    return null;
                }
                String name = destructuringProperty.getName();
                if (name == null) {
                    return null;
                }
                result.add(new JSDestructuringContextProperty(name));
                continue;
            }
            PsiElement parent = destructuringElement.getParent();
            if (!(parent instanceof JSDestructuringArray)) {
                Logger.getInstance(JSDestructuringContext.class).error("Unexpected destructuring element parent " + (parent == null ? null : parent.getClass().getSimpleName()));
                return null;
            }
            JSDestructuringArray destructuringArray = (JSDestructuringArray)parent;
            int childIndex = ArrayUtil.indexOf((Object[])destructuringArray.getElementsWithRest(), (Object)destructuringElement);
            if (childIndex == -1) {
                Logger.getInstance(JSDestructuringContext.class).error("Can't find destructuring array child");
                return null;
            }
            result.add(new JSDestructuringContextIndexedAccess(childIndex));
        }
        return result;
    }

    private @NotNull Pair<@Nullable JSType, @Nullable JSRecordType.PropertySignature> doApplyToType(@Nullable JSType type) {
        List<JSDestructuringContextElement> destructuringContextElements = this.getDestructuringContextElements();
        if (destructuringContextElements == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                JSDestructuringContext.$$$reportNull$$$0(5);
            }
            return pair;
        }
        int size = destructuringContextElements.size();
        if (size != this.myDestructuringElements.size()) {
            Pair pair = Pair.empty();
            if (pair == null) {
                JSDestructuringContext.$$$reportNull$$$0(6);
            }
            return pair;
        }
        for (int i = 0; i < size; ++i) {
            if (type == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    JSDestructuringContext.$$$reportNull$$$0(7);
                }
                return pair;
            }
            JSDestructuringContextElement destructuringContextElement = destructuringContextElements.get(i);
            if (destructuringContextElement instanceof JSDestructuringContextRestProperty) {
                JSDestructuringContextRestProperty destructuringContextRestProperty = (JSDestructuringContextRestProperty)destructuringContextElement;
                type = JSDestructuringContext.createRestPropertyType(type, this.myDestructuringElements.get(size - i - 1), destructuringContextRestProperty.getExcludedNames());
                continue;
            }
            if (destructuringContextElement instanceof JSDestructuringContextProperty) {
                JSRecordType.PropertySignature signature;
                JSDestructuringContextProperty destructuringContextProperty = (JSDestructuringContextProperty)destructuringContextElement;
                String name = destructuringContextProperty.getName();
                if (type instanceof JSRecordType && (signature = ((JSRecordType)type).findPropertySignature(name)) != null) {
                    type = signature.getJSType();
                    if (i != size - 1) continue;
                    Pair pair = Pair.create((Object)type, (Object)signature);
                    if (pair == null) {
                        JSDestructuringContext.$$$reportNull$$$0(8);
                    }
                    return pair;
                }
                if (type instanceof JSRecordType && !((JSRecordType)type).hasIndexers()) {
                    type = null;
                    continue;
                }
                type = new JSQualifiedReferenceType(name, type, type.getSource());
                continue;
            }
            if (!(destructuringContextElement instanceof JSDestructuringContextIndexedAccess)) continue;
            JSDestructuringContextIndexedAccess destructuringContextIndexedAccess = (JSDestructuringContextIndexedAccess)destructuringContextElement;
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myDestructuringElements.get(size - i - 1), true);
            type = new JSNumericIndexerAccessType(destructuringContextIndexedAccess.getIndex(), type, typeSource);
        }
        Pair pair = Pair.create((Object)type, null);
        if (pair == null) {
            JSDestructuringContext.$$$reportNull$$$0(9);
        }
        return pair;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static JSType createRestPropertyType(@NotNull JSType _type, @NotNull PsiElement property, @NotNull Set<String> existingNames) {
        if (_type == null) {
            JSDestructuringContext.$$$reportNull$$$0(10);
        }
        if (property == null) {
            JSDestructuringContext.$$$reportNull$$$0(11);
        }
        if (existingNames == null) {
            JSDestructuringContext.$$$reportNull$$$0(12);
        }
        JSTypeSource jsTypeSource = JSTypeSourceFactory.copyTypeSource(_type.getSource(), property);
        if (_type instanceof JSRecordType) {
            List typeMembers = ContainerUtil.filter(((JSRecordType)_type).getTypeMembers(), p -> p instanceof JSRecordType.PropertySignature && !existingNames.contains(((JSRecordType.PropertySignature)p).getMemberName()));
            return new JSRecordTypeImpl(jsTypeSource, typeMembers);
        }
        @NotNull List members = ContainerUtil.mapNotNull(existingNames, name -> name != null ? new PropertySignatureImpl((String)name, null, false, false) : null);
        @NotNull List types = ContainerUtil.mapNotNull((Collection)members, PropertySignatureCommonImpl::getKeyType);
        JSType existingPropsType = JSCompositeTypeFactory.createUnionType(jsTypeSource, types);
        JSType excludeNamedType = JSNamedTypeFactory.createType("Omit", jsTypeSource, JSTypeContext.INSTANCE);
        return new JSGenericTypeImpl(jsTypeSource, excludeNamedType, Arrays.asList(_type, existingPropsType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSDestructuringContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToOuterParameterTypeDecorator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doApplyToType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyToOuterParameterTypeDecorator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRestPropertyType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

