/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"SWAGGER_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "createTextEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "rememberItIsSwaggerEditor", "", "fileEditor", "isSwaggerEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.swagger.core"})
public final class SwaggerUIEditorProviderKt {
    @NotNull
    private static final Key<Boolean> SWAGGER_EDITOR_KEY;

    private static final FileEditor createTextEditor(Project project, VirtualFile file) {
        FileEditor editor = TextEditorProvider.Companion.getInstance().createEditor(project, file);
        SwaggerUIEditorProviderKt.rememberItIsSwaggerEditor(editor);
        return editor;
    }

    private static final void rememberItIsSwaggerEditor(FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            ((TextEditor)fileEditor).getEditor().putUserData(SWAGGER_EDITOR_KEY, (Object)true);
        } else {
            fileEditor.putUserData(SWAGGER_EDITOR_KEY, (Object)true);
        }
    }

    public static final boolean isSwaggerEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Boolean bl = (Boolean)editor.getUserData(SWAGGER_EDITOR_KEY);
        return bl != null ? bl : false;
    }

    public static final /* synthetic */ FileEditor access$createTextEditor(Project project, VirtualFile file) {
        return SwaggerUIEditorProviderKt.createTextEditor(project, file);
    }

    static {
        Key key = Key.create((String)"SwaggerSplitEditor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SWAGGER_EDITOR_KEY = key;
    }
}

