/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.NativeAccessibleFocusHelper;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingRedrawer;
import org.jetbrains.skiko.swing.SwingRedrawerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002\u0017\u001a\b\u0017\u0018\u0000 72\u00020\u0001:\u00017B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u0012\u0010)\u001a\u00020'2\b\b\u0002\u0010*\u001a\u00020\u000fH\u0002J\u0006\u0010+\u001a\u00020'J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020'2\b\u00106\u001a\u0004\u0018\u00010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b1\u00102\u00a8\u00068"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JPanel;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "<init>", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "isInitialized", "", "isDisposed", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "renderDelegateWithClipping", "org/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "swingLayerProperties", "org/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawer", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "removeNotify", "", "addNotify", "init", "recreation", "dispose", "paint", "g", "Ljava/awt/Graphics;", "nativeAccessibleFocusHelper", "Lorg/jetbrains/skiko/NativeAccessibleFocusHelper;", "getNativeAccessibleFocusHelper$annotations", "()V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "requestNativeFocusOnAccessible", "accessible", "Companion", "skiko"})
@ExperimentalSkikoApi
@SourceDebugExtension(value={"SMAP\nSkiaSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n127#2,4:144\n127#2,4:148\n168#2,4:153\n1#3:152\n*S KotlinDebug\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n*L\n90#1:144,4\n96#1:148,4\n122#1:153,4\n*E\n"})
public class SkiaSwingLayer
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    @NotNull
    private final renderDelegateWithClipping.1 renderDelegateWithClipping;
    @NotNull
    private final swingLayerProperties.1 swingLayerProperties;
    @NotNull
    private final RedrawerManager<SwingRedrawer> redrawerManager;
    @NotNull
    private final NativeAccessibleFocusHelper nativeAccessibleFocusHelper;

    public SkiaSwingLayer(@NotNull SkikoRenderDelegate renderDelegate, @NotNull SkiaLayerAnalytics analytics, @Nullable Function1<? super Component, ? extends Accessible> externalAccessibleFactory, @NotNull SkiaLayerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.renderDelegateWithClipping = new SkikoRenderDelegate(renderDelegate, this){
            private final /* synthetic */ SkikoRenderDelegate $$delegate_0;
            final /* synthetic */ SkikoRenderDelegate $renderDelegate;
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.$renderDelegate = $renderDelegate;
                this.this$0 = $receiver;
                this.$$delegate_0 = $renderDelegate;
            }

            public void onRender(Canvas canvas, int width, int height, long nanoTime) {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                float scale = (float)this.this$0.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                for (ClipRectangle component : this.this$0.getClipComponents()) {
                    SkiaLayer_awtKt.clipRectBy(canvas, component, scale);
                }
                this.$renderDelegate.onRender(canvas, width, height, nanoTime);
            }
        };
        this.swingLayerProperties = new SwingLayerProperties(this){
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public int getWidth() {
                return this.this$0.getWidth();
            }

            public int getHeight() {
                return this.this$0.getHeight();
            }

            public GraphicsConfiguration getGraphicsConfiguration() {
                GraphicsConfiguration graphicsConfiguration = this.this$0.getGraphicsConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
                return graphicsConfiguration;
            }

            public GpuPriority getAdapterPriority() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getAdapterPriority();
            }

            public long getGpuResourceCacheLimit() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getGpuResourceCacheLimit();
            }
        };
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (arg_0, arg_1) -> SkiaSwingLayer.redrawerManager$lambda$0(this, analytics, arg_0, arg_1), null, 4, null);
        this.setOpaque(false);
        this.setLayout(null);
        Function1<? super Component, ? extends Accessible> function1 = externalAccessibleFactory;
        this.nativeAccessibleFocusHelper = new NativeAccessibleFocusHelper(this, function1 != null ? (Accessible)function1.invoke((Object)this) : null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, Function1 function1, SkiaLayerProperties skiaLayerProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            skiaLayerProperties = new SkiaLayerProperties(false, false, null, null, null, 0L, 63, null);
        }
        this(skikoRenderDelegate, skiaLayerAnalytics, (Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties);
    }

    @NotNull
    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        this.init(this.isInitialized);
    }

    private final void init(boolean recreation) {
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi(recreation);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            try {
                SwingRedrawer swingRedrawer = this.getRedrawer();
                if (swingRedrawer != null) {
                    swingRedrawer.redraw((Graphics2D)g);
                }
            }
            catch (RenderException e) {
                if (this.isDisposed) break block4;
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$warn = false;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = e;
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
        }
    }

    private static /* synthetic */ void getNativeAccessibleFocusHelper$annotations() {
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = this.nativeAccessibleFocusHelper.getAccessibleContext();
        if (accessibleContext == null) {
            accessibleContext = super.getAccessibleContext();
        }
        return accessibleContext;
    }

    public final void requestNativeFocusOnAccessible(@Nullable Accessible accessible) {
        this.nativeAccessibleFocusHelper.requestNativeFocusOnAccessible(accessible);
    }

    private static final SwingRedrawer redrawerManager$lambda$0(SkiaSwingLayer this$0, SkiaLayerAnalytics $analytics, GraphicsApi renderApi, SwingRedrawer oldRedrawer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$analytics, (String)"$analytics");
            Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
            SwingRedrawer swingRedrawer = oldRedrawer;
            if (swingRedrawer == null) break block0;
            swingRedrawer.dispose();
        }
        return SwingRedrawerKt.createSwingRedrawer(this$0.swingLayerProperties, this$0.renderDelegateWithClipping, renderApi, $analytics);
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer $this) {
        return $this.properties;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer$Companion;", "", "<init>", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

