/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.graphql.request;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.executor.graphql.GraphQLClientRequestExecutionSupport;
import com.intellij.httpClient.executor.graphql.request.GraphQLClientRequest;
import com.intellij.httpClient.executor.graphql.request.GraphQLPresentationKt;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\n8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0014\u0010\u0018\u001a\u0004\u0018\u00010\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/executor/graphql/request/GraphQLRestClientRequest;", "Lcom/intellij/httpClient/executor/graphql/request/GraphQLClientRequest;", "Lcom/intellij/httpClient/execution/common/CommonClientRequest;", "delegate", "Lcom/intellij/httpClient/execution/RestClientRequest;", "<init>", "(Lcom/intellij/httpClient/execution/RestClientRequest;)V", "getDelegate", "()Lcom/intellij/httpClient/execution/RestClientRequest;", "httpMethod", "", "getHttpMethod", "()Ljava/lang/String;", "URL", "getURL", "isLogResponse", "", "()Z", "outputFilePath", "Lcom/intellij/httpClient/execution/common/CommonClientRequest$OutputFilePath;", "getOutputFilePath", "()Lcom/intellij/httpClient/execution/common/CommonClientRequest$OutputFilePath;", "scheme", "getScheme", "textToSend", "getTextToSend", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nGraphQLRestClientRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLRestClientRequest.kt\ncom/intellij/httpClient/executor/graphql/request/GraphQLRestClientRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n13#2:60\n295#3,2:61\n*S KotlinDebug\n*F\n+ 1 GraphQLRestClientRequest.kt\ncom/intellij/httpClient/executor/graphql/request/GraphQLRestClientRequest\n*L\n27#1:60\n50#1:61,2\n*E\n"})
public final class GraphQLRestClientRequest
implements GraphQLClientRequest,
CommonClientRequest {
    @NotNull
    private final RestClientRequest delegate;

    public GraphQLRestClientRequest(@NotNull RestClientRequest delegate2) throws HttpRequestValidationException {
        Object v7;
        block10: {
            String newText;
            String originalTextToSend;
            Object object;
            block13: {
                block11: {
                    block12: {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
                        this.delegate = delegate2;
                        if (!this.delegate.haveFileToSend) break block11;
                        List<File> list2 = this.delegate.getFiles();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFiles(...)");
                        object = (File)CollectionsKt.firstOrNull(list2);
                        if (object == null) break block12;
                        Object file = object;
                        boolean bl = false;
                        try {
                            string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
                        }
                        catch (Exception e) {
                            boolean $i$f$logger22 = false;
                            Logger logger = Logger.getInstance(GraphQLClientRequestExecutionSupport.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn((Throwable)e);
                            Object[] $i$f$logger22 = new Object[]{file};
                            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.file.path.is.invalid.fallback", $i$f$logger22));
                        }
                        String string2 = string;
                        object = string2;
                        if (string2 != null) break block13;
                    }
                    object = "";
                    break block13;
                }
                if (this.delegate.haveTextToSend) {
                    String string = this.delegate.textToSend;
                    Intrinsics.checkNotNull((Object)string);
                    object = string;
                } else {
                    object = "";
                }
            }
            if (((CharSequence)(originalTextToSend = object)).length() == 0) {
                throw new HttpRequestValidationException(HttpClientExecutorBundle.message("http.client.graphql.empty.body.error", new Object[0]));
            }
            this.delegate.haveFileToSend = false;
            this.delegate.haveTextToSend = true;
            this.delegate.textToSend = newText = GraphQLPresentationKt.toGraphQLJson(originalTextToSend);
            List<RestClientRequest.KeyValuePair> list3 = this.delegate.headers;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"headers");
            Iterable $this$firstOrNull$iv = list3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RestClientRequest.KeyValuePair it = (RestClientRequest.KeyValuePair)element$iv;
                boolean bl = false;
                String string = it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string3, (Object)"content-type")) continue;
                v7 = element$iv;
                break block10;
            }
            v7 = null;
        }
        RestClientRequest.KeyValuePair contentType = v7;
        if (contentType != null) {
            contentType.setValue("application/json");
        } else {
            this.delegate.headers.add(new RestClientRequest.KeyValuePair("Content-Type", "application/json"));
        }
        this.delegate.httpMethod = "POST";
    }

    @NotNull
    public final RestClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public String getHttpMethod() {
        return "GRAPHQL";
    }

    @Override
    @Nullable
    public String getURL() {
        return this.delegate.getURL();
    }

    @Override
    @Nullable
    public String getTextToSend() {
        return this.delegate.getTextToSend();
    }

    @Override
    @Nullable
    public CommonClientRequest.OutputFilePath getOutputFilePath() {
        return this.delegate.getOutputFilePath();
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.delegate.getScheme();
    }

    @Override
    public boolean isLogResponse() {
        return this.delegate.isLogResponse();
    }
}

