/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.mvc.SpringMvcRequestAttributeAnnotationProvider;
import com.intellij.spring.mvc.SpringMvcSessionAttributeAnnotationProvider;
import com.intellij.spring.mvc.SpringMvcSessionAttributesAnnotationProvider;
import com.intellij.spring.mvc.SpringMvcVariablesReferenceContributorKt;
import com.intellij.spring.mvc.model.CachingVariableProvider;
import com.intellij.spring.mvc.model.SpringMvcVariablesService;
import com.intellij.spring.mvc.model.VariableProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcVariablesServiceImpl;", "Lcom/intellij/spring/mvc/model/SpringMvcVariablesService;", "<init>", "()V", "applicationVariablesProvider", "Lcom/intellij/spring/mvc/model/CachingVariableProvider;", "getApplicationVariables", "", "Lcom/intellij/psi/PsiVariable;", "project", "Lcom/intellij/openapi/project/Project;", "sessionVariablesProvider", "getSessionVariables", "requestVariablesProvider", "getRequestVariables", "intellij.spring.mvc.impl"})
public final class SpringMvcVariablesServiceImpl
implements SpringMvcVariablesService {
    @NotNull
    private final CachingVariableProvider applicationVariablesProvider;
    @NotNull
    private final CachingVariableProvider sessionVariablesProvider;
    @NotNull
    private final CachingVariableProvider requestVariablesProvider;

    public SpringMvcVariablesServiceImpl() {
        VariableProvider[] variableProviderArray = new VariableProvider[]{SpringMvcVariablesReferenceContributorKt.getSpringMvcServletJavaxContextAttributesProvider(), SpringMvcVariablesReferenceContributorKt.getSpringMvcServletJakartaContextAttributesProvider()};
        this.applicationVariablesProvider = new CachingVariableProvider(variableProviderArray);
        variableProviderArray = new VariableProvider[]{SpringMvcVariablesReferenceContributorKt.getSpringMvcJavaxSessionAttributesProvider(), SpringMvcVariablesReferenceContributorKt.getSpringMvcJakartaSessionAttributesProvider(), SpringMvcSessionAttributesAnnotationProvider.INSTANCE, SpringMvcSessionAttributeAnnotationProvider.INSTANCE};
        this.sessionVariablesProvider = new CachingVariableProvider(variableProviderArray);
        variableProviderArray = new VariableProvider[]{SpringMvcVariablesReferenceContributorKt.getSpringMvcJavaxRequestAttributesProvider(), SpringMvcVariablesReferenceContributorKt.getSpringMvcJakartaRequestAttributesProvider(), SpringMvcRequestAttributeAnnotationProvider.INSTANCE};
        this.requestVariablesProvider = new CachingVariableProvider(variableProviderArray);
    }

    @Override
    @NotNull
    public Iterable<PsiVariable> getApplicationVariables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.applicationVariablesProvider.getVariables(project);
    }

    @Override
    @NotNull
    public Iterable<PsiVariable> getSessionVariables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.sessionVariablesProvider.getVariables(project);
    }

    @Override
    @NotNull
    public Iterable<PsiVariable> getRequestVariables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.requestVariablesProvider.getVariables(project);
    }
}

