/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.actions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.resolve.directive.SchemaComment;
import com.intellij.protobuf.lang.resolve.directive.SchemaDirective;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class InsertSchemaDirectiveAction
extends AnAction {
    public static final String ACTION_ID = "prototext.InsertSchemaDirective";

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            InsertSchemaDirectiveAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (!(file instanceof PbTextFile)) {
            return;
        }
        PbTextFile textFile = (PbTextFile)file;
        if (!textFile.isWritable()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)event.getPresentation().getText(), null, () -> InsertSchemaDirectiveAction.insertFileAnnotation(project, textFile, editor), (PsiFile[])new PsiFile[0]);
    }

    public void update(AnActionEvent event) {
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (!(file instanceof PbTextFile)) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PbTextFile textFile = (PbTextFile)file;
        if (!textFile.isWritable()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        event.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            InsertSchemaDirectiveAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static void insertFileAnnotation(Project project, PbTextFile file, Editor editor) {
        PsiElement firstChild;
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        SchemaDirective directive = SchemaDirective.find((PsiFile)file);
        String existingFilename = null;
        String existingMessageName = null;
        TreeSet<String> existingImportNames = new TreeSet<String>();
        if (directive != null) {
            existingFilename = directive.getFilename();
            existingMessageName = directive.getMessageName();
            InsertSchemaDirectiveAction.removeComment(directive.getFileComment());
            InsertSchemaDirectiveAction.removeComment(directive.getMessageComment());
            for (SchemaComment importComment : directive.getImportComments()) {
                String name = importComment.getName();
                if (name != null) {
                    existingImportNames.add(name);
                }
                InsertSchemaDirectiveAction.removeComment(importComment);
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        boolean existingCommentAtTop = (firstChild = file.getFirstChild()) instanceof PsiComment && firstChild.getTextOffset() == 0;
        Template template = InsertSchemaDirectiveAction.createFileAnnotationTemplate(file.getProject(), existingFilename, existingMessageName, existingImportNames, existingCommentAtTop);
        editor.getCaretModel().moveToOffset(0);
        TemplateManager.getInstance((Project)file.getProject()).startTemplate(editor, template);
    }

    private static void removeComment(SchemaComment comment) {
        if (comment == null) {
            return;
        }
        PsiComment element = comment.getComment();
        element.delete();
    }

    private static Template createFileAnnotationTemplate(Project project, String filename, String messageName, Collection<String> importNames, boolean existingCommentAtTop) {
        StringBuilder templateBuilder = new StringBuilder();
        templateBuilder.append("# proto-file: ").append("$FILE$").append('\n');
        templateBuilder.append("# proto-message: ").append("$MESSAGE$").append('\n');
        for (String importName : importNames) {
            templateBuilder.append("# proto-import: ").append(importName).append('\n');
        }
        if (existingCommentAtTop) {
            templateBuilder.append("#\n");
        } else {
            templateBuilder.append('\n');
        }
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", templateBuilder.toString());
        template.addVariable("FILE", "complete()", "\"" + StringUtil.notNullize((String)filename) + "\"", StringUtil.isEmptyOrSpaces((String)filename));
        template.addVariable("MESSAGE", "complete()", "\"" + StringUtil.notNullize((String)messageName) + "\"", StringUtil.isEmptyOrSpaces((String)messageName));
        return template;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/actions/InsertSchemaDirectiveAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/actions/InsertSchemaDirectiveAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

