/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.ExtraRangesProvider;
import com.intellij.psi.formatter.common.NodeIndentRangesCalculator;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeafBlock
implements ASTBlock,
ExtraRangesProvider {
    private int myStartOffset = -1;
    private final ASTNode myNode;
    private final Wrap myWrap;
    private final Alignment myAlignment;
    private static final ArrayList<Block> EMPTY_SUB_BLOCKS = new ArrayList();
    private final Indent myIndent;

    public LeafBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent) {
        this.myNode = node;
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myIndent = indent;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myStartOffset != -1) {
            return new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
        }
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            LeafBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        ArrayList<Block> arrayList = EMPTY_SUB_BLOCKS;
        if (arrayList == null) {
            LeafBlock.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            LeafBlock.$$$reportNull$$$0(2);
        }
        return null;
    }

    public ASTNode getTreeNode() {
        return this.myNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getIndent(), null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return ShiftIndentInsideHelper.mayShiftIndentInside(this.myNode);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }

    @Nullable
    public List<TextRange> getExtraRangesToFormat(@NotNull FormattingRangesInfo info) {
        int startOffset;
        if (info == null) {
            LeafBlock.$$$reportNull$$$0(3);
        }
        if (info.isOnInsertedLine(startOffset = this.getTextRange().getStartOffset()) && this.myNode.getTextLength() == 1 && this.myNode.textContains('}')) {
            ASTNode parent = this.myNode.getTreeParent();
            return new NodeIndentRangesCalculator(parent).calculateExtraRanges();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/LeafBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/LeafBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExtraRangesToFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

