/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.orm.ep;

import com.intellij.jpa.jpb.model.backend.persistenceunit.PersistenceUnitLoader;
import com.intellij.jpa.jpb.model.config.PersistenceUnit;
import com.intellij.jpa.jpb.model.config.PersistenceUnitConfig;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.model.CustomOrmUnit;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmModifiableUnit;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.orm.pu.OrmUnitSettingsDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/jpa/jpb/model/orm/ep/OrmModifiableUnitsProvider;", "Lcom/intellij/jpa/jpb/model/orm/ep/OrmUnitsProvider;", "<init>", "()V", "customUnitNamePrefix", "", "getUnits", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "isUnitsModifiable", "", "createUnit", "Lcom/intellij/jpa/jpb/model/orm/model/OrmModifiableUnit;", "modifyUnit", "", "unit", "focusedComponent", "Lcom/intellij/jpa/jpb/model/orm/pu/OrmUnitSettingsDialog$FOCUSED_COMPONENT;", "callback", "Lkotlin/Function0;", "", "canDeleteUnit", "ormUnit", "deleteUnit", "getDetectedUnits", "canCreateEntity", "psiClass", "Lcom/intellij/psi/PsiClass;", "createEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "getCustomUnits", "findUnitSettings", "Lcom/intellij/jpa/jpb/model/config/PersistenceUnit;", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nOrmModifiableUnitsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmModifiableUnitsProvider.kt\ncom/intellij/jpa/jpb/model/orm/ep/OrmModifiableUnitsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n1563#2:106\n1634#2,3:107\n295#2,2:110\n*S KotlinDebug\n*F\n+ 1 OrmModifiableUnitsProvider.kt\ncom/intellij/jpa/jpb/model/orm/ep/OrmModifiableUnitsProvider\n*L\n92#1:103\n92#1:104,2\n93#1:106\n93#1:107,3\n97#1:110,2\n*E\n"})
public abstract class OrmModifiableUnitsProvider
implements OrmUnitsProvider {
    @NotNull
    private final String customUnitNamePrefix;

    public OrmModifiableUnitsProvider() {
        this.customUnitNamePrefix = "custom_pu_";
    }

    @Override
    @NotNull
    public List<OrmUnit> getUnits(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<OrmModifiableUnit> customUnits = this.getCustomUnits(project);
        if (customUnits.isEmpty()) {
            return this.getDetectedUnits(project);
        }
        return CollectionsKt.plus((Collection)this.getDetectedUnits(project), (Iterable)customUnits);
    }

    @Override
    @NotNull
    public List<OrmUnit> getUnits(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<OrmModifiableUnit> customUnits = this.getCustomUnits(project);
        if (customUnits.isEmpty()) {
            return this.getDetectedUnits(module);
        }
        return CollectionsKt.plus((Collection)this.getDetectedUnits(module), (Iterable)customUnits);
    }

    public boolean isUnitsModifiable() {
        return true;
    }

    @Nullable
    public OrmModifiableUnit createUnit(@NotNull Project project) {
        PersistenceUnit persistenceUnit;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PersistenceUnit $this$createUnit_u24lambda_u240 = persistenceUnit = new PersistenceUnit();
        boolean bl = false;
        $this$createUnit_u24lambda_u240.setName("NewUnit");
        $this$createUnit_u24lambda_u240.setOrmFrameworkName(this.getFramework().getName());
        $this$createUnit_u24lambda_u240.setOrmUnitName(this.customUnitNamePrefix + System.currentTimeMillis());
        PersistenceUnit persistenceUnit2 = persistenceUnit;
        CustomOrmUnit ormUnit = new CustomOrmUnit(project, persistenceUnit2);
        OrmUnitSettingsDialog dialog = new OrmUnitSettingsDialog(project, ormUnit, persistenceUnit2, true, null, 16, null);
        if (dialog.showAndGet()) {
            PersistenceUnitConfig.Companion.getInstance(project).getPersistenceUnits().add(persistenceUnit2);
            PersistenceUnitLoader.Companion.getInstance(project).notifyPersistenceUnitsChanged(CollectionsKt.listOf((Object)persistenceUnit2));
            return ormUnit;
        }
        return null;
    }

    public void modifyUnit(@NotNull OrmModifiableUnit unit, @Nullable OrmUnitSettingsDialog.FOCUSED_COMPONENT focusedComponent, @NotNull Function0<? extends Object> callback) {
        OrmUnitSettingsDialog dialog;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        PersistenceUnit persistenceUnit = this.findUnitSettings(unit);
        boolean isNew = persistenceUnit == null;
        PersistenceUnit persistenceUnit2 = persistenceUnit;
        if (persistenceUnit2 == null) {
            persistenceUnit2 = persistenceUnit = unit.createUnitSettings$intellij_javaee_jpa_jpb_model();
        }
        if ((dialog = new OrmUnitSettingsDialog(unit.getProject(), unit, persistenceUnit, false, focusedComponent)).showAndGet() && isNew) {
            PersistenceUnitConfig.Companion.getInstance(unit.getProject()).getPersistenceUnits().add(persistenceUnit);
        }
        PersistenceUnitLoader.Companion.getInstance(unit.getProject()).notifyPersistenceUnitsChanged(CollectionsKt.listOf((Object)persistenceUnit));
        callback.invoke();
    }

    public static /* synthetic */ void modifyUnit$default(OrmModifiableUnitsProvider ormModifiableUnitsProvider, OrmModifiableUnit ormModifiableUnit, OrmUnitSettingsDialog.FOCUSED_COMPONENT fOCUSED_COMPONENT, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: modifyUnit");
        }
        if ((n & 2) != 0) {
            fOCUSED_COMPONENT = null;
        }
        ormModifiableUnitsProvider.modifyUnit(ormModifiableUnit, fOCUSED_COMPONENT, (Function0<? extends Object>)function0);
    }

    public boolean canDeleteUnit(@NotNull OrmUnit ormUnit) {
        Intrinsics.checkNotNullParameter((Object)ormUnit, (String)"ormUnit");
        return ormUnit instanceof CustomOrmUnit;
    }

    public void deleteUnit(@NotNull OrmUnit ormUnit) {
        Intrinsics.checkNotNullParameter((Object)ormUnit, (String)"ormUnit");
        CustomOrmUnit customOrmUnit = ormUnit instanceof CustomOrmUnit ? (CustomOrmUnit)ormUnit : null;
        if (customOrmUnit == null || (customOrmUnit = customOrmUnit.getProject()) == null) {
            return;
        }
        CustomOrmUnit project = customOrmUnit;
        boolean deleted = PersistenceUnitConfig.Companion.getInstance((Project)project).getPersistenceUnits().removeIf(arg_0 -> OrmModifiableUnitsProvider.deleteUnit$lambda$1(arg_0 -> OrmModifiableUnitsProvider.deleteUnit$lambda$0(ormUnit, arg_0), arg_0));
        if (deleted) {
            PersistenceUnitLoader.Companion.getInstance((Project)project).notifyPersistenceUnitsChanged(CollectionsKt.emptyList());
        }
    }

    @NotNull
    public abstract List<OrmUnit> getDetectedUnits(@NotNull Project var1);

    @NotNull
    public abstract List<OrmUnit> getDetectedUnits(@NotNull Module var1);

    public abstract boolean canCreateEntity(@NotNull PsiClass var1);

    @Nullable
    public abstract OrmEntity createEntity(@NotNull PsiClass var1);

    /*
     * WARNING - void declaration
     */
    private final List<OrmModifiableUnit> getCustomUnits(Project project) {
        void $this$mapTo$iv$iv;
        PersistenceUnit it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PersistenceUnitConfig.Companion.getInstance(project).getPersistenceUnits();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PersistenceUnit)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getOrmFrameworkName(), (Object)this.getFramework().getName()) && it.getModuleName() == null && StringsKt.startsWith$default((String)it.getOrmUnitName(), (String)this.customUnitNamePrefix, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PersistenceUnit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CustomOrmUnit(project, it));
        }
        return (List)destination$iv$iv;
    }

    private final PersistenceUnit findUnitSettings(OrmModifiableUnit ormUnit) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = PersistenceUnitConfig.Companion.getInstance(ormUnit.getProject()).getPersistenceUnits();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PersistenceUnit it = (PersistenceUnit)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getOrmFrameworkName(), (Object)ormUnit.getOrmFramework().getName()) && Intrinsics.areEqual((Object)it.getOrmUnitName(), (Object)ormUnit.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean deleteUnit$lambda$0(OrmUnit $ormUnit, PersistenceUnit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOrmFrameworkName(), (Object)((CustomOrmUnit)$ormUnit).getOrmFramework().getName()) && Intrinsics.areEqual((Object)it.getOrmUnitName(), (Object)((CustomOrmUnit)$ormUnit).getName());
    }

    private static final boolean deleteUnit$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

