/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.model;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.model.dbtype.Db2Type;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.H2Type;
import com.intellij.jpa.jpb.model.core.model.dbtype.HsqlFileType;
import com.intellij.jpa.jpb.model.core.model.dbtype.HsqlInMemoryType;
import com.intellij.jpa.jpb.model.core.model.dbtype.HsqlType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MariaType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MongoDbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MongoSrvDbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.core.model.dbtype.OracleType;
import com.intellij.jpa.jpb.model.core.model.dbtype.PostgresType;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class DbTypeIcon {
    @Contract(value="null -> null", pure=true)
    @Nullable
    public static Icon getDbTypeIcon(@Nullable DbType dbType) {
        if (dbType == null) {
            return null;
        }
        if (dbType instanceof HsqlType || dbType instanceof HsqlInMemoryType || dbType instanceof HsqlFileType) {
            return AllIcons.Providers.Hsqldb;
        }
        if (dbType instanceof PostgresType) {
            return AllIcons.Providers.Postgresql;
        }
        if (dbType.isMssql()) {
            return AllIcons.Providers.Microsoft;
        }
        if (dbType instanceof OracleType) {
            return AllIcons.Providers.Oracle;
        }
        if (dbType instanceof MysqlType) {
            return AllIcons.Providers.Mysql;
        }
        if (dbType instanceof MariaType) {
            return AllIcons.Providers.Mariadb;
        }
        if (dbType instanceof H2Type) {
            return AllIcons.Providers.H2;
        }
        if (dbType instanceof Db2Type) {
            return AllIcons.Providers.DB2;
        }
        if (dbType instanceof MongoDbType || dbType instanceof MongoSrvDbType) {
            return AllIcons.Providers.MongoDB;
        }
        return null;
    }
}

