/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryLabelOnBreakStatementJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryLabelOnBreakStatementFix fix = new UnnecessaryLabelOnBreakStatementFix();

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.label.on.break.error.string", new Object[0]);
        if (string == null) {
            UnnecessaryLabelOnBreakStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnBreakStatementJSInspection", "buildErrorString"));
    }

    private static class UnnecessaryLabelOnBreakStatementFix
    extends InspectionJSFix {
        private UnnecessaryLabelOnBreakStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.label.fix", new Object[0]);
            if (string == null) {
                UnnecessaryLabelOnBreakStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement breakKeywordElement = descriptor.getPsiElement();
            JSBreakStatement breakStatement = (JSBreakStatement)breakKeywordElement.getParent();
            UnnecessaryLabelOnBreakStatementFix.replaceStatement((JSStatement)breakStatement, "break;");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnBreakStatementJSInspection$UnnecessaryLabelOnBreakStatementFix", "getFamilyName"));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSBreakStatement(@NotNull JSBreakStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSBreakStatement(statement);
            if (statement.getLabel() == null) {
                return;
            }
            JSStatement statementToBreak = statement.getStatementToBreak();
            if (statementToBreak == null) {
                return;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{JSLoopStatement.class, JSSwitchStatement.class});
            if (containingStatement == null) {
                return;
            }
            PsiElement parent = containingStatement.getParent();
            if (!statementToBreak.equals((Object)parent)) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryLabelOnBreakStatementJSInspection$Visitor", "visitJSBreakStatement"));
        }
    }
}

