/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vec extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora de’l meridian de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ora normale de Apia",
               "",
               "Ora d’istà de Apia",
               "",
               "Ora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Ora normale de le Ìzole Cook",
               "",
               "Ora d’istà de le Ìzole Cook",
               "",
               "Ora de le Ìzole Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora normale de Cuba",
               "CST",
               "Ora d’istà de Cuba",
               "CDT",
               "Ora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Ora normale de le Ìzole Fiji",
               "",
               "Ora d’istà de le Ìzole Fiji",
               "",
               "Ora de le Ìzole Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora de’l Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora normale de Hovd",
               "",
               "Ora d’istà de Hovd",
               "",
               "Ora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ora normale de l’Iran",
               "",
               "Ora d’istà de l’Iran",
               "",
               "Ora de l’Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Ora de l’Ìzola Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora normale de Omsk",
               "",
               "Ora d’istà de Omsk",
               "",
               "Ora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ora normale de’l Perù",
               "",
               "Ora d’istà de’l Perù",
               "",
               "Ora de’l Perù",
               "",
            };
        final String[] Truk = new String[] {
               "Ora de’l Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora de l’Atolo Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora normale de’l Cile",
               "",
               "Ora d’istà de’l Cile",
               "",
               "Ora de’l Cile",
               "",
            };
        final String[] China = new String[] {
               "Ora normale de la Sina",
               "CST",
               "Ora d’istà de la Sina",
               "CDT",
               "Ora de la Sina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ora de le Ìzole Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora de l’India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ora normale de’l Japon",
               "JST",
               "Ora d’istà de’l Japon",
               "JDT",
               "Ora de’l Japon",
               "JT",
            };
        final String[] Korea = new String[] {
               "Ora normale de la Corèa",
               "KST",
               "Ora d’istà de la Corèa",
               "KST",
               "Ora de la Corèa",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ora de l’Ìzola Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora de’l Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora de le Ìzole Palàu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora normale de le Ìzole Samòa",
               "SST",
               "Ora d’istà de le Ìzole Samòa",
               "SST",
               "Ora de le Ìzole Samòa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora normale de le Ìzole Tonga",
               "",
               "Ora d’istà de le Ìzole Tonga",
               "",
               "Ora de le Ìzole Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Ora de’l Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ora normale de l’Alaska",
               "AKST",
               "Ora d’istà de l’Alaska",
               "AKDT",
               "Ora de l’Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ora normale de l’Amasonia",
               "",
               "Ora d’istà de l’Amasonia",
               "",
               "Ora de l’Amasonia",
               "",
            };
        final String[] Azores = new String[] {
               "Ora normale de le Azore",
               "",
               "Ora d’istà de le Azore",
               "",
               "Ora de le Azore",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora de’l Butan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora de’l Brunéi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora normale de l’Ìzola de Pascua",
               "",
               "Ora d’istà de l’Ìzola de Pascua",
               "",
               "Ora de l’Ìzola de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora de la Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Ora normale de Hawai e Aleutine",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Ora normale de Izraele",
               "IST",
               "Ora d’istà de Izraele",
               "IDT",
               "Ora de Izraele",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ora de l’Ìzola Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora normale de Mosca",
               "MSK",
               "Ora d’istà de Mosca",
               "MSK",
               "Ora de Mosca",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ora de l’Ìzola Ponpèi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora de l’Ìzola Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora normale de Taipéi",
               "CST",
               "Ora d’istà de Taipéi",
               "CDT",
               "Ora de Taipéi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Ora de le Ìzole Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora de le Ìzole Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora normale de l’Arabia",
               "",
               "Ora d’istà de l’Arabia",
               "",
               "Ora de l’Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora normale de l’Armenia",
               "",
               "Ora d’istà de l’Armenia",
               "",
               "Ora de l’Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora de la Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora normale de le Ìzole Ciatem",
               "",
               "Ora d’istà de le Ìzole Ciatem",
               "",
               "Ora de le Ìzole Ciatem",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ora universale coordenada",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora de l’Ècuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora de le Ìzole Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora normale de la Jeorja",
               "",
               "Ora d’istà de la Jeorja",
               "",
               "Ora de la Jeorja",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora normale de Irkutsk",
               "",
               "Ora d’istà de Irkutsk",
               "",
               "Ora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora normale de Magadan",
               "",
               "Ora d’istà de Magadan",
               "",
               "Ora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora de Myanmar (Birmania)",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora normale de l’Ìzola Norfolk",
               "",
               "Ora d’istà de l’Ìzola Norfolk",
               "",
               "Ora de l’Ìzola Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora normale de Fernando de Noronha",
               "",
               "Ora d’istà de Fernando de Noronha",
               "",
               "Ora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora de l’Ìzola Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora de le Ìzole Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora de le Ìzole Tokelàu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora normale de l’Uruguài",
               "",
               "Ora d’istà de l’Uruguài",
               "",
               "Ora de l’Uruguài",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora normale de le Ìzole Vanuatu",
               "",
               "Ora d’istà de le Ìzole Vanuatu",
               "",
               "Ora de le Ìzole Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora normale de Yakutsk",
               "",
               "Ora d’istà de Yakutsk",
               "",
               "Ora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora normale de l’Atlàntego",
               "AST",
               "Ora d’istà de l’Atlàntego",
               "AST",
               "Ora de l’Atlàntego",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Ora normale de Brazilia",
               "",
               "Ora d’istà de Brazilia",
               "",
               "Ora de Brazilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora de Chamoro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Ora normale de la Colonbia",
               "",
               "Ora d’istà de la Colonbia",
               "",
               "Ora de la Colonbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora normale de le Ìzole Malvine",
               "",
               "Ora d’istà de le Ìzole Malvine",
               "",
               "Ora de le Ìzole Malvine",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora de la Malezia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora de le Ìzole Maldive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora normale de Ulan Bàtor",
               "",
               "Ora d’istà de Ulan Bàtor",
               "",
               "Ora de Ulan Bàtor",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora normale de’l Pakistan",
               "PKT",
               "Ora d’istà de’l Pakistan",
               "PKST",
               "Ora de’l Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Ora normale de’l Paraguài",
               "",
               "Ora d’istà de’l Paraguài",
               "",
               "Ora de’l Paraguài",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora de le Ìzole Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora de’l Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora normale de l’Arjentina",
               "",
               "Ora d’istà de l’Arjentina",
               "",
               "Ora de l’Arjentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora de l’Ìzola de Nadale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora de le Galàpagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora normale de Hong Kong",
               "HKT",
               "Ora d’istà de Hong Kong",
               "HKST",
               "Ora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ora de l’Indosina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora de’l Kirghizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora normale de l’Ìzola Lord Howe",
               "",
               "Ora d’istà de l’Ìzola Lord Howe",
               "",
               "Ora de l’Ìzola Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora de le Ìzole Marchezi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora normale de le Ìzole Maurisio",
               "",
               "Ora d’istà de le Ìzole Maurisio",
               "",
               "Ora de le Ìzole Maurisio",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora de Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora de’l Venesuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ora normale de l’Azerbaijan",
               "",
               "Ora d’istà de l’Azerbaijan",
               "",
               "Ora de l’Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora normale de’l Bangladesh",
               "",
               "Ora d’istà de’l Bangladesh",
               "",
               "Ora de’l Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora normale de Cao Verdo",
               "",
               "Ora d’istà de Cao Verdo",
               "",
               "Ora de Cao Verdo",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora de’l Timor Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ora de’l Kazakistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora d’istà de le Ìzole Seisel",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora de’l Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora normale de l’Uzbekistan",
               "",
               "Ora d’istà de l’Uzbekistan",
               "",
               "Ora de l’Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora de l’Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora normale de Krasnoyarsk",
               "",
               "Ora d’istà de Krasnoyarsk",
               "",
               "Ora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora normale de la Nova Zelanda",
               "NZST",
               "Ora d’istà de la Nova Zelanda",
               "NZDT",
               "Ora de la Nova Zelanda",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Ora normale de le Ìzole Filipine",
               "PST",
               "Ora d’istà de le Ìzole Filipine",
               "PDT",
               "Ora de le Ìzole Filipine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Ora normale de Vladivostok",
               "",
               "Ora d’istà de Vladivostok",
               "",
               "Ora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora de l’Osèano Indian",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora de le Ìzole Ecuatoriali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora normale de Teranova",
               "NST",
               "Ora d’istà de Teranova",
               "NDT",
               "Ora de Teranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora normale de’l Turkmenistan",
               "",
               "Ora d’istà de’l Turkmenistan",
               "",
               "Ora de’l Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora de la Guyana franseze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora normale de la Nova Caledonia",
               "",
               "Ora d’istà de la Nova Caledonia",
               "",
               "Ora de la Nova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora de la Georgia de’l sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora normale de Ekaterinburgo",
               "",
               "Ora d’istà de Ekaterinburgo",
               "",
               "Ora de Ekaterinburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora de l’Àfrega sentrale",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora de l’Àfrega orientale",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ora de l’Àfrega osidentale",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora de Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora normale de l’Europa sentrale",
               "CET",
               "Ora d’istà de l’Europa sentrale",
               "CEST",
               "Ora de l’Europa sentrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora normale de l’Europa orientale",
               "EET",
               "Ora d’istà de l’Europa orientale",
               "EEST",
               "Ora de l’Europa orientale",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ora normale de l’Europa osidentale",
               "WET",
               "Ora d’istà de l’Europa osidentale",
               "WEST",
               "Ora de l’Europa osidentale",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora normale de’l Mèsego de’l Pasìfego",
               "MST",
               "Ora d’istà de’l Mèsego de’l Pasìfego",
               "MDT",
               "Ora de’l Mèsego de’l Pasìfego",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora de l’Àfrega meridionale",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ora normale de’l nord Amèrega sentrale",
               "CST",
               "Ora d’istà de’l nord Amèrega sentrale",
               "CDT",
               "Ora de’l nord Amèrega sentrale",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ora normale de’l nord Amèrega orientale",
               "EST",
               "Ora d’istà de’l nord Amèrega orientale",
               "EST",
               "Ora de’l nord Amèrega orientale",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Ora normale de’l Pasìfego",
               "PST",
               "Ora d’istà de’l Pasìfego",
               "PDT",
               "Ora de’l Pasìfego",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ora de le Tere fransezi de’l sud e de l’Antàrtego",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora de le Ìzole Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora normale de Hawai e Aleutine",
               "HST",
               "Ora d’istà de Hawai e Aleutine",
               "HDT",
               "Ora de Hawai e Aleutine",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora de le Ìzole Fenize",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora normale de S. Piero e Michelon",
               "",
               "Ora d’istà de S. Piero e Michelon",
               "",
               "Ora de S. Piero e Michelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora normale de’l nord Amèrega de le montagne",
               "MST",
               "Ora d’istà de’l nord Amèrega de le montagne",
               "MST",
               "Ora de’l nord Amèrega de le montagne",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora de le Ìzole Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora de la Papua Nova Guinèa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora normale de l’Australia sentrale",
               "ACST",
               "Ora d’istà de l’Australia sentrale",
               "ACDT",
               "Ora de l’Australia sentrale",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora normale de l’Australia orientale",
               "AEST",
               "Ora d’istà de l’Australia orientale",
               "AEDT",
               "Ora de l’Australia orientale",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ora normale de l’Australia osidentale",
               "AWST",
               "Ora d’istà de l’Australia osidentale",
               "AWDT",
               "Ora de l’Australia osidentale",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora de l’Indonezia sentrale",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora de l’Indonezia orientale",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora de l’Indonezia osidentale",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora normale de l’Australia sentro osidentale",
               "",
               "Ora d’istà de l’Australia sentro osidentale",
               "",
               "Ora de l’Australia sentro osidentale",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà irlandeze",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ora universale coordenada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà irlandeze",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Ora de’l meridian de Greenwich",
                    "GMT",
                    "Ora d’istà britànega",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Oral", "Oural" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktàu" },
            { "timezone.excity.Asia/Chita", "Cita" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "timezone.excity.Asia/Dubai", "Dubài" },
            { "timezone.excity.Asia/Macau", "Macào" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anàdyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyràu" },
            { "timezone.excity.Asia/Brunei", "Brunéi" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Taipei", "Taipéi" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urumchi" },
            { "timezone.excity.Etc/Unknown", "Sità desconosùa" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Ozlo" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "El Cairo" },
            { "timezone.excity.Africa/Ceuta", "Cèuta" },
            { "timezone.excity.Africa/Tunis", "Tùnezi" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Bishkek", "Biskek" },
            { "timezone.excity.Asia/Colombo", "Colonbo" },
            { "timezone.excity.Asia/Tbilisi", "Tiblisi" },
            { "timezone.excity.Asia/Thimphu", "Tinpu" },
            { "timezone.excity.Asia/Yerevan", "Jèrevan" },
            { "timezone.excity.Europe/Paris", "Pariji" },
            { "timezone.excity.Indian/Cocos", "Ìzole Cocos" },
            { "timezone.excity.Pacific/Niue", "Ìzola Niue" },
            { "timezone.excity.Pacific/Truk", "Ìzole Chuuk" },
            { "timezone.excity.Pacific/Wake", "Atolo Wake" },
            { "timezone.excity.Africa/Asmera", "Azmara" },
            { "timezone.excity.Africa/Bangui", "Banghì" },
            { "timezone.excity.Africa/Bissau", "Bisào" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Maseru", "Mazeru" },
            { "timezone.excity.Asia/Ashgabat", "Azgabad" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Dusanbé" },
            { "timezone.excity.Asia/Katmandu", "Katmandù" },
            { "timezone.excity.Asia/Khandyga", "Hàndiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanài" },
            { "timezone.excity.Asia/Sakhalin", "Sacalin" },
            { "timezone.excity.Asia/Shanghai", "Shanghài" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Gnera" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Lisbon", "Lizbona" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Monaco", "Mònaco" },
            { "timezone.excity.Europe/Moscow", "Mosca" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsavia" },
            { "timezone.excity.Europe/Zurich", "Zurigo" },
            { "timezone.excity.Indian/Chagos", "Ciagos" },
            { "timezone.excity.Indian/Comoro", "Ìzole Comore" },
            { "timezone.excity.Pacific/Efate", "Ìzola Efate" },
            { "timezone.excity.Pacific/Nauru", "Ìzola Nauru" },
            { "timezone.excity.Pacific/Palau", "Palàu" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abijan" },
            { "timezone.excity.Africa/Algiers", "Aljeri" },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Africa/Kampala", "Kanpala" },
            { "timezone.excity.Africa/Mbabane", "Nbabane" },
            { "timezone.excity.Africa/Tripoli", "Trìpoli" },
            { "timezone.excity.America/Bogota", "Bogotà" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.America/Cuiaba", "Cuiabà" },
            { "timezone.excity.America/Denver", "Dènver" },
            { "timezone.excity.America/Havana", "L’Avana" },
            { "timezone.excity.America/Panama", "Pànama" },
            { "timezone.excity.Asia/Famagusta", "Famagosta" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzaleme" },
            { "timezone.excity.Asia/Kamchatka", "Kamciatka" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vategan" },
            { "timezone.excity.Indian/Mayotte", "Ìzole Maiote" },
            { "timezone.excity.Indian/Reunion", "Ìzola Reunion" },
            { "timezone.excity.Pacific/Easter", "Ìzola de Pascua" },
            { "timezone.excity.Pacific/Kosrae", "Ìzola Kosrae" },
            { "timezone.excity.Pacific/Midway", "Atolo Midway" },
            { "timezone.excity.Pacific/Ponape", "Ìzola Ponpèi" },
            { "timezone.excity.Pacific/Saipan", "Ìzola Saipàn" },
            { "timezone.excity.Pacific/Tahiti", "Ìzola Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Atollo Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Ìzola Wallis" },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ajun" },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "timezone.excity.Africa/Ndjamena", "Jamena" },
            { "timezone.excity.Africa/Sao_Tome", "Ìzola S. Tomazo" },
            { "timezone.excity.America/Cayenne", "Cayena" },
            { "timezone.excity.America/Cordoba", "Còrdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Jamaica", "Jamàega" },
            { "timezone.excity.America/Tortola", "Tòrtola" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom Pen" },
            { "timezone.excity.Atlantic/Azores", "Ìzole Azore" },
            { "timezone.excity.Atlantic/Canary", "Ìzole Canarie" },
            { "timezone.excity.Atlantic/Faeroe", "Ìzole Fàroe" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Istanbul", "Ìstanbul" },
            { "timezone.excity.Indian/Maldives", "Ìzole Maldive" },
            { "timezone.excity.Pacific/Chatham", "Ìzole Ciatem" },
            { "timezone.excity.Pacific/Fakaofo", "Atolo Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Ìzole Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Ìzola Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujunbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiso" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Asunsion" },
            { "timezone.excity.America/Dominica", "Doménega" },
            { "timezone.excity.America/Miquelon", "Michelon" },
            { "timezone.excity.America/St_Johns", "S. Joani" },
            { "timezone.excity.America/St_Kitts", "S. Cristofer" },
            { "timezone.excity.America/St_Lucia", "S. Lusìa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Kraznayarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bàtor" },
            { "timezone.excity.Atlantic/Madeira", "Ìzola Madèira" },
            { "timezone.excity.Europe/Amsterdam", "Àmsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Jibiltera" },
            { "timezone.excity.Europe/Ljubljana", "Lubliana" },
            { "timezone.excity.Europe/Podgorica", "Podgorisa" },
            { "timezone.excity.Europe/Stockholm", "Stocolma" },
            { "timezone.excity.Europe/Ulyanovsk", "Uliànosk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Ìzola de Nadale" },
            { "timezone.excity.Indian/Mauritius", "Ìzole Maurisio" },
            { "timezone.excity.Pacific/Funafuti", "Atolo Funafuti" },
            { "timezone.excity.Pacific/Pitcairn", "Ìzola Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Cazablanca" },
            { "timezone.excity.Africa/Lubumbashi", "Lubunbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nuakchot" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Monterrey", "Monterey" },
            { "timezone.excity.America/Sao_Paulo", "San Polo" },
            { "timezone.excity.America/St_Thomas", "S. Tomazo" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lunpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznietsk" },
            { "timezone.excity.Europe/Bratislava", "Bratizlava" },
            { "timezone.excity.Europe/Copenhagen", "Copenaghen" },
            { "timezone.excity.Europe/Luxembourg", "Lusenburgo" },
            { "timezone.excity.Europe/San_Marino", "San Marin" },
            { "timezone.excity.Europe/Simferopol", "Sinferòpoli" },
            { "timezone.excity.Pacific/Enderbury", "Atolo Canton" },
            { "timezone.excity.Pacific/Galapagos", "Galàpagos" },
            { "timezone.excity.Pacific/Kwajalein", "Atolo Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Ìzole Marchezi" },
            { "timezone.excity.Pacific/Pago_Pago", "Pango Pango" },
            { "timezone.excity.Pacific/Rarotonga", "Ìzola Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Ìzola Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugù" },
            { "timezone.excity.America/Guadeloupe", "Guadalupa" },
            { "timezone.excity.America/Martinique", "Martiniga" },
            { "timezone.excity.America/Montserrat", "Montserat" },
            { "timezone.excity.America/St_Vincent", "S. Vincenso" },
            { "timezone.excity.Asia/Srednekolymsk", "Zrédnekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Rekiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Ìzola S. Elena" },
            { "timezone.excity.Australia/Adelaide", "Adelàide" },
            { "timezone.excity.Australia/Brisbane", "Brizbane" },
            { "timezone.excity.Europe/Isle_of_Man", "Ìzola de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Pacific/Kiritimati", "Atolo Kiritimati" },
            { "timezone.excity.America/Los_Angeles", "Los Àngeles" },
            { "timezone.excity.America/Mexico_City", "Sità de’l Mèsego" },
            { "timezone.excity.America/Puerto_Rico", "Portorico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cao Verdo" },
            { "timezone.excity.Australia/Lord_Howe", "Ìzola Lord Howe" },
            { "timezone.excity.Pacific/Guadalcanal", "Ìzola Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salam" },
            { "timezone.excity.America/Campo_Grande", "Canpo Grande" },
            { "timezone.excity.America/Indiana/Knox", "Knox (Indiana)" },
            { "timezone.excity.America/Indianapolis", "Indianàpolis" },
            { "timezone.excity.Antarctica/Macquarie", "Ìzola Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Ìzola Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Porto Moresby" },
            { "timezone.excity.America/Ciudad_Juarez", "Juárez" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay (Indiana)" },
            { "timezone.excity.America/Port_of_Spain", "Porto de Spagna" },
            { "timezone.excity.America/St_Barthelemy", "S. Bartolomèo" },
            { "timezone.excity.America/Bahia_Banderas", "Baia de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Prìnsipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia de’l sud" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo (Indiana)" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac (Indiana)" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City (Indiana)" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes (Indiana)" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg (Indiana)" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello (Kentucky)" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah (Nord Dakota)" },
            { "timezone.excity.America/North_Dakota/Center", "Center (Nord Dakota)" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gàlegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem (Nord Dakota)" },
        };
        return data;
    }
}
