//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// The AudioServerPlugInCustomPropertyInfo struct is used to describe enough about
/// a custom property to allow the Host to marshal the data between the Host and
/// its clients.
/// Field: mSelector
/// The AudioObjectPropertySelector of the custom property.
/// Field: mPropertyDataType
/// A UInt32 whose value indicates the data type of the data of the custom
/// property. Constants for this value are defined in the Basic Constants
/// section.
/// Field: mQualifierDataType
/// A UInt32 whose value indicates the data type of the data of the custom
/// property. Constants for this value are defined in the Basic Constants
/// section.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioserverplugincustompropertyinfo?language=objc)
#[cfg(feature = "AudioHardware")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioServerPlugInCustomPropertyInfo {
    pub mSelector: AudioObjectPropertySelector,
    pub mPropertyDataType: u32,
    pub mQualifierDataType: u32,
}

#[cfg(all(feature = "AudioHardware", feature = "objc2"))]
unsafe impl Encode for AudioServerPlugInCustomPropertyInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioServerPlugInCustomPropertyInfo",
        &[
            <AudioObjectPropertySelector>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AudioHardware", feature = "objc2"))]
unsafe impl RefEncode for AudioServerPlugInCustomPropertyInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The AudioServerPlugInClientInfo struct is used to identify a client of the Host
/// to the plug-in.
/// Field: mClientID
/// An ID that allows for differentiating multiple clients in the same process.
/// This ID is passed to the plug-in during IO so that the plug-in can associate
/// the IO with the client easily.
/// Field: mProcessID
/// The pid_t of the process that contains the client.
/// Field: mIsNativeEndian
/// A Boolean indicating whether or not the client has the same endianness as
/// the server.
/// Field: mBundleID
/// A CFStringRef that contains the bundle ID of the main bundle of the process
/// that contains the client. Note that the plug-in is expected to retain this
/// string itself if the plug-in wishes to keep it around.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioserverpluginclientinfo?language=objc)
#[cfg(feature = "libc")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioServerPlugInClientInfo {
    pub mClientID: u32,
    pub mProcessID: libc::pid_t,
    pub mIsNativeEndian: Boolean,
    pub mBundleID: *const CFString,
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl Encode for AudioServerPlugInClientInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioServerPlugInClientInfo",
        &[
            <u32>::ENCODING,
            <libc::pid_t>::ENCODING,
            <Boolean>::ENCODING,
            <*const CFString>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for AudioServerPlugInClientInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpluginobject?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioObjectPlugInObject: AudioObjectID = 1;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioserverpluginhostclientid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioServerPlugInHostClientID: AudioObjectID = 0;

/// The set of data types the Host knows how to marshal between the server and the
/// client. These are the only types supported for custom properties. See
/// AudioServerPlugInCustomPropertyInfo for more information.
///
/// This is used to declare that the property doesn't have any property or
/// qualifier data.
///
/// The property/qualifier data is a CFStringRef.
///
/// The property/qualifier data is a CFPropertyListRef.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioserverplugincustompropertydatatype?language=objc)
pub type AudioServerPlugInCustomPropertyDataType = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioserverplugincustompropertydatatypenone?language=objc)
pub const kAudioServerPlugInCustomPropertyDataTypeNone: AudioServerPlugInCustomPropertyDataType = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioserverplugincustompropertydatatypecfstring?language=objc)
pub const kAudioServerPlugInCustomPropertyDataTypeCFString:
    AudioServerPlugInCustomPropertyDataType = 0x63667374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioserverplugincustompropertydatatypecfpropertylist?language=objc)
pub const kAudioServerPlugInCustomPropertyDataTypeCFPropertyList:
    AudioServerPlugInCustomPropertyDataType = 0x706c7374;

/// The valid values for the inOperationID argument to the various IO methods.
///
/// This operation marks the beginning and the ending of the IO thread. Note
/// that DoIOOperation() will never be called with this ID.
///
/// This operation marks the beginning and ending of each IO cycle. Note that
/// DoIOOperation() will never be called with this ID.
///
/// This operation transfers the input data from the device's ring buffer to the
/// provided buffer in the stream's native format. Note that this operation
/// always happens in-place in the main buffer passed to DoIOOperation(). It is
/// required that this operation be implemented if the AudioDevice has input
/// streams.
///
/// This operation converts the input data from its native format to the
/// canonical format.
///
/// This operation performs arbitrary signal processing on the input data in the
/// canonical format.
///
/// This operation performs arbitrary signal processing on the output data in
/// the canonical format.
///
/// This operation mixes the output data into the device's ring buffer. Note
/// that if a plug-in implements this operation, no further output operations
/// will occur for that cycle. It is assumed that the device handles everything
/// from there down including preparing the data for consumption by the
/// hardware. Note also that this operation always happens in-place in the main
/// buffer passed to DoIOOperation().
///
/// This operation processes the full mix of all clients' data in the canonical
/// format.
///
/// This operation converts the fully mixed data from the canonical format to
/// the device's native format.
///
/// This operation puts the data into the device's ring buffer for consumption
/// of the hardware. Note that this operation always happens in-place in the
/// main buffer passed to DoIOOperation(). It is required that this operation be
/// implemented if the AudioDevice has output streams.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioserverpluginiooperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioServerPlugInIOOperation(pub u32);
impl AudioServerPlugInIOOperation {
    #[doc(alias = "kAudioServerPlugInIOOperationThread")]
    pub const Thread: Self = Self(0x74687264);
    #[doc(alias = "kAudioServerPlugInIOOperationCycle")]
    pub const Cycle: Self = Self(0x6379636c);
    #[doc(alias = "kAudioServerPlugInIOOperationReadInput")]
    pub const ReadInput: Self = Self(0x72656164);
    #[doc(alias = "kAudioServerPlugInIOOperationConvertInput")]
    pub const ConvertInput: Self = Self(0x63696e70);
    #[doc(alias = "kAudioServerPlugInIOOperationProcessInput")]
    pub const ProcessInput: Self = Self(0x70696e70);
    #[doc(alias = "kAudioServerPlugInIOOperationProcessOutput")]
    pub const ProcessOutput: Self = Self(0x706f7574);
    #[doc(alias = "kAudioServerPlugInIOOperationMixOutput")]
    pub const MixOutput: Self = Self(0x6d69786f);
    #[doc(alias = "kAudioServerPlugInIOOperationProcessMix")]
    pub const ProcessMix: Self = Self(0x706d6978);
    #[doc(alias = "kAudioServerPlugInIOOperationConvertMix")]
    pub const ConvertMix: Self = Self(0x636d6978);
    #[doc(alias = "kAudioServerPlugInIOOperationWriteMix")]
    pub const WriteMix: Self = Self(0x72697465);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioServerPlugInIOOperation {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioServerPlugInIOOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertycustompropertyinfolist?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioObjectPropertyCustomPropertyInfoList: AudioObjectPropertySelector = 0x63757374;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertyresourcebundle?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioPlugInPropertyResourceBundle: AudioObjectPropertySelector = 0x72737263;

/// The valid values for kAudioDevicePropertyClockAlgorithm
///
/// When this value for the clock algorithm is specified, the Host will not
/// apply any filtering to the time stamps returned from GetZeroTimeStamp(). The
/// values will be used as-is.
///
/// When this value for the clock algorithm is specified, the Host applies a
/// simple IIR filter to the time stamp stream. This is the default algorithm
/// used for devices that don't implement kAudioDevicePropertyClockAlgorithm.
///
/// This clock algorithm uses a 12 point moving window average to filter the time
/// stamps returned from GetZeroTimeStamp().
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodeviceclockalgorithmselector?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioDeviceClockAlgorithmSelector(pub u32);
impl AudioDeviceClockAlgorithmSelector {
    #[doc(alias = "kAudioDeviceClockAlgorithmRaw")]
    pub const AlgorithmRaw: Self = Self(0x72617777);
    #[doc(alias = "kAudioDeviceClockAlgorithmSimpleIIR")]
    pub const AlgorithmSimpleIIR: Self = Self(0x69697266);
    #[doc(alias = "kAudioDeviceClockAlgorithm12PtMovingWindowAverage")]
    pub const Algorithm12PtMovingWindowAverage: Self = Self(0x6d617667);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioDeviceClockAlgorithmSelector {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioDeviceClockAlgorithmSelector {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyzerotimestampperiod?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyZeroTimeStampPeriod: AudioObjectPropertySelector = 0x72696e67;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclockalgorithm?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyClockAlgorithm: AudioObjectPropertySelector = 0x636c6f6b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclockisstable?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyClockIsStable: AudioObjectPropertySelector = 0x63737462;
