/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.types.basic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.JBooleanField;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JCharField;
import sun.jvm.hotspot.types.JDoubleField;
import sun.jvm.hotspot.types.JFloatField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.JLongField;
import sun.jvm.hotspot.types.JShortField;
import sun.jvm.hotspot.types.NarrowOopField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.PointerType;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.types.basic.BasicAddressFieldWrapper;
import sun.jvm.hotspot.types.basic.BasicNarrowOopField;
import sun.jvm.hotspot.types.basic.BasicTypeDataBase;
import sun.jvm.hotspot.utilities.ConstIterator;

public class BasicType
implements Type {
    protected BasicTypeDataBase db;
    private String name;
    private long size;
    private boolean isJavaPrimitiveType;
    private boolean isOopType;
    private Map nameToFieldMap = new HashMap();
    private List fieldList = new LinkedList();
    private Type superclass;

    public BasicType(BasicTypeDataBase db, String name, Type superclass) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        this.db = db;
        this.name = name;
        this.superclass = superclass;
    }

    public BasicType(BasicTypeDataBase db, String name) {
        this(db, name, null);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicType)) {
            return false;
        }
        BasicType arg = (BasicType)obj;
        return this.name.equals(arg.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSuperclass(Type superclass) {
        this.superclass = superclass;
    }

    @Override
    public Type getSuperclass() {
        return this.superclass;
    }

    public void setSize(long sizeInBytes) {
        this.size = sizeInBytes;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isCIntegerType() {
        return false;
    }

    @Override
    public boolean isCStringType() {
        if (this.isPointerType()) {
            Type target = ((PointerType)((Object)this)).getTargetType();
            return target.isCIntegerType() && target.getName().equals("const char");
        }
        return false;
    }

    @Override
    public boolean isJavaPrimitiveType() {
        return this.isJavaPrimitiveType;
    }

    public void setIsJavaPrimitiveType(boolean isJavaPrimitiveType) {
        this.isJavaPrimitiveType = isJavaPrimitiveType;
    }

    @Override
    public boolean isOopType() {
        return this.isOopType;
    }

    @Override
    public boolean isPointerType() {
        return false;
    }

    public void setIsOopType(boolean isOopType) {
        this.isOopType = isOopType;
    }

    @Override
    public Field getField(String fieldName, boolean searchSuperclassFields, boolean throwExceptionIfNotFound) {
        Field field = null;
        if (this.nameToFieldMap != null && (field = (Field)this.nameToFieldMap.get(fieldName)) != null) {
            return field;
        }
        if (searchSuperclassFields && this.superclass != null) {
            field = this.superclass.getField(fieldName, searchSuperclassFields, false);
        }
        if (field == null && throwExceptionIfNotFound) {
            throw new RuntimeException("field \"" + fieldName + "\" not found in type " + this.name);
        }
        return field;
    }

    @Override
    public Field getField(String fieldName, boolean searchSuperclassFields) {
        return this.getField(fieldName, searchSuperclassFields, true);
    }

    @Override
    public Field getField(String fieldName) {
        return this.getField(fieldName, true);
    }

    @Override
    public Field getField(String fieldName, Type declaredType, boolean searchSuperclassFields) throws WrongTypeException {
        Field res = this.getField(fieldName, searchSuperclassFields);
        if (res == null) {
            return null;
        }
        if (!res.getType().equals(declaredType)) {
            throw new WrongTypeException("field \"" + fieldName + "\" in type " + this.name + " is not of type " + declaredType + ", but instead of type " + res.getType());
        }
        return res;
    }

    @Override
    public Field getField(String fieldName, Type declaredType) throws WrongTypeException {
        return this.getField(fieldName, declaredType, false);
    }

    @Override
    public Iterator getFields() {
        return new ConstIterator(this.fieldList.iterator());
    }

    @Override
    public JBooleanField getJBooleanField(String fieldName) throws WrongTypeException {
        return (JBooleanField)this.getField(fieldName, this.db.getJBooleanType());
    }

    @Override
    public JByteField getJByteField(String fieldName) throws WrongTypeException {
        return (JByteField)this.getField(fieldName, this.db.getJByteType());
    }

    @Override
    public JCharField getJCharField(String fieldName) throws WrongTypeException {
        return (JCharField)this.getField(fieldName, this.db.getJCharType());
    }

    @Override
    public JDoubleField getJDoubleField(String fieldName) throws WrongTypeException {
        return (JDoubleField)this.getField(fieldName, this.db.getJDoubleType());
    }

    @Override
    public JFloatField getJFloatField(String fieldName) throws WrongTypeException {
        return (JFloatField)this.getField(fieldName, this.db.getJFloatType());
    }

    @Override
    public JIntField getJIntField(String fieldName) throws WrongTypeException {
        return (JIntField)this.getField(fieldName, this.db.getJIntType());
    }

    @Override
    public JLongField getJLongField(String fieldName) throws WrongTypeException {
        return (JLongField)this.getField(fieldName, this.db.getJLongType());
    }

    @Override
    public JShortField getJShortField(String fieldName) throws WrongTypeException {
        return (JShortField)this.getField(fieldName, this.db.getJShortType());
    }

    @Override
    public CIntegerField getCIntegerField(String fieldName) throws WrongTypeException {
        Field field = this.getField(fieldName);
        if (!(field.getType() instanceof CIntegerType)) {
            throw new WrongTypeException("field \"" + fieldName + "\" in type " + this.name + " is not of C integer type, but instead of type " + field.getType());
        }
        return (CIntegerField)field;
    }

    @Override
    public OopField getOopField(String fieldName) throws WrongTypeException {
        Field field = this.getField(fieldName);
        if (!field.getType().isOopType()) {
            throw new WrongTypeException("field \"" + fieldName + "\" in type " + this.name + " is not of oop type, but instead of type " + field.getType());
        }
        return (OopField)field;
    }

    @Override
    public NarrowOopField getNarrowOopField(String fieldName) throws WrongTypeException {
        return new BasicNarrowOopField(this.getOopField(fieldName));
    }

    @Override
    public AddressField getAddressField(String fieldName) {
        Field field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return new BasicAddressFieldWrapper(field);
    }

    public void addField(Field field) {
        if (this.nameToFieldMap.get(field.getName()) != null) {
            throw new RuntimeException("field of name \"" + field.getName() + "\" already present in type " + this);
        }
        this.nameToFieldMap.put(field.getName(), field);
        this.fieldList.add(field);
    }

    public void removeField(Field field) {
        if (this.nameToFieldMap.remove(field.getName()) == null) {
            throw new RuntimeException("field of name \"" + field.getName() + "\" was not present");
        }
        this.fieldList.remove(field);
    }
}

