import { marked } from 'marked';
import hljs from 'highlight.js/lib/core';
import json from 'highlight.js/lib/languages/json';
hljs.registerLanguage('json', json);
import yaml from 'highlight.js/lib/languages/yaml';
hljs.registerLanguage('yaml', yaml);
import bash from 'highlight.js/lib/languages/bash';
hljs.registerLanguage('bash', bash);
var markedOptions = {
    langPrefix: 'hljs language-',
    highlight: function (code, language) {
        if (!hljs.getLanguage(language)) {
            return code;
        }
        try {
            return hljs.highlight(code, { language: language }).value;
        }
        catch (e) {
            return code;
        }
    },
};
export function renderMarkdown(content) {
    return marked(content, markedOptions);
}
export { hljs };
//# sourceMappingURL=marked.js.map