/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.clickhouse.types.CHouseMapType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Case;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.clickhouse.CHouseElementTypes;
import com.intellij.sql.dialects.clickhouse.CHouseLexer;
import com.intellij.sql.dialects.clickhouse.CHouseOptionalKeywords;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.dialects.clickhouse.refactoring.CHouseExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseDialect
extends SqlLanguageDialectBase {
    public static final CHouseDialect INSTANCE = new CHouseDialect();

    private CHouseDialect() {
        super("ClickHouse");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        return new TokensHelper(CHouseTokens.class, (SqlLanguageDialectEx.BuiltinFunctions)new SuffixedBuiltinFunctions());
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.ANY_NA);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.STRING_OR_TOKEN);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.STRING_OR_SCHEMA);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UInt8", (String)"UInt8", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UInt16", (String)"UInt16", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UInt32", (String)"UInt32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UInt64", (String)"UInt64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UInt256", (String)"UInt256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int8", (String)"Int8", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int16", (String)"Int16", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int32", (String)"Int32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int64", (String)"Int64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int128", (String)"Int128", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Int256", (String)"Int256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Float32", (String)"Float32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Float64", (String)"Float64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Decimal", (String)"Decimal", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Decimal32", (String)"Decimal32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Decimal64", (String)"Decimal64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Decimal128", (String)"Decimal128", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Decimal256", (String)"Decimal256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Date", (String)"Date", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"DateTime", (String)"DateTime", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"DateTime64", (String)"DateTime64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalSecond", (String)"IntervalSecond", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalMinute", (String)"IntervalMinute", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalHour", (String)"IntervalHour", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalDay", (String)"IntervalDay", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalWeek", (String)"IntervalWeek", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalMonth", (String)"IntervalMonth", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalQuarter", (String)"IntervalQuarter", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IntervalYear", (String)"IntervalYear", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"String", (String)"String", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"FixedString", (String)"FixedString", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.ARRAY);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.TUPLE);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Enum", (String)"Enum", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"UUID", (String)"UUID", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Expression", (String)"Expression", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"LowCardinality", (String)"LowCardinality", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"Map", (String)"Map", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IPv4", (String)"IPv4", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"IPv6", (String)"IPv6", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.AGGREGATE_FUNCTION);
        SqlFunctionsUtil.addSimpleType(myTypes, (BuiltinFunction.Type)Types.SIMPLE_AGGREGATE_FUNCTION);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity.Typed entity : LazyData.RE_COLUMNS) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (DasType)entity.type, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)true, (Boolean)true)) continue;
                return false;
            }
        }
        if (place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity type : LazyData.ourObjects) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)type, (DasType)DasTypeSystemBase.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)true, (Boolean)resolve)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CHouseDialect.getDefaultNamespace((DbDataSource)dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                CHouseDialect.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, true);
        if (treePattern == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        return treePattern;
    }

    public static SqlTableType filterComputedColumns(@NotNull SqlTableType type) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        SqlTableType resultType = type;
        int i = 0;
        while (i < resultType.getColumnCount()) {
            PsiElement columnSource = resultType.getSourceColumnElement(i);
            if (columnSource instanceof PsiColumn && SqlImplUtil.isComputedVal((DasColumn)((PsiColumn)columnSource))) {
                resultType = SubtractedSqlTableTypeImpl.subtract((SqlTableType)resultType, (int)i);
                continue;
            }
            ++i;
        }
        return resultType;
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        return CHouseDialect.isOpIn(place) && !(place.getParent() instanceof SqlReferenceExpression);
    }

    @NotNull
    public Set<BuiltinFunction.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression, SqlReferenceExpression.class);
        if (ref != null) {
            ObjectKind kind = ref.getReferenceElementType().getTargetKind();
            if (kind == CHouseElementTypes.Kinds.TABLE_ENGINE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.TABLE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(8);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DATABASE_ENGINE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DATABASE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(9);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.CODEC) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.CODEC_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(10);
                }
                return enumSet;
            }
            if (kind == SqlDbElementType.INDEXTYPE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.INDEX_TYPE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(11);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DICTIONARY_SOURCE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DICTIONARY_SOURCE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(12);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DICTIONARY_LAYOUT) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DICTIONARY_LAYOUT_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(13);
                }
                return enumSet;
            }
        }
        Set set = super.getExpectedFunctionLocations(expression);
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        if (text == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        return CHouseLexer.isValidRawToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        return LazyData.SPECIAL_FUNCTION_REFERENCES.contains(elementType);
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        DasObject parent;
        DasObject object = symbol != null ? symbol.getDasObject() : null;
        DasObject dasObject = parent = object != null ? object.getDasParent() : null;
        if (object instanceof SqlRoutineDefinition) {
            return super.shouldHide(symbol, place);
        }
        return object instanceof DasRoutine && parent != null && parent.getKind() == ObjectKind.ROOT;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        Collection res = super.getParentDbTypes(result, type);
        if (type == ObjectKind.COLUMN) {
            res.add(ObjectKind.COLUMN);
        }
        if (type == CHouseElementTypes.Kinds.DICTIONARY) {
            res.add(ObjectKind.SCHEMA);
        }
        return (T)res;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        if ((type == ObjectKind.VIEW || type == ObjectKind.MAT_VIEW || type == CHouseElementTypes.Kinds.DICTIONARY) && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && (expectedTypes.contains(CHouseElementTypes.Kinds.TABLE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.DATABASE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.CODEC) || expectedTypes.contains(SqlDbElementType.INDEXTYPE) || expectedTypes.contains(CHouseElementTypes.Kinds.DICTIONARY_SOURCE) || expectedTypes.contains(CHouseElementTypes.Kinds.DICTIONARY_LAYOUT))) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CHouseDialect.$$$reportNull$$$0(19);
        }
        if (place instanceof SqlPositionalReference) {
            return type != ObjectKind.COLUMN;
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(20);
        }
        return !this.getKeywords().contains(ref);
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        SqlReferenceExpression qre;
        SqlExpression sqlExpression;
        boolean couldBeJson;
        if (type == ObjectKind.FORMAT || type == ObjectKind.PARTITION || type == CHouseElementTypes.Kinds.INSTANCE_CLUSTER) {
            return false;
        }
        boolean bl = couldBeJson = o != null && (sqlExpression = o.getQualifierExpression()) instanceof SqlReferenceExpression && CHouseDialect.couldBeJson(qre = (SqlReferenceExpression)sqlExpression);
        if (couldBeJson) {
            return false;
        }
        return super.shallResolve(o, type);
    }

    private static boolean couldBeJson(@NotNull SqlReferenceExpression qre) {
        DasSymbol[] targets;
        if (qre == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        if ((targets = qre.multiResolveSymbol()).length == 0) {
            return false;
        }
        for (DasSymbol symbol : targets) {
            if (CHouseDialect.isJson(symbol)) continue;
            return false;
        }
        return true;
    }

    private static boolean isJson(@Nullable DasSymbol symbol) {
        DasTypedObject typed;
        return symbol instanceof DasTypedObject && (typed = (DasTypedObject)symbol).getDasType().getSpecification().equalsIgnoreCase("json");
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        SqlReferenceExpression prevRef;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        if (!CHouseDialect.processAliases((SqlScopeProcessor)processor, (ResolveState)state, (PsiReference)ref)) {
            return false;
        }
        PsiElement place = ref.getElement();
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.TABLE}) && ObjectUtils.tryCast((Object)place.getParent(), SqlExpressionList.class) != null && (prevRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)place, SqlExpression.class), SqlReferenceExpression.class)) != null && prevRef.getReferenceElementType().getTargetKind() == ObjectKind.SCHEMA && !SqlImplUtil.processQualifier((SqlReferenceExpression)prevRef, (SqlScopeProcessor)processor, (ResolveState)state, (PsiElement)place)) {
            return false;
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull DasType qualifierType) {
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(25);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(26);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        if (qualifierType == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN})) {
            if (qualifierType instanceof DasArrayType) {
                DasArrayType arrayType = (DasArrayType)qualifierType;
                return this.processQualifiedResolve(processor, state, ref, arrayType.getComponentType());
            }
            if (qualifierType instanceof CHouseMapType) {
                for (ReservedEntity entity : LazyData.RE_MAP_COLUMNS) {
                    if (CHouseDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, null, (String)ref.getReferenceName(), (PsiElement)ref.getElement(), (boolean)true, (SqlScopeProcessor)processor, (boolean)true, (Boolean)true)) continue;
                    return false;
                }
            }
        }
        return super.processQualifiedResolve(processor, state, ref, qualifierType);
    }

    public boolean processTypeExtra(SqlTableType type, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        for (DasSymbol pc : CHouseDialect.getParentColumnObjects(place.getContainingFile(), type)) {
            if (processor.execute(pc, state)) continue;
            return false;
        }
        return super.processTypeExtra(type, processor, state, place);
    }

    @NotNull
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        CHouseExtractFunctionHelper cHouseExtractFunctionHelper = CHouseExtractFunctionHelper.INSTANCE;
        if (cHouseExtractFunctionHelper == null) {
            CHouseDialect.$$$reportNull$$$0(29);
        }
        return cHouseExtractFunctionHelper;
    }

    private static boolean isOpIn(@Nullable PsiElement place) {
        SqlBinaryExpression exp;
        SqlBinaryExpression sqlBinaryExpression = exp = place == null ? null : (SqlBinaryExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlBinaryExpression.class);
        if (exp == null || exp.getROperand() != place) {
            return place == null;
        }
        return exp.getOpSign() == SqlCommonKeywords.SQL_IN;
    }

    @NotNull
    public static List<DasSymbol> getParentColumnObjects(@NotNull PsiFile file, @Nullable SqlTableType type) {
        if (file == null) {
            CHouseDialect.$$$reportNull$$$0(30);
        }
        if (type == null || type.getTypeElement() instanceof MyAggColumnDefinition) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(31);
            }
            return list;
        }
        HashMap<String, List> grouped = null;
        int c = type.getColumnCount();
        for (int i = 0; i < c; ++i) {
            String name2 = type.getColumnName(i);
            int dotIdx = name2.indexOf(46);
            if (dotIdx == -1) continue;
            if (grouped == null) {
                grouped = new HashMap<String, List>();
            }
            grouped.computeIfAbsent(name2.substring(0, dotIdx), __ -> new ArrayList()).add((PsiElement)ObjectUtils.chooseNotNull((Object)type.getSourceColumnElement(i), (Object)type.getColumnElement(i)));
        }
        if (grouped == null) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<DasSymbol> res = new ArrayList<DasSymbol>(grouped.size());
        ConcurrentMap caches = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)CollectionFactory.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        for (Map.Entry entry : grouped.entrySet()) {
            res.add((DasSymbol)caches.computeIfAbsent(Pair.create((Object)((String)entry.getKey()), (Object)((List)entry.getValue())), param -> new MyAggColumnDefinition((PsiElement)((List)param.second).get(0), (String)param.first, (List)param.second)));
        }
        ArrayList<DasSymbol> arrayList = res;
        if (arrayList == null) {
            CHouseDialect.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    public static boolean isNestedType(@NotNull SqlColumnDefinition o1) {
        SqlTypeElement type;
        if (o1 == null) {
            CHouseDialect.$$$reportNull$$$0(34);
        }
        if (PsiUtilCore.getElementType((PsiElement)(type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)o1, SqlTypeElement.class))) != SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT) {
            return false;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)type, SqlReferenceExpression.class);
        return ref != null && ref.getName().equals("Nested");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 7, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 34 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qre";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractFunctionHelper";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentColumnObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterComputedColumns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "couldBeJson";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParentColumnObjects";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isNestedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 6, 7, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 34 -> new IllegalArgumentException(string);
        };
    }

    private static class SuffixedBuiltinFunctions
    implements SqlLanguageDialectEx.BuiltinFunctions {
        private final SqlLanguageDialectEx.BuiltinFunctions myDelegate = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        private final Map<String, BuiltinFunction> myCache = ConcurrentFactoryMap.create(this::computeDef, ContainerUtil::createConcurrentSoftValueMap);

        private SuffixedBuiltinFunctions() {
        }

        @Nullable
        public BuiltinFunction get(@Nullable String name2) {
            if (name2 == null) {
                return null;
            }
            BuiltinFunction base = this.getImpl(name2);
            if (base != null && !"true".equals(base.getDialectAttribute("aggregate"))) {
                return base;
            }
            return this.myCache.get(name2);
        }

        @Nullable
        private BuiltinFunction computeDef(@NotNull String name2) {
            if (name2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(0);
            }
            BuiltinFunction base = this.getImpl(name2);
            BuiltinFunction suffixed = this.getSuffixed(name2);
            if (base == null) {
                return suffixed;
            }
            if (suffixed == null) {
                return base;
            }
            BuiltinFunction.Prototype[] baseProtos = base.getPrototypes();
            BuiltinFunction.Prototype[] suffixProtos = suffixed.getPrototypes();
            ArrayList<BuiltinFunction.Prototype> newProtos = new ArrayList<BuiltinFunction.Prototype>(baseProtos.length + suffixProtos.length);
            Collections.addAll(newProtos, baseProtos);
            for (BuiltinFunction.Prototype proto : suffixProtos) {
                BuiltinFunction.Prototype newProto = new BuiltinFunction.Prototype(proto.getFunction(), proto.getReturnType(), proto.getPrototypeId() + baseProtos.length, proto.getHeadBlock(), proto.getParams(), proto.getAttributes());
                newProtos.add(newProto);
            }
            return new BuiltinFunction(base.getName(), base.getAliasedFunction(), base.getDialectAttrs(), newProtos, base.getDbms());
        }

        @Nullable
        private BuiltinFunction getSuffixed(@NotNull String name2) {
            Suffix suffix;
            if (name2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(1);
            }
            if ((suffix = Suffix.find(name2)) == null) {
                return null;
            }
            BuiltinFunction def = this.myDelegate.get(name2 = suffix.trim(name2));
            if (def != null && !"true".equals(def.getDialectAttribute("aggregate"))) {
                return null;
            }
            if (def == null) {
                def = this.getSuffixed(name2);
            }
            return def == null ? null : suffix.modify(def);
        }

        public boolean contains(@Nullable String name2) {
            if (this.getImpl(name2) != null) {
                return true;
            }
            while (name2 != null) {
                Suffix suffix = Suffix.find(name2);
                if (suffix == null) {
                    return false;
                }
                BuiltinFunction def = this.myDelegate.get(name2 = suffix.trim(name2));
                if (def == null) continue;
                return "true".equals(def.getDialectAttribute("aggregate"));
            }
            return false;
        }

        @Nullable
        private BuiltinFunction getImpl(@Nullable String name2) {
            BuiltinFunction def = this.myDelegate.get(name2);
            if (def != null || name2 == null) {
                return def;
            }
            def = this.myDelegate.get(Case.LOWER.apply(name2));
            return def != null && "true".equals(def.getDialectAttribute("insensitive")) ? def : null;
        }

        @NotNull
        public Iterable<BuiltinFunction> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(2);
            }
            Iterable iterable = this.myDelegate.byMatcher(matcher);
            if (iterable == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(3);
            }
            return iterable;
        }

        @NotNull
        public Collection<BuiltinFunction> forTokens() {
            Collection collection = this.myDelegate.forTokens();
            if (collection == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Nullable
        public SqlLanguageDialectEx.BuiltinFunctions typeMethods(@NotNull String typeName, boolean forInstance) {
            if (typeName == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(5);
            }
            return this.myDelegate.typeMethods(typeName, forInstance);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeDef";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuffixed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "typeMethods";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        static enum Suffix {
            If{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Parameter[] oldParams = p.getParams();
                    boolean broken = oldParams.length != 0 && 1.isGreedy(oldParams[oldParams.length - 1]);
                    BuiltinFunction.Parameter[] params = new BuiltinFunction.Parameter[oldParams.length + (broken ? 1 : 2)];
                    System.arraycopy(oldParams, 0, params, 0, oldParams.length);
                    BuiltinFunction.Parameter[] argSeq = broken ? new BuiltinFunction.Parameter[2] : params;
                    argSeq[argSeq.length - 2] = COMMA.copyWithPrototype(p.getPrototypeId());
                    argSeq[argSeq.length - 1] = COND.copyWithPrototype(p.getPrototypeId());
                    if (broken) {
                        params[params.length - 1] = new BuiltinFunction.ParameterBlock(p.getPrototypeId(), BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE, argSeq, false);
                    }
                    return new BuiltinFunction.Prototype(null, p.getReturnType(), p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }

                private static boolean isGreedy(BuiltinFunction.Parameter param) {
                    if (param.isMany()) {
                        return true;
                    }
                    BuiltinFunction.ParameterBlock block = (BuiltinFunction.ParameterBlock)ObjectUtils.tryCast((Object)param, BuiltinFunction.ParameterBlock.class);
                    if (block == null || block.getBlockType() == BuiltinFunction.ParameterBlockType.CHOICE) {
                        return false;
                    }
                    if (block.getBlockType() == BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE) {
                        return true;
                    }
                    BuiltinFunction.Parameter[] params = block.getParams();
                    return params.length == 0 || 1.isGreedy(params[params.length - 1]);
                }
            }
            ,
            Array{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Parameter[] params = Suffix.makeArrayParams(p.getParams());
                    BuiltinFunction.Type ret = p.getReturnType();
                    if (ret instanceof BuiltinFunction.ParamType) {
                        ret = SqlFunctionsUtil.ANY;
                    }
                    return new BuiltinFunction.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            Map{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Parameter[] params = Suffix.makeMapParams(p.getParams());
                    return new BuiltinFunction.Prototype(null, Types.TUPLE, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            SimpleState{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    return new BuiltinFunction.Prototype(null, Types.SIMPLE_AGGREGATE_FUNCTION, p.getPrototypeId(), p.getHeadBlock(), p.getParams(), p.getAttributes());
                }
            }
            ,
            State{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    return new BuiltinFunction.Prototype(null, Types.AGGREGATE_FUNCTION, p.getPrototypeId(), p.getHeadBlock(), p.getParams(), p.getAttributes());
                }
            }
            ,
            Merge{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Type ret = p.getReturnType();
                    if (ret instanceof BuiltinFunction.ParamType) {
                        ret = SqlFunctionsUtil.ANY;
                    }
                    return new BuiltinFunction.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), new BuiltinFunction.Parameter[]{STATE.copyWithPrototype(p.getPrototypeId())}, p.getAttributes());
                }
            }
            ,
            ForEach{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Parameter[] params = Suffix.makeArrayParams(p.getParams());
                    return new BuiltinFunction.Prototype(null, Types.ARRAY, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            OrDefault{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Type ret = p.getReturnType();
                    BuiltinFunction.Parameter[] params = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            OrNull{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Type ret = p.getReturnType();
                    BuiltinFunction.Parameter[] params = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            Distinct{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p) {
                    BuiltinFunction.Type ret = p.getReturnType();
                    BuiltinFunction.Parameter[] params = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            };

            private static final BuiltinFunction.Parameter COMMA;
            private static final BuiltinFunction.Parameter COND;
            private static final BuiltinFunction.Parameter STATE;
            private final Map<BuiltinFunction, BuiltinFunction> myCache = ConcurrentFactoryMap.create(this::modifyDef, ContainerUtil::createConcurrentSoftValueMap);

            boolean at(String s) {
                return this.name().length() < s.length() && s.endsWith(this.name());
            }

            String trim(String s) {
                return s.substring(0, s.length() - this.name().length());
            }

            BuiltinFunction modify(@NotNull BuiltinFunction def) {
                if (def == null) {
                    Suffix.$$$reportNull$$$0(0);
                }
                return this.myCache.get(def);
            }

            private BuiltinFunction modifyDef(BuiltinFunction def) {
                BuiltinFunction.Prototype[] protos = def.getPrototypes();
                ArrayList<BuiltinFunction.Prototype> newProtos = new ArrayList<BuiltinFunction.Prototype>(protos.length);
                for (BuiltinFunction.Prototype proto : protos) {
                    newProtos.add(this.modifyProto(proto));
                }
                return new BuiltinFunction(def.getName() + this.name(), def.getAliasedFunction(), def.getDialectAttrs(), newProtos, def.getDbms());
            }

            protected abstract BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype var1);

            @NotNull
            private static BuiltinFunction.Parameter[] makeArrayParams(BuiltinFunction.Parameter[] oldParams) {
                BuiltinFunction.Parameter[] parameterArray = (BuiltinFunction.Parameter[])ContainerUtil.map2Array((Object[])oldParams, BuiltinFunction.Parameter.class, param -> Suffix.makeArrayParam(param));
                if (parameterArray == null) {
                    Suffix.$$$reportNull$$$0(1);
                }
                return parameterArray;
            }

            @NotNull
            private static BuiltinFunction.Parameter[] makeMapParams(BuiltinFunction.Parameter[] oldParams) {
                BuiltinFunction.Parameter[] parameterArray = (BuiltinFunction.Parameter[])ContainerUtil.map2Array((Object[])oldParams, BuiltinFunction.Parameter.class, param -> Suffix.makeMapParam(param));
                if (parameterArray == null) {
                    Suffix.$$$reportNull$$$0(2);
                }
                return parameterArray;
            }

            private static BuiltinFunction.Parameter makeArrayParam(BuiltinFunction.Parameter p) {
                if (p instanceof BuiltinFunction.SimpleParameter) {
                    return new BuiltinFunction.SimpleParameter(p.getPrototypeId(), ((BuiltinFunction.SimpleParameter)p).getName(), Types.ARRAY, p.isMany());
                }
                if (p instanceof BuiltinFunction.ParameterBlock) {
                    return new BuiltinFunction.ParameterBlock(p.getPrototypeId(), ((BuiltinFunction.ParameterBlock)p).getBlockType(), Suffix.makeArrayParams(((BuiltinFunction.ParameterBlock)p).getParams()), p.isMany());
                }
                return p;
            }

            private static BuiltinFunction.Parameter makeMapParam(BuiltinFunction.Parameter p) {
                if (p instanceof BuiltinFunction.SimpleParameter) {
                    return new BuiltinFunction.SimpleParameter(p.getPrototypeId(), ((BuiltinFunction.SimpleParameter)p).getName(), Types.TUPLE, p.isMany());
                }
                if (p instanceof BuiltinFunction.ParameterBlock) {
                    return new BuiltinFunction.ParameterBlock(p.getPrototypeId(), ((BuiltinFunction.ParameterBlock)p).getBlockType(), Suffix.makeMapParams(((BuiltinFunction.ParameterBlock)p).getParams()), p.isMany());
                }
                return p;
            }

            @Nullable
            static Suffix find(@NotNull String s) {
                if (s == null) {
                    Suffix.$$$reportNull$$$0(3);
                }
                for (Suffix suffix : Suffix.values()) {
                    if (!suffix.at(s)) continue;
                    return suffix;
                }
                return null;
            }

            static {
                COMMA = new BuiltinFunction.SyntaxParameter(0, ",");
                COND = new BuiltinFunction.SimpleParameter(0, "cond", (BuiltinFunction.Type)INSTANCE.getBuiltInTypes().get("B"), false);
                STATE = new BuiltinFunction.SimpleParameter(0, "state", Types.AGGREGATE_FUNCTION, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "def";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeArrayParams";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeMapParams";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "modify";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "find";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
    }

    static final class Types {
        static final BuiltinFunction.Type ANY_NA = SqlFunctionsUtil.newType((String)"ANY_NA", (DataType)DataTypeFactory.of((String)"any"));
        static final BuiltinFunction.Type STRING_OR_TOKEN = SqlFunctionsUtil.newType((String)"StringOrToken", (DataType)DataTypeFactory.of((String)"String"));
        static final BuiltinFunction.Type STRING_OR_SCHEMA = SqlFunctionsUtil.newType((String)"StringOrSchema", (DataType)DataTypeFactory.of((String)"String"));
        static final BuiltinFunction.Type ARRAY = SqlFunctionsUtil.newType((String)"Array", (DataType)DataTypeFactory.of((String)"Array"));
        static final BuiltinFunction.Type TUPLE = SqlFunctionsUtil.newType((String)"Tuple", (DataType)DataTypeFactory.of((String)"Tuple"));
        static final BuiltinFunction.Type AGGREGATE_FUNCTION = SqlFunctionsUtil.newType((String)"AggregateFunction", (DataType)DataTypeFactory.of((String)"AggregateFunction"));
        static final BuiltinFunction.Type SIMPLE_AGGREGATE_FUNCTION = SqlFunctionsUtil.newType((String)"SimpleAggregateFunction", (DataType)DataTypeFactory.of((String)"SimpleAggregateFunction"));

        Types() {
        }
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{CHouseTypes.CH_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, CHouseOptionalKeywords.CH_SOUNDS);
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects((SqlLanguageDialect)INSTANCE, (String)"fallback.txt");
        static final List<ReservedEntity.Typed> RE_COLUMNS;
        static final List<ReservedEntity> RE_MAP_COLUMNS;
        static final TokenSet SPECIAL_FUNCTION_REFERENCES;

        LazyData() {
        }

        static {
            RE_MAP_COLUMNS = Arrays.asList(new ReservedEntity(Dbms.CLICKHOUSE, "keys", ObjectKind.COLUMN), new ReservedEntity(Dbms.CLICKHOUSE, "values", ObjectKind.COLUMN));
            DasTypeSystemBase typeSystem = DasTypeSystems.getTypeSystem((Dbms)Dbms.CLICKHOUSE);
            RE_COLUMNS = Arrays.asList(new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part", ObjectKind.COLUMN, typeSystem.getStringType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part_index", ObjectKind.COLUMN, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_sample_factor", ObjectKind.COLUMN, typeSystem.getRealType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_table", ObjectKind.COLUMN, typeSystem.getStringType()));
            SPECIAL_FUNCTION_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{CHouseElementTypes.Extra.CH_TABLE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_DATABASE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_CODEC_REFERENCE, CHouseElementTypes.Extra.CH_INDEX_TYPE_REFERENCE, CHouseElementTypes.Extra.CH_DICTIONARY_SOURCE_REFERENCE, CHouseElementTypes.Extra.CH_DICTIONARY_LAYOUT_REFERENCE});
        }
    }

    private static class MyAggColumnDefinition
    extends MyColumnDefinition {
        private final List<PsiElement> myColumns;

        MyAggColumnDefinition(PsiElement parent, String name2, List<PsiElement> columns) {
            super(parent, name2);
            this.myColumns = columns;
        }

        @Override
        @NotNull
        public DasType getDasType() {
            String preName = this.getName();
            ArrayList<MyColumnDefinition> columns = new ArrayList<MyColumnDefinition>(this.myColumns.size());
            for (PsiElement column : this.myColumns) {
                String name2 = column instanceof DasObject ? ((DasObject)column).getName() : "";
                String cName = name2.length() <= preName.length() ? name2 : name2.substring(preName.length() + 1);
                columns.add((MyColumnDefinition)((Object)CachedValuesManager.getCachedValue((PsiElement)column, () -> CachedValueProvider.Result.create((Object)((Object)new MyColumnDefinition(column, cName)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))));
            }
            return new TableBasedSqlTableTypeImpl(columns, (PsiElement)this);
        }
    }

    private static class MyColumnDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        MyColumnDefinition(PsiElement parent, String name2) {
            super(parent, name2);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.CLICKHOUSE;
            if (dbms == null) {
                MyColumnDefinition.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public Language getLanguage() {
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)this.getParent());
            if (sqlLanguageDialectEx == null) {
                MyColumnDefinition.$$$reportNull$$$0(1);
            }
            return sqlLanguageDialectEx;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.getParent();
            if (psiElement == null) {
                MyColumnDefinition.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public boolean isNameQuoted() {
            return false;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnDefinition.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @NotNull
        public DasType getDasType() {
            PsiElement parent = this.getParent();
            DasType dasType = INSTANCE.getTypeSystem().getDasType(null, parent, DasSymbolUtil.getSymbolByPsi((PsiElement)parent));
            if (dasType == null) {
                MyColumnDefinition.$$$reportNull$$$0(4);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return true;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$MyColumnDefinition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

