/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.platform.pratt.PrattBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlWellformednessInspection
extends FtlSuppressableInspection {
    private static final StringPattern NON_ID_PATTERN = PlatformPatterns.string().contains((ElementPattern)PlatformPatterns.not((ElementPattern)PlatformPatterns.or((ElementPattern[])new ElementPattern[]{CharPattern.javaIdentifierPartCharacter(), PlatformPatterns.character().oneOf((Object[])new Character[]{Character.valueOf('.')})})));

    @Nullable
    @Nls
    public static String getWellformednessProblem(String directiveName, FtlDirective directive, boolean forCompletion) {
        if (forCompletion && FtlWellformednessInspection.isExcludedFromCompletion(directiveName)) {
            return "";
        }
        boolean isElse = "else".equals(directiveName);
        PsiElement parent = directive.getParent();
        if (!(!isElse && !"elseIf".equalsIgnoreCase(directiveName) || FtlDirectiveType.isDirective(parent, "if") || !directiveName.equals(directive.getDirectiveName()) && parent != null && FtlDirectiveType.isDirective(parent.getParent(), "if"))) {
            if (FtlDirectiveType.isDirective(parent, "list")) {
                return null;
            }
            return FreeMarkerBundle.message("no.matching.0.directive", "if/list");
        }
        if (isElse && parent instanceof FtlDirective) {
            FtlDirective ftlDirective2 = (FtlDirective)parent;
            List subDirectives = ContainerUtil.findAll((Object[])ftlDirective2.getSubDirectives(), ftlDirective -> "else".equals(ftlDirective.getDirectiveName()) || "elseIf".equalsIgnoreCase(ftlDirective.getDirectiveName()) || ftlDirective == directive);
            int index = subDirectives.indexOf((Object)directive);
            assert (index >= 0);
            if (index != subDirectives.size() - 1) {
                return FreeMarkerBundle.message("else.should.finish.if", new Object[0]);
            }
        }
        if ("case".equals(directiveName) || "default".equals(directiveName)) {
            if (forCompletion && FtlDirectiveType.isDirective(parent, "case")) {
                return null;
            }
            if (!FtlDirectiveType.isDirective(parent, "switch")) {
                return FreeMarkerBundle.message("no.matching.0.directive", "switch");
            }
        }
        if (FtlWellformednessInspection.isDisallowedBreak(directiveName, directive)) {
            return FreeMarkerBundle.message("no.matching.0.directive", "switch/loop");
        }
        if (FtlWellformednessInspection.isDisallowedContinue(directiveName, directive)) {
            return FreeMarkerBundle.message("no.matching.0.directive", "loop");
        }
        if ("sep".equals(directiveName) && FtlWellformednessInspection.findSuperDirective((PsiElement)directive, "list", "items") == null) {
            return FreeMarkerBundle.message("no.matching.0.directive", "loop");
        }
        if ("list".equals(directiveName) && directive instanceof FtlListDirective && !forCompletion) {
            FtlDirective ftlDirective3 = (FtlDirective)((Object)ContainerUtil.find((Object[])directive.getSubDirectives(), child -> FtlDirectiveType.isDirective((PsiElement)child, "items")));
            List<PsiElement> varNames = ((FtlListDirective)directive).getNameElements();
            if (ftlDirective3 == null && varNames.isEmpty()) {
                return FreeMarkerBundle.message("wellformedness.inspection.as.loop.variable.name.missing", new Object[0]);
            }
            if (ftlDirective3 != null && !varNames.isEmpty()) {
                return FreeMarkerBundle.message("wellformedness.inspection.parent.list.of.the.items.must.not.have.as", varNames.get(0).getText());
            }
        }
        if ("noEscape".equalsIgnoreCase(directiveName)) {
            int[] nArray = new int[]{-1};
            FtlWellformednessInspection.processParentDirectives(parent, (Processor<? super FtlXmlTag>)((Processor)ftlDirective -> {
                if (FtlDirectiveType.isDirective((PsiElement)ftlDirective, "escape")) {
                    escapesCount[0] = nArray[0] + 1;
                } else if (FtlDirectiveType.isDirective((PsiElement)ftlDirective, "noEscape")) {
                    escapesCount[0] = nArray[0] - 1;
                }
                return nArray[0] != 0;
            }));
            if (nArray[0] < 0) {
                return FreeMarkerBundle.message("no.matching.0.directive", "escape");
            }
        }
        if ("ftl".equals(directiveName) && FtlWellformednessInspection.isNonInitialDirective(directive)) {
            return FreeMarkerBundle.message("ftl.should.start.file", new Object[0]);
        }
        if ("macro".equals(directiveName) || "function".equals(directiveName)) {
            if (FtlWellformednessInspection.isInsideMacroOrFunction(parent)) {
                return FreeMarkerBundle.message("macro.function.nesting", new Object[0]);
            }
            return null;
        }
        if (("fallback".equals(directiveName) || "nested".equals(directiveName)) && FtlWellformednessInspection.findSuperDirective(parent, "macro") == null) {
            return FreeMarkerBundle.message("can.only.occur.inside", directiveName, "macro");
        }
        if (("return".equals(directiveName) || "local".equals(directiveName)) && FtlWellformednessInspection.findSuperDirective(parent, "function", "macro") == null) {
            return FreeMarkerBundle.message("can.only.occur.inside.or", "#ref", "function", "macro");
        }
        if ("recover".equals(directiveName)) {
            FtlDirective subDirective;
            if (!FtlDirectiveType.isDirective(parent, "attempt")) {
                return FreeMarkerBundle.message("recover.inside.attempt", new Object[0]);
            }
            FtlDirective[] ftlDirectiveArray = ((FtlDirective)parent).getSubDirectives();
            int n = ftlDirectiveArray.length;
            for (int i = 0; i < n && (subDirective = ftlDirectiveArray[i]) != directive; ++i) {
                if (!FtlDirectiveType.isDirective((PsiElement)subDirective, "recover")) continue;
                return FreeMarkerBundle.message("recover.once", new Object[0]);
            }
        }
        if (!forCompletion && "attempt".equals(directiveName)) {
            for (FtlDirective subDirective : directive.getSubDirectives()) {
                if (!FtlDirectiveType.isDirective((PsiElement)subDirective, "recover")) continue;
                return null;
            }
            return FreeMarkerBundle.message("recover.expected", new Object[0]);
        }
        boolean bl = FtlPsiUtil.isUsingCamelCase(directive.getContainingFtlFile());
        if (FtlDirectiveTokenType.getLowerCaseDirectiveNames().contains(directiveName) && bl || !bl && StringUtil.hasUpperCaseChar((String)directiveName)) {
            return FreeMarkerBundle.message("error.mixing.camelcase.lowercase", new Object[0]);
        }
        return null;
    }

    public static boolean isDisallowedBreak(String directiveName, FtlDirective directive) {
        return "break".equals(directiveName) && FtlWellformednessInspection.findSuperDirective((PsiElement)directive, "case", "default", "list", "items") == null;
    }

    private static boolean isDisallowedContinue(String directiveName, FtlDirective directive) {
        if (!"continue".equals(directiveName)) {
            return false;
        }
        FtlDirective loop = FtlWellformednessInspection.findSuperDirective((PsiElement)directive, "list", "items");
        if (loop == null) {
            return true;
        }
        return !"items".equals(loop.getDirectiveName()) && ((FtlListDirective)loop).getNameElements().isEmpty();
    }

    private static boolean isNonInitialDirective(FtlDirective directive) {
        return StringUtil.isNotEmpty((String)directive.getContainingFile().getText().substring(0, directive.getTextRange().getStartOffset()).trim());
    }

    private static boolean isExcludedFromCompletion(String directiveName) {
        return "foreach".equals(directiveName);
    }

    private static boolean isInsideMacroOrFunction(PsiElement parent) {
        return !FtlWellformednessInspection.processParentDirectives(parent, (Processor<? super FtlXmlTag>)((Processor)directive1 -> !FtlDirectiveType.isDirective((PsiElement)directive1, "macro", "function")));
    }

    @Nullable
    private static FtlDirective findSuperDirective(PsiElement element, String ... superDirectiveNames) {
        PsiElement parent = element;
        while (!(parent instanceof PsiFile)) {
            if (FtlDirectiveType.isDirective(parent, superDirectiveNames)) {
                return (FtlDirective)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean processParentDirectives(PsiElement element, Processor<? super FtlXmlTag> processor) {
        PsiElement parent = element;
        while (!(parent instanceof PsiFile)) {
            if (parent instanceof FtlXmlTag && !processor.process((Object)((FtlXmlTag)parent))) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlWellformednessInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                FtlMacro ftlMacro;
                List refs;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof FtlDirective) {
                    FtlDirective directive = (FtlDirective)element;
                    PsiElement nameElement = directive.getStartTagNameElement();
                    if (nameElement == null) {
                        return;
                    }
                    if (directive.needsClosing() && !directive.isClosed()) {
                        holder.registerProblem(nameElement, FreeMarkerBundle.message("unclosed.directive", new Object[0]), new LocalQuickFix[0]);
                        return;
                    }
                    PsiElement endName = directive.getEndTagNameElement();
                    if (endName != null && !endName.textMatches(nameElement)) {
                        holder.registerProblem(endName, PrattBundle.message((String)"0.expected", (Object[])new Object[]{"'" + nameElement.getText() + "'"}), new LocalQuickFix[0]);
                        return;
                    }
                    String message = FtlWellformednessInspection.getWellformednessProblem(nameElement.getText(), directive, false);
                    if (message != null) {
                        holder.registerProblem(nameElement, message, new LocalQuickFix[0]);
                    }
                }
                if (element instanceof FtlMacro && (refs = ContainerUtil.findAll((Object[])(ftlMacro = (FtlMacro)element).getChildren(), FtlExpression.class)).size() == 2) {
                    String startText = ((FtlExpression)refs.get(0)).getText().replaceAll(" ", "");
                    if (!startText.equals(((FtlExpression)refs.get(1)).getText().replaceAll(" ", ""))) {
                        holder.registerProblem((PsiElement)refs.get(1), FreeMarkerBundle.message("wrong.closing.directive.name", new Object[0]), new LocalQuickFix[0]);
                    }
                    if (NON_ID_PATTERN.accepts((Object)startText)) {
                        holder.registerProblem((PsiElement)refs.get(1), PrattBundle.message((String)"0.expected", (Object[])new Object[]{ftlMacro.getText().startsWith("<") ? ">" : "]"}), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlWellformednessInspection$1", "visitElement"));
            }
        };
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlWellformednessInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            FtlWellformednessInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "FtlWellformednessInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlWellformednessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlWellformednessInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

