/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatchingService;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DataSourceConnectionAccessibilityMatchingService;", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatchingService;", "<init>", "()V", "getAccessibilityMatcher", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatcher;", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "DatabaseAccessibilityMatcher", "intellij.database.connectivity"})
public final class DataSourceConnectionAccessibilityMatchingService
implements DBConnectionAccessibilityMatchingService {
    @Nullable
    public DBConnectionAccessibilityMatcher getAccessibilityMatcher(@NotNull DataSourceBriefConfig dsConfig) {
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        return Intrinsics.areEqual((Object)dsConfig.getBoundTo(), (Object)ObjectKind.DATABASE) ? (DBConnectionAccessibilityMatcher)new DatabaseAccessibilityMatcher(dsConfig.isRewriteBounds(), dsConfig.getBoundStr()) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/DataSourceConnectionAccessibilityMatchingService$DatabaseAccessibilityMatcher;", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatcher;", "canSwitchDatabase", "", "driverConnectionBounds", "", "<init>", "(ZLjava/lang/String;)V", "getCanSwitchDatabase", "()Z", "getDriverConnectionBounds", "()Ljava/lang/String;", "isDatabaseAccessible", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getDriverBounds", "intellij.database.connectivity"})
    private static final class DatabaseAccessibilityMatcher
    implements DBConnectionAccessibilityMatcher {
        private final boolean canSwitchDatabase;
        @Nullable
        private final String driverConnectionBounds;

        public DatabaseAccessibilityMatcher(boolean canSwitchDatabase, @Nullable String driverConnectionBounds) {
            this.canSwitchDatabase = canSwitchDatabase;
            this.driverConnectionBounds = driverConnectionBounds;
        }

        public final boolean getCanSwitchDatabase() {
            return this.canSwitchDatabase;
        }

        @Nullable
        public final String getDriverConnectionBounds() {
            return this.driverConnectionBounds;
        }

        public boolean isDatabaseAccessible(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull BasicDatabase database) {
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            if (database.isCurrent() && !this.canSwitchDatabase) {
                return true;
            }
            ObjectPath op = ObjectPaths.of((DasObject)((DasObject)database));
            boolean outOfBounds = JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)connectionPoint, (ObjectPath)op);
            return !outOfBounds;
        }

        @Nullable
        public String getDriverBounds() {
            return this.driverConnectionBounds;
        }

        public boolean canSwitchDatabase() {
            return this.canSwitchDatabase;
        }
    }
}

