/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.ql;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.MultiHostRegistrarPlaceholderHelper;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.data.jpa.ql.language.SpringDataQLLanguage;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.util.ClassSet;

public final class SpringDataFreeQLInjector
implements MultiHostInjector {
    @NonNls
    public static final String QUERY_ANNOTATION = "org.springframework.data.jpa.repository.Query";
    @NonNls
    public static final String NATIVE_QUERY_ANNOTATION = "org.springframework.data.jpa.repository.NativeQuery";
    public static final Set<String> QUERY_ANNOTATIONS = Set.of("org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.NativeQuery");
    @NotNull
    private static final @NotNull ClassSet<@NotNull PsiElement> SOURCE_TYPES = UastFacade.INSTANCE.getPossiblePsiSourceTypes(new Class[]{UInjectionHost.class, UPolyadicExpression.class});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(1);
        }
        if (PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID) && SOURCE_TYPES.contains(host.getClass())) {
            UStringConcatenationsFacade concatenationsFacade = UStringConcatenationsFacade.getConcatenationsFacade((PsiElement)host);
            if (concatenationsFacade == null) {
                return;
            }
            if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
                return;
            }
            Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
            PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)hosts);
            if (theFirstHost != null && this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
                Language languageToInject = SpringDataFreeQLInjector.getLanguageToInject(theFirstHost);
                if (languageToInject == null) {
                    return;
                }
                MultiHostRegistrarPlaceholderHelper qlHostRegistrar = new MultiHostRegistrarPlaceholderHelper(registrar).startInjecting(languageToInject);
                qlHostRegistrar.addGlobalPlaceholders((Iterable)concatenationsFacade.getPlaceholders());
                for (PsiLanguageInjectionHost operand : SequencesKt.asIterable((Sequence)hosts)) {
                    registrar.addPlace("", "", operand, ElementManipulators.getValueTextRange((PsiElement)operand));
                }
                qlHostRegistrar.doneInjecting();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        UInjectionHost uElement = (UInjectionHost)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
        @NotNull @Nullable Pair entry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uElement);
        if (entry == null) {
            return null;
        }
        if (QUERY_ANNOTATION.equals(((PsiAnnotation)entry.getFirst()).getQualifiedName())) {
            return SpringDataFreeQLInjector.isNativeQueryValue((PsiAnnotation)entry.getFirst()) ? Language.findLanguageByID((String)"SQL") : SpringDataQLLanguage.INSTANCE;
        }
        if (NATIVE_QUERY_ANNOTATION.equals(((PsiAnnotation)entry.getFirst()).getQualifiedName())) {
            return Language.findLanguageByID((String)"SQL");
        }
        return null;
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(2);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "count".equals(annotationParamName))) {
            UAnnotation annotation = (UAnnotation)annotationEntry.getFirst();
            return !host.getProject().isDefault() && SpringDataFreeQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isNativeQueryValue(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(3);
        }
        if (annotation.getProject().isDefault()) {
            return false;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return false;
        }
        Boolean value = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"nativeQuery");
        return value != null && value != false;
    }

    private static boolean isQueryAnnotation(@NotNull UAnnotation psiAnnotation) {
        String name;
        if (psiAnnotation == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(4);
        }
        return (name = psiAnnotation.getQualifiedName()) != null && QUERY_ANNOTATIONS.contains(name);
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List list = SOURCE_TYPES.toList();
        if (list == null) {
            SpringDataFreeQLInjector.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/jpa/ql/SpringDataFreeQLInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/jpa/ql/SpringDataFreeQLInjector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNativeQueryValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

