/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc.gen;

import com.intellij.lang.typescript.tsc.gen.NodeImpl;
import com.intellij.lang.typescript.tsc.gen.TscObject;
import com.intellij.lang.typescript.tsc.gen.TscObjectKt;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J&\u0010\t\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J*\u0010\u000f\u001a\u00060\fj\u0002`\r2\n\u0010\u0010\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J.\u0010\u0011\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J,\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\f0\f2\n\u0010\u0010\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J,\u0010\u0015\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J(\u0010\u0018\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J?\u0010\u001b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001e\u0012\b\b\u0012\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J,\u0010 \u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0002J\u001c\u0010#\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J(\u0010$\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u001c\u0010'\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\u00020\n*\u00020\n2\u0006\u0010+\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/lang/typescript/tsc/gen/TscObjectPrinter;", "", "<init>", "()V", "recursionLevel", "Ljava/lang/ThreadLocal;", "", "stack", "", "printValue", "", "value", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "printValueImpl", "builder", "printProperty", "name", "printRecursiveValue", "kotlin.jvm.PlatformType", "printMap", "map", "", "printCollection", "list", "", "printObject", "printer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "", "printPair", "pair", "Lkotlin/Pair;", "indent", "printTscObject", "object", "Lcom/intellij/lang/typescript/tsc/gen/TscObject;", "printTypeCheckerContext", "context", "Lcom/intellij/lang/typescript/tsc/gen/TypeScriptServerTypeCheckerContext;", "ellipsis", "maxLength", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTscObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TscObject.kt\ncom/intellij/lang/typescript/tsc/gen/TscObjectPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,143:1\n1869#2,2:144\n1056#2:154\n52#3:146\n536#4:147\n521#4,6:148\n*S KotlinDebug\n*F\n+ 1 TscObject.kt\ncom/intellij/lang/typescript/tsc/gen/TscObjectPrinter\n*L\n101#1:144,2\n89#1:154\n131#1:146\n131#1:147\n131#1:148,6\n*E\n"})
final class TscObjectPrinter {
    @NotNull
    private final ThreadLocal<Integer> recursionLevel = new ThreadLocal();
    @NotNull
    private final Set<Object> stack = new LinkedHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String printValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Integer currentRecursionLevel = this.recursionLevel.get();
        if (currentRecursionLevel != null && currentRecursionLevel >= 2) {
            return "<recursive value of class " + value.getClass().getSimpleName() + ">";
        }
        Integer n = currentRecursionLevel;
        this.recursionLevel.set((n != null ? n : 0) + 1);
        try {
            String string = this.printValue(new StringBuilder(), 0, value).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            return string2;
        }
        finally {
            this.recursionLevel.set(currentRecursionLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final StringBuilder printValue(StringBuilder $this$printValue, int level, Object value) {
        StringBuilder stringBuilder;
        if (value != null && !this.stack.add(value)) {
            StringBuilder stringBuilder2 = this.printRecursiveValue($this$printValue, level, value);
            stringBuilder = stringBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"printRecursiveValue(...)");
        } else {
            StringBuilder stringBuilder3;
            try {
                stringBuilder3 = this.printValueImpl($this$printValue, level, value);
            }
            finally {
                TypeIntrinsics.asMutableCollection((Object)this.stack).remove(value);
            }
            stringBuilder = stringBuilder3;
        }
        return stringBuilder;
    }

    private final StringBuilder printValueImpl(StringBuilder builder2, int level, Object value) {
        StringBuilder stringBuilder;
        Object object = value;
        if (object instanceof String) {
            StringBuilder stringBuilder2 = builder2.append("\"").append(this.ellipsis((String)value, 200)).append("\"");
            stringBuilder = stringBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        } else if (object instanceof Collection) {
            stringBuilder = this.printCollection(builder2, level, (Collection)value);
        } else if (object instanceof Map) {
            stringBuilder = this.printMap(builder2, level, (Map)value);
        } else if (object instanceof Pair) {
            stringBuilder = this.printPair(builder2, level, (Pair)value);
        } else if (object instanceof TscObject) {
            stringBuilder = this.printTscObject(builder2, level, (TscObject)value);
        } else if (object instanceof TypeScriptServerTypeCheckerContext) {
            stringBuilder = this.printTypeCheckerContext(builder2, (TypeScriptServerTypeCheckerContext)value);
        } else if (object == null) {
            StringBuilder stringBuilder3 = builder2.append("<null>");
            stringBuilder = stringBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        } else {
            StringBuilder stringBuilder4 = builder2.append(value);
            stringBuilder = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        }
        return stringBuilder;
    }

    private final StringBuilder printProperty(StringBuilder $this$printProperty, int level, String name, Object value) {
        if (value == null) {
            return $this$printProperty;
        }
        StringBuilder stringBuilder = this.indent($this$printProperty, level).append(name).append(": ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        this.printValue(stringBuilder, level, value).append(",\n");
        return $this$printProperty;
    }

    private final StringBuilder printRecursiveValue(StringBuilder builder2, int level, Object value) {
        return builder2.append("<recursive value of class " + value.getClass().getSimpleName() + ">");
    }

    private final StringBuilder printMap(StringBuilder $this$printMap, int level, Map<?, ?> map) {
        return this.printObject($this$printMap, level, (Function1<? super Integer, Unit>)((Function1)arg_0 -> TscObjectPrinter.printMap$lambda$0(map, this, $this$printMap, arg_0)));
    }

    private final StringBuilder printCollection(StringBuilder $this$printCollection, int level, Collection<?> list) {
        $this$printCollection.append("[");
        if (list.isEmpty()) {
            v0 = $this$printCollection.append("]");
        } else {
            $this$printCollection.append('\n');
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                this.printValue(this.indent($this$printCollection, level + 1), level + 1, it).append(",\n");
            }
            v0 = this.indent($this$printCollection, level).append("]");
        }
        return $this$printCollection;
    }

    private final StringBuilder printObject(StringBuilder $this$printObject, int level, Function1<? super Integer, Unit> printer) {
        $this$printObject.append("{\n");
        printer.invoke((Object)(level + 1));
        this.indent($this$printObject, level).append("}");
        return $this$printObject;
    }

    private final StringBuilder printPair(StringBuilder $this$printPair, int level, Pair<?, ?> pair) {
        Pair[] pairArray = new Pair[]{new Pair((Object)"first", pair.getFirst()), new Pair((Object)"second", pair.getSecond())};
        return this.printMap($this$printPair, level, MapsKt.mapOf((Pair[])pairArray));
    }

    private final StringBuilder indent(StringBuilder $this$indent, int level) {
        StringBuilder stringBuilder = $this$indent.append(StringsKt.repeat((CharSequence)" ", (int)level));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder printTscObject(StringBuilder $this$printTscObject, int level, TscObject<?> object) {
        StringBuilder stringBuilder = $this$printTscObject.append("<");
        String string = object.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"Impl")).append("> ");
        if (level > 3 && !(object instanceof NodeImpl)) {
            v2 = $this$printTscObject.append("{\u2026}");
        } else {
            Map map;
            TscObjectPrinter tscObjectPrinter = this;
            StringBuilder stringBuilder2 = $this$printTscObject;
            int n = level;
            Map<?, Object> map2 = object.getData().copyAsMap();
            boolean condition$iv = level > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$filterTo$iv$iv;
                void $this$printTscObject_u24lambda_u240;
                void var7_7 = $this$applyIf$iv;
                int n2 = n;
                StringBuilder stringBuilder3 = stringBuilder2;
                TscObjectPrinter tscObjectPrinter2 = tscObjectPrinter;
                boolean bl = false;
                void $this$filter$iv = $this$printTscObject_u24lambda_u240;
                boolean $i$f$filter = false;
                void var11_14 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(!TscObjectKt.access$getKeysToFilterOutFromToString$p().contains(it.getKey()))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map3 = destination$iv$iv;
                tscObjectPrinter = tscObjectPrinter2;
                stringBuilder2 = stringBuilder3;
                n = n2;
                map = map3;
            } else {
                map = $this$applyIf$iv;
            }
            v2 = tscObjectPrinter.printMap(stringBuilder2, n, map);
        }
        return $this$printTscObject;
    }

    private final StringBuilder printTypeCheckerContext(StringBuilder $this$printTypeCheckerContext, TypeScriptServerTypeCheckerContext context2) {
        StringBuilder stringBuilder = $this$printTypeCheckerContext.append("{ project=").append(context2.getIdeProjectId()).append(", typeChecker=").append(context2.getIdeTypeCheckerId()).append(" }");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        return stringBuilder;
    }

    private final String ellipsis(String $this$ellipsis, int maxLength) {
        String string = $this$ellipsis.substring(0, RangesKt.coerceAtMost((int)$this$ellipsis.length(), (int)maxLength));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + ($this$ellipsis.length() > maxLength ? "\u2026" : "");
    }

    private static final Unit printMap$lambda$0(Map $map, TscObjectPrinter this$0, StringBuilder $this_printMap, int it) {
        Iterable $this$sortedBy$iv = $map.entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)String.valueOf(it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)String.valueOf(it.getKey()))));
            }
        })) {
            this$0.printProperty($this_printMap, it, String.valueOf(entry.getKey()), entry.getValue());
        }
        return Unit.INSTANCE;
    }
}

