/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.AutoRotationSliderEdgeLabelModel;
import com.intellij.openapi.graph.view.BridgeCalculator;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultGraph2DRenderer;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class BasicGraphPresentationModel<N, E>
extends GraphPresentationModel<N, E> {
    @NotNull
    public static final String USE_ANTIALIAING_REGKEY = "diagrams.rendering.antialiasing";
    @NotNull
    private volatile Graph myGraph;
    @Nullable
    private volatile GraphBuilder<N, E> myGraphBuilder;
    @NotNull
    private final GraphSettings mySettings;
    @NotNull
    protected final AtomicBoolean myIsDisposed;

    public BasicGraphPresentationModel(@NotNull Graph graph) {
        if (graph == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(0);
        }
        this.mySettings = new GraphSettings();
        this.myIsDisposed = new AtomicBoolean(false);
        this.myGraph = graph;
    }

    public BasicGraphPresentationModel(@NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(1);
        }
        this.mySettings = new GraphSettings();
        this.myIsDisposed = new AtomicBoolean(false);
        this.myGraph = graphBuilder.getGraph();
        this.myGraphBuilder = graphBuilder;
    }

    @NotNull
    public Graph getGraph() {
        Graph graph = this.myGraph;
        if (graph == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(2);
        }
        return graph;
    }

    public void setGraph(@NotNull Graph graph) {
        if (graph == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(3);
        }
        this.myGraph = graph;
    }

    @NotNull
    public GraphBuilder<N, E> getGraphBuilder() {
        GraphBuilder<N, E> builder = this.myGraphBuilder;
        assert (builder != null) : "Forgot to set graphBuilder";
        GraphBuilder<N, E> graphBuilder = builder;
        if (graphBuilder == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(4);
        }
        return graphBuilder;
    }

    public void setGraphBuilder(@NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(5);
        }
        this.myGraphBuilder = graphBuilder;
    }

    @Override
    @NotNull
    public GraphSettings getSettings() {
        GraphSettings graphSettings = this.mySettings;
        if (graphSettings == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(6);
        }
        return graphSettings;
    }

    @Override
    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable N n) {
        Graph2DNodeRealizer graph2DNodeRealizer = GraphManager.getGraphManager().createGraph2DNodeRealizer();
        if (graph2DNodeRealizer == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(7);
        }
        return graph2DNodeRealizer;
    }

    @Override
    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable E e) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        edgeRealizer.setLineColor((Color)JBColor.GRAY);
        edgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(8);
        }
        return polyLineEdgeRealizer;
    }

    @Override
    @Nullable
    public String getNodeTooltip(@Nullable N n) {
        return null;
    }

    @Override
    @Nullable
    public String getEdgeTooltip(@Nullable E e) {
        return null;
    }

    @Override
    public boolean editNode(@Nullable N n) {
        return false;
    }

    @Override
    public boolean editEdge(@Nullable E e) {
        return false;
    }

    @Override
    @Nullable
    public NodeCellEditor getCustomNodeCellEditor(@Nullable N n) {
        return null;
    }

    @Override
    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable N n) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public DefaultActionGroup getEdgeActionGroup(@Nullable E e) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public DefaultActionGroup getPaperActionGroup() {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    @NotNull
    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(AbstractGraphAction.getCommonPopupActions());
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(12);
        }
        return defaultActionGroup;
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
            Set configurations = factory.getAvailableConfigurations();
            for (Object object : ArrayUtil.toObjectArray((Collection)configurations)) {
                if (!(object instanceof String)) continue;
                factory.removeConfiguration((String)object);
            }
        }
    }

    @Override
    public EdgeLabel @NotNull [] getEdgeLabels(@Nullable E e, @NotNull String edgeName) {
        if (edgeName == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(13);
        }
        EdgeLabel label = this.createLabel(edgeName);
        if (this.isAutoRotateLabels()) {
            AutoRotationSliderEdgeLabelModel labelModel = GraphManager.getGraphManager().createAutoRotationSliderEdgeLabelModel();
            labelModel.setDistance(-15.0);
            label.setLabelModel(labelModel);
            label.setModelParameter(labelModel.getDefaultParameter());
        }
        EdgeLabel[] edgeLabelArray = new EdgeLabel[]{label};
        if (edgeLabelArray == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(14);
        }
        return edgeLabelArray;
    }

    @NotNull
    protected EdgeLabel createLabel(@NotNull String edgeName) {
        if (edgeName == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(15);
        }
        EdgeLabel label = GraphManager.getGraphManager().createEdgeLabel(edgeName, EdgeLabel.TWO_POS);
        label.setPosition(EdgeLabel.HEAD);
        label.setFontSize(10);
        label.setFontStyle(2);
        EdgeLabel edgeLabel = label;
        if (edgeLabel == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(16);
        }
        return edgeLabel;
    }

    @Nullable
    public BridgeCalculator createBridgeCalculator() {
        BridgeCalculator bridgeCalculator = GraphManager.getGraphManager().createBridgeCalculator();
        bridgeCalculator.setCrossingStyle(BridgeCalculator.CROSSING_STYLE_ARC);
        bridgeCalculator.setCrossingMode(BridgeCalculator.CROSSING_MODE_HORIZONTAL_CROSSES_VERTICAL);
        bridgeCalculator.setOrientationStyle(BridgeCalculator.ORIENTATION_STYLE_UP);
        bridgeCalculator.setBridgeWidth(10.0);
        return bridgeCalculator;
    }

    public void setupBridgesFor(@NotNull Graph2DRenderer backgroundRenderer) {
        if (backgroundRenderer == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(17);
        }
        if (backgroundRenderer instanceof DefaultGraph2DRenderer) {
            BridgeCalculator bridgeCalculator = this.getSettings().isShowBridges() ? this.createBridgeCalculator() : null;
            ((DefaultGraph2DRenderer)backgroundRenderer).setBridgeCalculator(bridgeCalculator);
        }
    }

    @NotNull
    public GraphBuilderDisplay getGraphViewDisplay() {
        throw new UnsupportedOperationException();
    }

    @Override
    @RequiresEdt
    public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
        if (view == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(18);
        }
        if (editMode == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.customizeSettings(this.getGraphBuilder());
    }

    @Override
    public void customizeSettings(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(20);
        }
        Graph2DView view = builder.getView();
        view.setAntialiasedPainting(Registry.is((String)USE_ANTIALIAING_REGKEY));
        BasicGraphPresentationModel.setupNonAntialiasedBackgroundRenderer(view);
        GraphLayoutService.getInstance().setupDataProvidersForEdgesMerging(builder);
    }

    @Override
    @NotNull
    public EdgeCreationPolicy<N> getEdgeCreationPolicy() {
        EdgeCreationPolicy<?> edgeCreationPolicy = EdgeCreationPolicy.EVERYTHING_ACCEPTED_POLICY;
        if (edgeCreationPolicy == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(21);
        }
        return edgeCreationPolicy;
    }

    @Override
    @Nullable
    public DeleteProvider<?, ?> getDeleteProvider() {
        return null;
    }

    public boolean isAutoRotateLabels() {
        return false;
    }

    @Override
    @NotNull
    public String getActionPlace() {
        return "EditorPopup";
    }

    public static void setupNonAntialiasedBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BasicGraphPresentationModel.$$$reportNull$$$0(22);
        }
        DefaultBackgroundRenderer oldRenderer = (DefaultBackgroundRenderer)view.getBackgroundRenderer();
        DefaultBackgroundRenderer newRenderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        newRenderer.setColor(oldRenderer.getColor());
        newRenderer.setMode(oldRenderer.getMode());
        view.setBackgroundRenderer(newRenderer);
        view.addBackgroundDrawable(new Drawable(){

            @Override
            public void paint(Graphics2D g) {
                if (Registry.is((String)BasicGraphPresentationModel.USE_ANTIALIAING_REGKEY)) {
                    GraphicsUtil.setupAAPainting((Graphics)g);
                }
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, 0, 0, 0);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 8, 9, 10, 11, 12, 14, 16, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BasicGraphPresentationModel";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundRenderer";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BasicGraphPresentationModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActionGroup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeActionGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaperActionGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonActionGroup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeCreationPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGraph";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setGraphBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeLabels";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupBridgesFor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupNonAntialiasedBackgroundRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 8, 9, 10, 11, 12, 14, 16, 21 -> new IllegalStateException(string);
        };
    }
}

