/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.okhttp;

import com.intellij.httpClient.okhttp.minimal.builder.analysis.OkHttpBuilderAnalysisUtilsKt;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.httpUrl.HttpUrl;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.Request;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.RequestBuilderEvaluatorKt;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.RequestEvaluationStrategy;
import com.intellij.microservices.jvm.okhttp.OkHttpUrl;
import com.intellij.microservices.jvm.okhttp.OkHttpUrlBuilderKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.analysis.UNeDfaValueEvaluator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/jvm/okhttp/OkHttpUrlBuilder;", "", "<init>", "()V", "collectUrls", "", "Lcom/intellij/microservices/jvm/okhttp/OkHttpUrl;", "node", "Lorg/jetbrains/uast/UCallExpression;", "argumentExpression", "Lcom/intellij/psi/PsiElement;", "methodName", "", "isRequestCallExist", "", "containingFile", "Lcom/intellij/psi/PsiFile;", "intellij.microservices.jvm.okhttp"})
public final class OkHttpUrlBuilder {
    @NotNull
    public static final OkHttpUrlBuilder INSTANCE = new OkHttpUrlBuilder();

    private OkHttpUrlBuilder() {
    }

    @NotNull
    public final List<OkHttpUrl> collectUrls(@NotNull UCallExpression node, @NotNull PsiElement argumentExpression, @NotNull String methodName) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)argumentExpression, (String)"argumentExpression");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        PsiFile psiFile = argumentExpression.getContainingFile();
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile containingFile = psiFile;
        if (this.isRequestCallExist(methodName, node, containingFile)) {
            return CollectionsKt.emptyList();
        }
        Object url = OkHttpBuilderAnalysisUtilsKt.collectUrlInformation((UCallExpression)node, (PsiFile)containingFile);
        Object object = url;
        if (object instanceof Request) {
            pair = TuplesKt.to((Object)((Request)url).getUrl(), (Object)((Request)url).getMethod());
        } else if (object instanceof HttpUrl) {
            pair = TuplesKt.to((Object)url, null);
        } else {
            return CollectionsKt.emptyList();
        }
        Pair pair2 = pair;
        HttpUrl httpUrl = (HttpUrl)pair2.component1();
        Set methods = (Set)pair2.component2();
        return OkHttpUrlBuilderKt.access$toOkHttpUrls(httpUrl, methods);
    }

    private final boolean isRequestCallExist(String methodName, UCallExpression node, PsiFile containingFile) {
        Object[] objectArray = new String[]{"parse", "newBuilder", "get"};
        return CollectionsKt.listOf((Object[])objectArray).contains(methodName) && new UNeDfaValueEvaluator((UNeDfaValueEvaluator.UValueEvaluatorStrategy)RequestEvaluationStrategy.INSTANCE).canBeDependencyForBuilderOfThisEvaluator((UElement)node, RequestBuilderEvaluatorKt.requestEvaluationConfiguration((PsiFile)containingFile));
    }
}

