/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.openapi.impl.RenameRefactoringImpl;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ClassNameDiffersFromFileNamePredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public final class RenameFileWithClassIntention
extends Intention
implements Consumer<GrTypeDefinition> {
    private String myNewFileName = null;

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            RenameFileWithClassIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RenameFileWithClassIntention.$$$reportNull$$$0(1);
        }
        PsiFile file = element.getContainingFile();
        new RenameRefactoringImpl(project, (PsiElement)file, this.myNewFileName, true, true).run();
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("rename.file.to.0", this.myNewFileName);
        if (string == null) {
            RenameFileWithClassIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ClassNameDiffersFromFileNamePredicate(this);
    }

    public void consume(GrTypeDefinition def) {
        String name = def.getName();
        PsiFile file = def.getContainingFile();
        this.myNewFileName = name + "." + FileUtilRt.getExtension((String)file.getName());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/RenameFileWithClassIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/RenameFileWithClassIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

