/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.CheckUptodatenessIntrospectionTask;
import com.intellij.database.introspection.DatabaseVisitPolicy;
import com.intellij.database.introspection.GeneralIntrospectionTask;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoaderContext {
    private static final Logger LOG = Logger.getInstance(LoaderContext.class);
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final boolean mySkip;
    private final List<IntrospectionTask> myTasks;
    private final IntrospectionScopeUpdater myScopeUpdater;
    private ErrorHandler myErrorHandler;
    private DatabaseCredentials myCredentialsStore;

    public static LoaderContext selectTask(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull IntrospectionTask task) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(1);
        }
        if (task == null) {
            LoaderContext.$$$reportNull$$$0(2);
        }
        return new LoaderContext(project, dataSource, task);
    }

    public static LoaderContext selectTasks(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Collection<? extends IntrospectionTask> tasks) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(4);
        }
        if (tasks == null) {
            LoaderContext.$$$reportNull$$$0(5);
        }
        return new LoaderContext(project, dataSource, tasks);
    }

    public static LoaderContext selectTasks(@NotNull Project project, @NotNull LocalDataSource dataSource, IntrospectionTask ... tasks) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(7);
        }
        if (tasks == null) {
            LoaderContext.$$$reportNull$$$0(8);
        }
        return new LoaderContext(project, dataSource, Arrays.asList(tasks));
    }

    public static LoaderContext selectGeneralTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(9);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(10);
        }
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask(dataSource.getUniqueId());
        return LoaderContext.selectTask(project, dataSource, task);
    }

    public static LoaderContext selectListNamespacesTask(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseVisitPolicy policy) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(11);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(12);
        }
        if (policy == null) {
            LoaderContext.$$$reportNull$$$0(13);
        }
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareBriefTask(dataSource.getUniqueId(), policy);
        return LoaderContext.selectTask(project, dataSource, task);
    }

    public static LoaderContext selectListNamespacesTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(14);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(15);
        }
        return LoaderContext.selectListNamespacesTask(project, dataSource, DatabaseVisitPolicy.ByIntrospectionScope.INSTANCE);
    }

    @Deprecated(forRemoval=true)
    public static LoaderContext selectNothing(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(16);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(17);
        }
        return new LoaderContext(project, dataSource, false);
    }

    @ApiStatus.Internal
    public static LoaderContext selectSkip(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(18);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(19);
        }
        return new LoaderContext(project, dataSource, true);
    }

    private LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull IntrospectionTask task) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(20);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(21);
        }
        if (task == null) {
            LoaderContext.$$$reportNull$$$0(22);
        }
        this.myTasks = new ArrayList<IntrospectionTask>();
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myErrorHandler = new ErrorHandler();
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myTasks.add(task);
        this.mySkip = false;
    }

    private LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Collection<? extends IntrospectionTask> tasks) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(23);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(24);
        }
        if (tasks == null) {
            LoaderContext.$$$reportNull$$$0(25);
        }
        this.myTasks = new ArrayList<IntrospectionTask>();
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myErrorHandler = new ErrorHandler();
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myTasks.addAll(tasks);
        this.mySkip = false;
    }

    private LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource, boolean skip) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(26);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(27);
        }
        this.myTasks = new ArrayList<IntrospectionTask>();
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myErrorHandler = new ErrorHandler();
        this.myProject = project;
        this.myDataSource = dataSource;
        this.mySkip = skip;
    }

    @NotNull
    public LoaderContext merge(@NotNull LoaderContext that) {
        if (that == null) {
            LoaderContext.$$$reportNull$$$0(28);
        }
        if (that.mySkip || that.isEmpty()) {
            LoaderContext loaderContext = this;
            if (loaderContext == null) {
                LoaderContext.$$$reportNull$$$0(29);
            }
            return loaderContext;
        }
        if (this.mySkip || this.isEmpty()) {
            LoaderContext loaderContext = that;
            if (loaderContext == null) {
                LoaderContext.$$$reportNull$$$0(30);
            }
            return loaderContext;
        }
        if (this.myProject != that.myProject || this.myDataSource != that.myDataSource) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Merging different contexts");
            } else {
                LOG.warn("Merging different contexts");
            }
        }
        LoaderContext newContext = new LoaderContext(this.myProject, this.myDataSource, this.myTasks);
        newContext.myTasks.addAll(that.myTasks);
        newContext.myScopeUpdater.addAll(this.myScopeUpdater).addAll(that.myScopeUpdater);
        LoaderContext loaderContext = newContext;
        if (loaderContext == null) {
            LoaderContext.$$$reportNull$$$0(31);
        }
        return loaderContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(32);
        }
        return project;
    }

    @NotNull
    public List<IntrospectionTask> getTasks() {
        List<IntrospectionTask> list = Collections.unmodifiableList(this.myTasks);
        if (list == null) {
            LoaderContext.$$$reportNull$$$0(33);
        }
        return list;
    }

    public int countTasks() {
        return this.myTasks.size();
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            LoaderContext.$$$reportNull$$$0(34);
        }
        return introspectionScopeUpdater;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            LoaderContext.$$$reportNull$$$0(35);
        }
        return localDataSource;
    }

    public Dbms getDbms() {
        return this.myDataSource.getDbms();
    }

    @Nullable
    public BasicModel getBasicModel() {
        DasModel m = this.myDataSource.getModel();
        return m instanceof BasicModel ? (BasicModel)m : null;
    }

    @Nullable
    public BasicDatabase getDefaultDatabase() {
        BasicModel model = this.getBasicModel();
        if (model == null) {
            return null;
        }
        BasicRoot root = model.getRoot();
        if (root instanceof BasicDatabase) {
            return (BasicDatabase)((Object)root);
        }
        if (root instanceof BasicMultiDatabaseRoot) {
            return ((BasicMultiDatabaseRoot)root).getCurrentDatabase();
        }
        return null;
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public boolean isAllowedToChangeDsSettings() {
        if (this.myDataSource.isTemporary()) {
            return true;
        }
        if (this.myDataSource.getAdditionalProperty("FORCE_SCOPE_BOOTSTRAP") != null) {
            return true;
        }
        for (IntrospectionTask task : this.myTasks) {
            if (!(task instanceof GeneralIntrospectionTask)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutdatedCheck() {
        for (IntrospectionTask task : this.myTasks) {
            if (task instanceof CheckUptodatenessIntrospectionTask) continue;
            return false;
        }
        return true;
    }

    public void withCredentials(@Nullable DatabaseCredentials credentialsStore) {
        this.myCredentialsStore = credentialsStore;
    }

    @Nullable
    public DatabaseCredentials getCredentialsStore() {
        return this.myCredentialsStore;
    }

    public boolean isEmpty() {
        return this.myTasks.isEmpty();
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LoaderContext");
        if (!this.myTasks.isEmpty()) {
            int n = this.myTasks.size();
            b.append(" with ").append(n).append(' ').append(StringUtil.pluralize((String)"task", (int)n)).append(':');
            StringUtil.join(this.myTasks, t -> "\n\t-> " + t.toString().replace("\n", "\n\t"), (String)"", (StringBuilder)b);
        } else {
            b.append(" is empty");
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 29, 30, 31, 32, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/LoaderContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/LoaderContext";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeUpdater";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectTask";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectTasks";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectGeneralTask";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectListNamespacesTask";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectNothing";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "selectSkip";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 29, 30, 31, 32, 33, 34, 35 -> new IllegalStateException(string);
        };
    }
}

