/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.creating;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookEditorCreatedCallback;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.projectModel.ExternalBuildSystemUtilsKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookPerFileSettingsCache;
import com.intellij.kotlin.jupyter.core.statistics.fus.KotlinNotebookFeatureUsagesCollector;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/creating/KotlinNotebookEditorFactoryListener;", "Lcom/intellij/jupyter/core/editor/NotebookEditorCreatedCallback;", "<init>", "()V", "editorCreated", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookEditorFactoryListener
implements NotebookEditorCreatedCallback {
    public void editorCreated(@NotNull Editor editor) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            if (!JupyterEditorExtensionsKt.isJupyter((Editor)editor)) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            if (!IsKotlinNotebookKt.isKotlinNotebook(file)) {
                return;
            }
            KotlinNotebookPerFileSettingsCache.Companion.getInstance(project2).notebookEditorCreated(file);
            BackedNotebookVirtualFile notebookFile = UtilKt.toBackedNotebookFile(file);
            KotlinNotebookFeatureUsagesCollector.Companion.registerOpenNotebook(project2, notebookFile);
            JupyterNotebook jupyterNotebook = notebookFile.getNotebookOrNull();
            if (jupyterNotebook == null) break block4;
            ExternalBuildSystemUtilsKt.showKernelAndModuleJdkAreMatchingWarningIfNeeded(jupyterNotebook, project2);
        }
    }
}

