/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.settings;

import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.settings.KubernetesSettingsPanel;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesProxySettingsTable;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesSettingsPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "customContextParametersTableView", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$ContextCustomProxyParameter;", "autoDetectAppendServerPathJBCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "value", "", "autoDetectServerPath", "getAutoDetectServerPath", "()Z", "setAutoDetectServerPath", "(Z)V", "isModified", "getParametersSet", "Ljava/util/SortedSet;", "apply", "", "reset", "ContextColumnInfo", "ParametersColumnInfo", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesProxySettingsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesProxySettingsTable.kt\ncom/intellij/kubernetes/view/ui/settings/KubernetesProxySettingsTable\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,138:1\n19#2:139\n434#3:140\n507#3,5:141\n*S KotlinDebug\n*F\n+ 1 KubernetesProxySettingsTable.kt\ncom/intellij/kubernetes/view/ui/settings/KubernetesProxySettingsTable\n*L\n78#1:139\n99#1:140\n99#1:141,5\n*E\n"})
public final class KubernetesProxySettingsTable
extends KubernetesSettingsPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TableView<KubernetesApiSettings.ContextCustomProxyParameter> customContextParametersTableView;
    @NotNull
    private final JBCheckBox autoDetectAppendServerPathJBCheckBox;

    public KubernetesProxySettingsTable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.customContextParametersTableView = new TableView();
        this.autoDetectAppendServerPathJBCheckBox = new JBCheckBox(KubernetesBundle.message((String)"checkbox.auto.detect.insert.flag.append.server.path.parameter.for.kubectl.in.this.project", (Object[])new Object[0]));
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 1));
        checkboxPanel.add((Component)this.autoDetectAppendServerPathJBCheckBox);
        this.add((Component)checkboxPanel, "North");
        this.customContextParametersTableView.setShowGrid(false);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ContextColumnInfo(), new ParametersColumnInfo()};
        this.customContextParametersTableView.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
        StatusText statusText = this.customContextParametersTableView.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        StatusText emptyText = statusText;
        emptyText.clear();
        emptyText.appendLine(KubernetesBundle.message((String)"KubernetesProxySettingsTable.CustomContextConfigurations.emptyText.line1", (Object[])new Object[0]));
        emptyText.appendLine(KubernetesBundle.message((String)"KubernetesProxySettingsTable.CustomContextConfigurations.emptyText.line2", (Object[])new Object[0]));
        this.add((Component)ToolbarDecorator.createDecorator((JTable)((JTable)this.customContextParametersTableView)).disableUpDownActions().setAddAction(arg_0 -> KubernetesProxySettingsTable._init_$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> KubernetesProxySettingsTable._init_$lambda$1(this, arg_0)).createPanel(), "Center");
    }

    private final boolean getAutoDetectServerPath() {
        return this.autoDetectAppendServerPathJBCheckBox.isSelected();
    }

    private final void setAutoDetectServerPath(boolean value) {
        this.autoDetectAppendServerPathJBCheckBox.setSelected(value);
    }

    @Override
    public boolean isModified() {
        return !Intrinsics.areEqual((Object)KubernetesApiGlobalSettings.Companion.getInstance().getContextProxyCustomParameters(), this.getParametersSet()) || this.getAutoDetectServerPath() != KubernetesApiProjectSettings.Companion.getInstance(this.project).getAutoDetectServerPath();
    }

    private final SortedSet<KubernetesApiSettings.ContextCustomProxyParameter> getParametersSet() {
        List list = this.customContextParametersTableView.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), KubernetesProxySettingsTable::getParametersSet$lambda$0), KubernetesProxySettingsTable::getParametersSet$lambda$1));
    }

    @Override
    public void apply() {
        KubernetesApiGlobalSettings.Companion.getInstance().setContextProxyCustomParameters((Set)this.getParametersSet());
        KubernetesApiProjectSettings.Companion.getInstance(this.project).setAutoDetectServerPath(this.getAutoDetectServerPath());
    }

    @Override
    public void reset() {
        List items = CollectionsKt.toMutableList((Collection)KubernetesApiGlobalSettings.Companion.getInstance().getContextProxyCustomParameters());
        this.customContextParametersTableView.getListTableModel().setItems(items);
        this.setAutoDetectServerPath(KubernetesApiProjectSettings.Companion.getInstance(this.project).getAutoDetectServerPath());
    }

    private static final void _init_$lambda$0(KubernetesProxySettingsTable this$0, AnActionButton it) {
        this$0.customContextParametersTableView.stopEditing();
        ListTableModel model2 = this$0.customContextParametersTableView.getListTableModel();
        int index = model2.getRowCount();
        KubernetesApiSettings.ContextCustomProxyParameter newRow = new KubernetesApiSettings.ContextCustomProxyParameter(null, null, 3, null);
        model2.addRow((Object)newRow);
        this$0.customContextParametersTableView.setRowSelectionInterval(index, index);
        ActionsKt.invokeLater$default(null, () -> KubernetesProxySettingsTable.lambda$0$0(this$0, index), (int)1, null);
    }

    private static final Unit lambda$0$0(KubernetesProxySettingsTable this$0, int $index) {
        block1: {
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this$0.customContextParametersTableView));
            TableUtil.editCellAt((JTable)((JTable)this$0.customContextParametersTableView), (int)$index, (int)0);
            Component $this$asSafely$iv = this$0.customContextParametersTableView.getEditorComponent();
            boolean $i$f$asSafely = false;
            Component component = $this$asSafely$iv;
            if (!(component instanceof JTextComponent)) {
                component = null;
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            if (jTextComponent == null) break block1;
            jTextComponent.selectAll();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(KubernetesProxySettingsTable this$0, AnActionButton it) {
        this$0.customContextParametersTableView.stopEditing();
        TableUtil.removeSelectedItems((JTable)((JTable)this$0.customContextParametersTableView));
    }

    private static final KubernetesApiSettings.ContextCustomProxyParameter getParametersSet$lambda$0(KubernetesApiSettings.ContextCustomProxyParameter it) {
        char it2;
        char element$iv$iv;
        int index$iv$iv;
        CharSequence $this$filterTo$iv$iv;
        String $this$filter$iv = it.getContext();
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it2 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)"\"'", (char)it2, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        $this$filter$iv = it.getParameter();
        String string = ((StringBuilder)destination$iv$iv).toString();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new StringBuilder();
        $i$f$filterTo = false;
        n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it2 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)"\"'", (char)it2, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        String string3 = string;
        return new KubernetesApiSettings.ContextCustomProxyParameter(string3, string2);
    }

    private static final boolean getParametersSet$lambda$1(KubernetesApiSettings.ContextCustomProxyParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it.getContext()) && !StringsKt.isBlank((CharSequence)it.getParameter());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesProxySettingsTable$ContextColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$ContextCustomProxyParameter;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "intellij.clouds.kubernetes.backend"})
    private static final class ContextColumnInfo
    extends ColumnInfo<KubernetesApiSettings.ContextCustomProxyParameter, String> {
        public ContextColumnInfo() {
            super(KubernetesBundle.message((String)"KubernetesProxySettingsTable.ContextName.name", (Object[])new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getContext();
        }

        public boolean isCellEditable(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return true;
        }

        public void setValue(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            item.setContext(value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesProxySettingsTable$ParametersColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$ContextCustomProxyParameter;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "intellij.clouds.kubernetes.backend"})
    private static final class ParametersColumnInfo
    extends ColumnInfo<KubernetesApiSettings.ContextCustomProxyParameter, String> {
        public ParametersColumnInfo() {
            super(KubernetesBundle.message((String)"KubernetesProxySettingsTable.ParameterValue.name", (Object[])new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getParameter();
        }

        public boolean isCellEditable(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return true;
        }

        public void setValue(@NotNull KubernetesApiSettings.ContextCustomProxyParameter item, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            item.setParameter(value);
        }
    }
}

